/*
 * Decompiled with CFR 0.152.
 */
package tw.com.tp6gl4cj86.android_http_tool;

import android.app.Activity;
import android.content.Context;
import com.android.volley.NetworkResponse;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.android.volley.toolbox.StringRequest;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.json.JSONException;
import org.json.JSONObject;
import tw.com.tp6gl4cj86.android_http_tool.Listener.HttpListener;
import tw.com.tp6gl4cj86.android_http_tool.Listener.HttpListenerAdapter;
import tw.com.tp6gl4cj86.android_http_tool.Request.DataPart;
import tw.com.tp6gl4cj86.android_http_tool.Request.VolleyMultipartRequest;
import tw.com.tp6gl4cj86.android_http_tool.VolleySingleton;

public class HttpTool {
    private static HttpListenerAdapter mStaticHttpListenerAdapter;

    public static void setStaticHttpListenerAdapter(HttpListenerAdapter mStaticHttpListenerAdapter) {
        HttpTool.mStaticHttpListenerAdapter = mStaticHttpListenerAdapter;
    }

    public static void post(Activity activity, String url) {
        HttpTool.post(activity, url, new HashMap<String, String>(), null);
    }

    public static void post(Activity activity, String url, Map<String, String> params) {
        HttpTool.post(activity, url, params, null);
    }

    public static void post(Activity activity, String url, HttpListener httpListener) {
        HttpTool.post(activity, url, new HashMap<String, String>(), httpListener);
    }

    public static void post(Activity activity, String url, Map<String, String> params, HttpListener httpListener) {
        HttpTool.requestJSON(1, activity, url, params, httpListener);
    }

    public static void post(Activity activity, String url, Map<String, String> params, Map<String, DataPart> fileParams, HttpListener httpListener) {
        HttpTool.requestJSON(activity, url, params, fileParams, httpListener);
    }

    public static void get(Activity activity, String url) {
        HttpTool.get(activity, url, new HashMap<String, String>(), null);
    }

    public static void get(Activity activity, String url, Map<String, String> params) {
        HttpTool.get(activity, url, params, null);
    }

    public static void get(Activity activity, String url, HttpListener httpListener) {
        HttpTool.get(activity, url, new HashMap<String, String>(), httpListener);
    }

    public static void get(Activity activity, String url, Map<String, String> params, HttpListener httpListener) {
        HttpTool.requestString(0, activity, url, params, httpListener);
    }

    public static void requestString(int method, final Activity activity, final String url, final Map<String, String> params, final HttpListener httpListener) {
        StringRequest stringRequest = new StringRequest(method, url, (Response.Listener)new Response.Listener<String>(){

            public void onResponse(String response) {
                HttpTool.httpToolOnSuccessResponse(activity, HttpTool.getSuccessLog(url, params, response), httpListener, null, response);
            }
        }, HttpTool.getErrorListener(activity, httpListener)){

            protected Map<String, String> getParams() {
                return params;
            }
        };
        VolleySingleton.getInstance((Context)activity).addToRequestQueue(stringRequest);
    }

    public static void requestJSON(int method, final Activity activity, final String url, final Map<String, String> params, final HttpListener httpListener) {
        JsonObjectRequest jsonObjectRequest = new JsonObjectRequest(method, url, null, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                HttpTool.httpToolOnSuccessResponse(activity, HttpTool.getSuccessLog(url, params, response.toString()), httpListener, response, null);
            }
        }, HttpTool.getErrorListener(activity, httpListener)){

            protected Map<String, String> getParams() {
                return params;
            }
        };
        VolleySingleton.getInstance((Context)activity).addToRequestQueue(jsonObjectRequest);
    }

    public static void requestJSON(final Activity activity, final String url, final Map<String, String> params, final Map<String, DataPart> fileParams, final HttpListener httpListener) {
        VolleyMultipartRequest multipartRequest = new VolleyMultipartRequest(1, url, (Response.Listener)new Response.Listener<NetworkResponse>(){

            public void onResponse(NetworkResponse response) {
                try {
                    JSONObject json = new JSONObject(new String(response.data));
                    HttpTool.httpToolOnSuccessResponse(activity, HttpTool.getSuccessLog(url, params, json.toString()), httpListener, json, null);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, HttpTool.getErrorListener(activity, httpListener)){

            protected Map<String, String> getParams() {
                return params;
            }

            @Override
            protected Map<String, DataPart> getByteData() {
                return fileParams;
            }
        };
        VolleySingleton.getInstance((Context)activity).addToRequestQueue(multipartRequest);
    }

    public static DataPart getDataPart(File file, String mimeType) throws IOException {
        return new DataPart(file.getAbsolutePath(), FileUtils.readFileToByteArray((File)file), mimeType);
    }

    private static String getSuccessLog(String url, Map<String, String> params, String response) {
        return "url : " + url + "\nparams : " + (params != null ? params.toString() : "") + "\nresponse : " + response;
    }

    private static void httpToolOnSuccessResponse(Activity activity, String log, HttpListener httpListener, JSONObject jsonResponse, String stringResponse) {
        if (!(jsonResponse == null && stringResponse == null || activity.isFinishing())) {
            if (httpListener != null && jsonResponse != null) {
                try {
                    httpListener.onSuccess(jsonResponse, log);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            if (httpListener != null && stringResponse != null) {
                httpListener.onSuccess(stringResponse, log);
            }
            if (mStaticHttpListenerAdapter != null) {
                mStaticHttpListenerAdapter.onSuccess(stringResponse, log);
            }
        }
    }

    private static Response.ErrorListener getErrorListener(final Activity activity, final HttpListener httpListener) {
        return new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                HttpTool.httpToolOnErrorResponse(error, activity, httpListener);
            }
        };
    }

    private static void httpToolOnErrorResponse(VolleyError error, Activity activity, HttpListener httpListener) {
        if (!activity.isFinishing()) {
            String errorStr = "VolleyError : " + error.getMessage() + "\nVolleyError body " + new String(error.networkResponse.data);
            if (httpListener != null) {
                httpListener.onFailure(errorStr);
            }
            if (mStaticHttpListenerAdapter != null) {
                mStaticHttpListenerAdapter.onFailure(errorStr);
            }
        }
    }
}

