/*
 * Decompiled with CFR 0.152.
 */
package tw.com.tp6gl4cj86.android_http_tool;

import android.app.Activity;
import android.content.Context;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;
import tw.com.tp6gl4cj86.android_http_tool.Listener.HttpListener;
import tw.com.tp6gl4cj86.android_http_tool.Listener.HttpListenerAdapter;
import tw.com.tp6gl4cj86.android_http_tool.VolleySingleton;

public class HttpTool {
    private static HttpListenerAdapter mStaticHttpListenerAdapter;

    public static void setStaticHttpListenerAdapter(HttpListenerAdapter mStaticHttpListenerAdapter) {
        HttpTool.mStaticHttpListenerAdapter = mStaticHttpListenerAdapter;
    }

    public static void post(Activity activity, String url) {
        HttpTool.post(activity, url, new HashMap<String, String>(), null);
    }

    public static void post(Activity activity, String url, Map<String, String> params) {
        HttpTool.post(activity, url, params, null);
    }

    public static void post(Activity activity, String url, HttpListener httpListener) {
        HttpTool.post(activity, url, new HashMap<String, String>(), httpListener);
    }

    public static void post(final Activity activity, final String url, final Map<String, String> params, final HttpListener httpListener) {
        JsonObjectRequest jsonObjectRequest = new JsonObjectRequest(1, url, null, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                if (response != null && !activity.isFinishing()) {
                    try {
                        String log = "url : " + url + "\nparams : " + (params != null ? params.toString() : "") + "\nResponse : " + response.toString();
                        if (httpListener != null) {
                            httpListener.onSuccess(response, log);
                        }
                        if (mStaticHttpListenerAdapter != null) {
                            mStaticHttpListenerAdapter.onSuccess(response, log);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                if (!activity.isFinishing()) {
                    String errorStr = "VolleyError : " + error.getMessage() + "\nVolleyError body " + new String(error.networkResponse.data);
                    if (httpListener != null) {
                        httpListener.onFailure(errorStr);
                    }
                    if (mStaticHttpListenerAdapter != null) {
                        mStaticHttpListenerAdapter.onFailure(errorStr);
                    }
                }
            }
        }){

            protected Map<String, String> getParams() {
                return params;
            }
        };
        VolleySingleton.getInstance((Context)activity).addToRequestQueue(jsonObjectRequest);
    }
}

