/*
 * Decompiled with CFR 0.152.
 */
package tv.mycujoo.mcls.tv.player;

import android.animation.ObjectAnimator;
import android.os.Handler;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.test.espresso.idling.CountingIdlingResource;
import com.google.android.exoplayer2.Player;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import tv.mycujoo.domain.entity.Action;
import tv.mycujoo.mcls.core.AnnotationFactory;
import tv.mycujoo.mcls.core.BuildPoint;
import tv.mycujoo.mcls.helper.AnimationFactory;
import tv.mycujoo.mcls.helper.DownloaderClient;
import tv.mycujoo.mcls.helper.OverlayFactory;
import tv.mycujoo.mcls.helper.OverlayViewHelper;
import tv.mycujoo.mcls.manager.VariableKeeper;
import tv.mycujoo.mcls.manager.VariableTranslator;
import tv.mycujoo.mcls.manager.ViewHandler;
import tv.mycujoo.mcls.player.IPlayer;
import tv.mycujoo.mcls.tv.player.TvAnnotationListener;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ltv/mycujoo/mcls/tv/player/TvAnnotationMediator;", "", "player", "Ltv/mycujoo/mcls/player/IPlayer;", "overlayContainer", "Landroidx/constraintlayout/widget/ConstraintLayout;", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "handler", "Landroid/os/Handler;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "downloaderClient", "Ltv/mycujoo/mcls/helper/DownloaderClient;", "(Ltv/mycujoo/mcls/player/IPlayer;Landroidx/constraintlayout/widget/ConstraintLayout;Ljava/util/concurrent/ScheduledExecutorService;Landroid/os/Handler;Lkotlinx/coroutines/CoroutineScope;Ltv/mycujoo/mcls/helper/DownloaderClient;)V", "annotationFactory", "Ltv/mycujoo/mcls/core/AnnotationFactory;", "hasPendingSeek", "", "tvAnnotationListener", "Ltv/mycujoo/mcls/tv/player/TvAnnotationListener;", "variableKeeper", "Ltv/mycujoo/mcls/manager/VariableKeeper;", "variableTranslator", "Ltv/mycujoo/mcls/manager/VariableTranslator;", "viewHandler", "Ltv/mycujoo/mcls/manager/ViewHandler;", "feed", "", "actionsList", "", "Ltv/mycujoo/domain/entity/Action;", "mls_release"})
public final class TvAnnotationMediator {
    private AnnotationFactory annotationFactory;
    private TvAnnotationListener tvAnnotationListener;
    private final ViewHandler viewHandler;
    private final VariableTranslator variableTranslator;
    private final VariableKeeper variableKeeper;
    private boolean hasPendingSeek;

    public final void feed(@NotNull List<? extends Action> actionsList) {
        Intrinsics.checkParameterIsNotNull(actionsList, (String)"actionsList");
        this.annotationFactory.setActions(actionsList);
    }

    public TvAnnotationMediator(final @NotNull IPlayer player, @NotNull ConstraintLayout overlayContainer, @NotNull ScheduledExecutorService scheduler, @NotNull Handler handler, @NotNull CoroutineScope coroutineScope, @NotNull DownloaderClient downloaderClient) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)overlayContainer, (String)"overlayContainer");
        Intrinsics.checkParameterIsNotNull((Object)scheduler, (String)"scheduler");
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        Intrinsics.checkParameterIsNotNull((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkParameterIsNotNull((Object)downloaderClient, (String)"downloaderClient");
        this.viewHandler = new ViewHandler(new CountingIdlingResource("ViewIdentifierManager"));
        this.variableTranslator = new VariableTranslator(coroutineScope);
        this.variableKeeper = new VariableKeeper(coroutineScope);
        this.viewHandler.setOverlayHost(overlayContainer);
        OverlayViewHelper overlayViewHelper = new OverlayViewHelper(this.viewHandler, new OverlayFactory(), new AnimationFactory(), this.variableTranslator, this.variableKeeper);
        this.tvAnnotationListener = new TvAnnotationListener(overlayContainer, overlayViewHelper, downloaderClient);
        this.annotationFactory = new AnnotationFactory(this.tvAnnotationListener, this.variableKeeper);
        player.addListener(new Player.EventListener(){

            public void onPositionDiscontinuity(int reason) {
                if (reason == 1) {
                    hasPendingSeek = true;
                }
            }

            public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
                if (playbackState == 3 && hasPendingSeek) {
                    hasPendingSeek = false;
                    annotationFactory.build(new BuildPoint(player.currentPosition(), player.currentAbsoluteTime(), player, player.isPlaying()));
                }
            }

            public void onIsPlayingChanged(boolean isPlaying) {
                if (isPlaying) {
                    Iterable $this$forEach$iv = viewHandler.getAnimations();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ObjectAnimator it = (ObjectAnimator)element$iv;
                        boolean bl = false;
                        it.resume();
                    }
                } else {
                    Iterable $this$forEach$iv = viewHandler.getAnimations();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ObjectAnimator it = (ObjectAnimator)element$iv;
                        boolean bl = false;
                        it.pause();
                    }
                }
            }

            public void onPlaybackStateChanged(int state) {
            }
        });
        Runnable exoRunnable2 = new Runnable(this, player){
            final /* synthetic */ TvAnnotationMediator this$0;
            final /* synthetic */ IPlayer $player;

            public final void run() {
                if (this.$player.isPlaying()) {
                    TvAnnotationMediator.access$getAnnotationFactory$p(this.this$0).build(new BuildPoint(this.$player.currentPosition(), this.$player.currentAbsoluteTime(), this.$player, true));
                }
            }
            {
                this.this$0 = tvAnnotationMediator;
                this.$player = iPlayer;
            }
        };
        Runnable scheduledRunnable2 = new Runnable(handler, exoRunnable2){
            final /* synthetic */ Handler $handler;
            final /* synthetic */ Runnable $exoRunnable;

            public final void run() {
                this.$handler.post(this.$exoRunnable);
            }
            {
                this.$handler = handler;
                this.$exoRunnable = runnable;
            }
        };
        scheduler.scheduleAtFixedRate(scheduledRunnable2, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    public static final /* synthetic */ void access$setAnnotationFactory$p(TvAnnotationMediator $this, AnnotationFactory annotationFactory) {
        $this.annotationFactory = annotationFactory;
    }
}

