/*
 * Decompiled with CFR 0.152.
 */
package tv.mycujoo.mcls.tv.internal.transport;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.view.KeyEvent;
import android.view.View;
import androidx.leanback.media.PlaybackGlueHost;
import androidx.leanback.media.PlayerAdapter;
import androidx.leanback.widget.AbstractDetailsDescriptionPresenter;
import androidx.leanback.widget.Action;
import androidx.leanback.widget.ArrayObjectAdapter;
import androidx.leanback.widget.ObjectAdapter;
import androidx.leanback.widget.PlaybackControlsRow;
import androidx.leanback.widget.PlaybackRowPresenter;
import androidx.leanback.widget.PlaybackSeekDataProvider;
import androidx.leanback.widget.PlaybackSeekUi;
import androidx.leanback.widget.Presenter;
import androidx.leanback.widget.RowPresenter;
import java.lang.ref.WeakReference;
import tv.mycujoo.mcls.api.MLSTVConfiguration;
import tv.mycujoo.mcls.entity.msc.TVVideoPlayerConfig;
import tv.mycujoo.mcls.tv.internal.controller.ControllerAgent;
import tv.mycujoo.mcls.tv.internal.presenter.MLSPlaybackTransportRowPresenter;
import tv.mycujoo.mcls.tv.internal.transport.MLSPlaybackBaseControlGlue;
import tv.mycujoo.mcls.tv.widgets.MLSFastForwardAction;
import tv.mycujoo.mcls.tv.widgets.MLSPlayPauseAction;
import tv.mycujoo.mcls.tv.widgets.MLSRewindAction;

public class MLSPlaybackTransportControlGlueImpl<T extends PlayerAdapter>
extends MLSPlaybackBaseControlGlue<T> {
    static final String TAG = "PlaybackTransportGlue";
    static final boolean DEBUG = false;
    static final int MSG_UPDATE_PLAYBACK_STATE = 100;
    static final int UPDATE_PLAYBACK_STATE_DELAY_MS = 2000;
    PlaybackSeekDataProvider mSeekProvider;
    boolean mSeekEnabled;
    static final Handler sHandler = new UpdatePlaybackStateHandler();
    final WeakReference<MLSPlaybackTransportControlGlueImpl> mGlueWeakReference = new WeakReference<MLSPlaybackTransportControlGlueImpl>(this);
    final SeekUiClient mPlaybackSeekUiClient = new SeekUiClient();

    public MLSPlaybackTransportControlGlueImpl(Context context, T impl, MLSTVConfiguration config2, ControllerAgent controllerAgent) {
        super(context, impl, config2, controllerAgent);
    }

    @Override
    public void setControlsRow(PlaybackControlsRow controlsRow) {
        super.setControlsRow(controlsRow);
        sHandler.removeMessages(100, this.mGlueWeakReference);
        this.onUpdatePlaybackState();
    }

    @Override
    protected void onCreatePrimaryActions(ArrayObjectAdapter primaryActionsAdapter) {
        TVVideoPlayerConfig videoPlayerConfig = this.config.getVideoPlayerConfig();
        if (videoPlayerConfig.getShowBackForwardsButtons()) {
            this.mRewindAction = new MLSRewindAction(this.getContext(), 1, videoPlayerConfig.getPrimaryColor());
            primaryActionsAdapter.add((Object)this.mRewindAction);
        }
        this.mPlayPauseAction = new MLSPlayPauseAction(this.getContext(), videoPlayerConfig.getPrimaryColor());
        primaryActionsAdapter.add((Object)this.mPlayPauseAction);
        if (videoPlayerConfig.getShowBackForwardsButtons()) {
            this.mFastForwardAction = new MLSFastForwardAction(this.getContext(), 1, videoPlayerConfig.getPrimaryColor());
            primaryActionsAdapter.add((Object)this.mFastForwardAction);
        }
    }

    @Override
    protected PlaybackRowPresenter onCreateRowPresenter(ControllerAgent controllerAgent) {
        AbstractDetailsDescriptionPresenter detailsPresenter = new AbstractDetailsDescriptionPresenter(){

            protected void onBindDescription(AbstractDetailsDescriptionPresenter.ViewHolder viewHolder, Object obj) {
                MLSPlaybackBaseControlGlue glue = (MLSPlaybackBaseControlGlue)((Object)obj);
                viewHolder.getTitle().setText(glue.getTitle());
                viewHolder.getSubtitle().setText(glue.getSubtitle());
            }
        };
        MLSPlaybackTransportRowPresenter rowPresenter = new MLSPlaybackTransportRowPresenter(controllerAgent, this.config){

            @Override
            protected void onBindRowViewHolder(RowPresenter.ViewHolder vh, Object item) {
                super.onBindRowViewHolder(vh, item);
                vh.setOnKeyListener((View.OnKeyListener)MLSPlaybackTransportControlGlueImpl.this);
            }

            @Override
            protected void onUnbindRowViewHolder(RowPresenter.ViewHolder vh) {
                super.onUnbindRowViewHolder(vh);
                vh.setOnKeyListener(null);
            }
        };
        rowPresenter.setDescriptionPresenter((Presenter)detailsPresenter);
        return rowPresenter;
    }

    @Override
    protected void onAttachedToHost(PlaybackGlueHost host) {
        super.onAttachedToHost(host);
        if (host instanceof PlaybackSeekUi) {
            ((PlaybackSeekUi)host).setPlaybackSeekUiClient((PlaybackSeekUi.Client)this.mPlaybackSeekUiClient);
        }
    }

    @Override
    protected void onDetachedFromHost() {
        super.onDetachedFromHost();
        if (this.getHost() instanceof PlaybackSeekUi) {
            ((PlaybackSeekUi)this.getHost()).setPlaybackSeekUiClient(null);
        }
    }

    @Override
    protected void onUpdateProgress() {
        if (!this.mPlaybackSeekUiClient.mIsSeek) {
            super.onUpdateProgress();
        }
    }

    @Override
    public void onActionClicked(Action action) {
        this.dispatchAction(action, null);
    }

    @Override
    public boolean onKey(View v, int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 4: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 111: {
                return false;
            }
        }
        ObjectAdapter primaryActionsAdapter = this.getControlsRow().getPrimaryActionsAdapter();
        Action action = this.getControlsRow().getActionForKeyCode(primaryActionsAdapter, keyCode);
        if (action == null) {
            action = this.getControlsRow().getActionForKeyCode(this.getControlsRow().getSecondaryActionsAdapter(), keyCode);
        }
        if (action != null) {
            if (event.getAction() == 0) {
                this.dispatchAction(action, event);
            }
            return true;
        }
        return false;
    }

    void onUpdatePlaybackStatusAfterUserAction() {
        this.updatePlaybackState(this.isPlaying());
        sHandler.removeMessages(100, this.mGlueWeakReference);
        sHandler.sendMessageDelayed(sHandler.obtainMessage(100, this.mGlueWeakReference), 2000L);
    }

    boolean dispatchAction(Action action, KeyEvent keyEvent) {
        boolean handled = false;
        if (action instanceof MLSPlayPauseAction) {
            boolean canPause;
            boolean canPlay = keyEvent == null || keyEvent.getKeyCode() == 85 || keyEvent.getKeyCode() == 126;
            boolean bl = canPause = keyEvent == null || keyEvent.getKeyCode() == 85 || keyEvent.getKeyCode() == 127;
            if (canPause && this.mIsPlaying) {
                this.mIsPlaying = false;
                this.pause();
            } else if (canPlay && !this.mIsPlaying) {
                this.mIsPlaying = true;
                this.play();
            }
            this.onUpdatePlaybackStatusAfterUserAction();
            handled = true;
        } else if (action instanceof PlaybackControlsRow.SkipNextAction) {
            this.next();
            handled = true;
        } else if (action instanceof PlaybackControlsRow.SkipPreviousAction) {
            this.previous();
            handled = true;
        } else if (action instanceof MLSRewindAction) {
            this.rewind();
            handled = true;
        } else if (action instanceof MLSFastForwardAction) {
            this.fastForward();
            handled = true;
        }
        return handled;
    }

    @Override
    protected void onPlayStateChanged() {
        if (sHandler.hasMessages(100, this.mGlueWeakReference)) {
            sHandler.removeMessages(100, this.mGlueWeakReference);
            if (this.mPlayerAdapter.isPlaying() != this.mIsPlaying) {
                sHandler.sendMessageDelayed(sHandler.obtainMessage(100, this.mGlueWeakReference), 2000L);
            } else {
                this.onUpdatePlaybackState();
            }
        } else {
            this.onUpdatePlaybackState();
        }
        super.onPlayStateChanged();
    }

    void onUpdatePlaybackState() {
        this.mIsPlaying = this.mPlayerAdapter.isPlaying();
        this.updatePlaybackState(this.mIsPlaying);
    }

    private void updatePlaybackState(boolean isPlaying) {
        if (this.mControlsRow == null) {
            return;
        }
        if (!isPlaying) {
            this.onUpdateProgress();
            this.mPlayerAdapter.setProgressUpdatingEnabled(this.mPlaybackSeekUiClient.mIsSeek);
        } else {
            this.mPlayerAdapter.setProgressUpdatingEnabled(true);
        }
        if (this.mFadeWhenPlaying && this.getHost() != null) {
            this.getHost().setControlsOverlayAutoHideEnabled(isPlaying);
        }
        if (this.mPlayPauseAction != null) {
            int index;
            int n = index = !isPlaying ? 0 : 1;
            if (this.mPlayPauseAction.getIndex() != index) {
                this.mPlayPauseAction.setIndex(index);
                MLSPlaybackTransportControlGlueImpl.notifyItemChanged((ArrayObjectAdapter)this.getControlsRow().getPrimaryActionsAdapter(), (Object)this.mPlayPauseAction);
            }
        }
    }

    public final void setSeekProvider(PlaybackSeekDataProvider seekProvider) {
        this.mSeekProvider = seekProvider;
    }

    public final PlaybackSeekDataProvider getSeekProvider() {
        return this.mSeekProvider;
    }

    public final void setSeekEnabled(boolean seekEnabled) {
        this.mSeekEnabled = seekEnabled;
    }

    public final boolean isSeekEnabled() {
        return this.mSeekEnabled;
    }

    class SeekUiClient
    extends PlaybackSeekUi.Client {
        boolean mPausedBeforeSeek;
        long mPositionBeforeSeek;
        long mLastUserPosition;
        boolean mIsSeek;

        SeekUiClient() {
        }

        public PlaybackSeekDataProvider getPlaybackSeekDataProvider() {
            return MLSPlaybackTransportControlGlueImpl.this.mSeekProvider;
        }

        public boolean isSeekEnabled() {
            return MLSPlaybackTransportControlGlueImpl.this.mSeekProvider != null || MLSPlaybackTransportControlGlueImpl.this.mSeekEnabled;
        }

        public void onSeekStarted() {
            this.mIsSeek = true;
            this.mPausedBeforeSeek = !MLSPlaybackTransportControlGlueImpl.this.isPlaying();
            MLSPlaybackTransportControlGlueImpl.this.mPlayerAdapter.setProgressUpdatingEnabled(true);
            this.mPositionBeforeSeek = MLSPlaybackTransportControlGlueImpl.this.mSeekProvider == null ? MLSPlaybackTransportControlGlueImpl.this.mPlayerAdapter.getCurrentPosition() : -1L;
            this.mLastUserPosition = -1L;
            MLSPlaybackTransportControlGlueImpl.this.pause();
        }

        public void onSeekPositionChanged(long pos) {
            if (MLSPlaybackTransportControlGlueImpl.this.mSeekProvider == null) {
                MLSPlaybackTransportControlGlueImpl.this.mPlayerAdapter.seekTo(pos);
            } else {
                this.mLastUserPosition = pos;
            }
            if (MLSPlaybackTransportControlGlueImpl.this.mControlsRow != null) {
                MLSPlaybackTransportControlGlueImpl.this.mControlsRow.setCurrentPosition(pos);
            }
        }

        public void onSeekFinished(boolean cancelled) {
            if (!cancelled) {
                if (this.mLastUserPosition >= 0L) {
                    MLSPlaybackTransportControlGlueImpl.this.seekTo(this.mLastUserPosition);
                }
            } else if (this.mPositionBeforeSeek >= 0L) {
                MLSPlaybackTransportControlGlueImpl.this.seekTo(this.mPositionBeforeSeek);
            }
            this.mIsSeek = false;
            if (!this.mPausedBeforeSeek) {
                MLSPlaybackTransportControlGlueImpl.this.play();
            } else {
                MLSPlaybackTransportControlGlueImpl.this.mPlayerAdapter.setProgressUpdatingEnabled(false);
                MLSPlaybackTransportControlGlueImpl.this.onUpdateProgress();
            }
        }
    }

    static class UpdatePlaybackStateHandler
    extends Handler {
        UpdatePlaybackStateHandler() {
        }

        public void handleMessage(Message msg) {
            MLSPlaybackTransportControlGlueImpl glue;
            if (msg.what == 100 && (glue = (MLSPlaybackTransportControlGlueImpl)((Object)((WeakReference)msg.obj).get())) != null) {
                glue.onUpdatePlaybackState();
            }
        }
    }
}

