/*
 * Decompiled with CFR 0.152.
 */
package tv.mycujoo.mcls.tv.internal.transport;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import androidx.annotation.CallSuper;
import androidx.leanback.media.PlaybackGlue;
import androidx.leanback.media.PlaybackGlueHost;
import androidx.leanback.media.PlayerAdapter;
import androidx.leanback.widget.Action;
import androidx.leanback.widget.ArrayObjectAdapter;
import androidx.leanback.widget.ControlButtonPresenterSelector;
import androidx.leanback.widget.ObjectAdapter;
import androidx.leanback.widget.OnActionClickedListener;
import androidx.leanback.widget.PlaybackControlsRow;
import androidx.leanback.widget.PlaybackRowPresenter;
import androidx.leanback.widget.PresenterSelector;
import androidx.leanback.widget.Row;
import java.util.List;
import tv.mycujoo.mcls.api.MLSTVConfiguration;
import tv.mycujoo.mcls.tv.internal.controller.ControllerAgent;
import tv.mycujoo.mcls.tv.widgets.MLSFastForwardAction;
import tv.mycujoo.mcls.tv.widgets.MLSPlayPauseAction;
import tv.mycujoo.mcls.tv.widgets.MLSRewindAction;

public abstract class MLSPlaybackBaseControlGlue<T extends PlayerAdapter>
extends PlaybackGlue
implements OnActionClickedListener,
View.OnKeyListener {
    public static final int ACTION_CUSTOM_LEFT_FIRST = 1;
    public static final int ACTION_SKIP_TO_PREVIOUS = 16;
    public static final int ACTION_REWIND = 32;
    public static final int ACTION_PLAY_PAUSE = 64;
    public static final int ACTION_FAST_FORWARD = 128;
    public static final int ACTION_SKIP_TO_NEXT = 256;
    public static final int ACTION_REPEAT = 512;
    public static final int ACTION_SHUFFLE = 1024;
    public static final int ACTION_CUSTOM_RIGHT_FIRST = 4096;
    static final String TAG = "PlaybackTransportGlue";
    static final boolean DEBUG = false;
    public final T mPlayerAdapter;
    public PlaybackControlsRow mControlsRow;
    PlaybackRowPresenter mControlsRowPresenter;
    public MLSPlayPauseAction mPlayPauseAction;
    public MLSRewindAction mRewindAction;
    public MLSFastForwardAction mFastForwardAction;
    public boolean mIsPlaying = false;
    public boolean mFadeWhenPlaying = true;
    CharSequence mSubtitle;
    CharSequence mTitle;
    Drawable mCover;
    PlaybackGlueHost.PlayerCallback mPlayerCallback;
    boolean mBuffering = false;
    int mVideoWidth = 0;
    int mVideoHeight = 0;
    boolean mErrorSet = false;
    int mErrorCode;
    String mErrorMessage;
    MLSTVConfiguration config;
    ControllerAgent controllerAgent;
    final PlayerAdapter.Callback mAdapterCallback = new PlayerAdapter.Callback(){

        public void onPlayStateChanged(PlayerAdapter wrapper) {
            MLSPlaybackBaseControlGlue.this.onPlayStateChanged();
        }

        public void onCurrentPositionChanged(PlayerAdapter wrapper) {
            MLSPlaybackBaseControlGlue.this.onUpdateProgress();
        }

        public void onBufferedPositionChanged(PlayerAdapter wrapper) {
            MLSPlaybackBaseControlGlue.this.onUpdateBufferedProgress();
        }

        public void onDurationChanged(PlayerAdapter wrapper) {
            MLSPlaybackBaseControlGlue.this.onUpdateDuration();
        }

        public void onPlayCompleted(PlayerAdapter wrapper) {
            MLSPlaybackBaseControlGlue.this.onPlayCompleted();
        }

        public void onPreparedStateChanged(PlayerAdapter wrapper) {
            MLSPlaybackBaseControlGlue.this.onPreparedStateChanged();
        }

        public void onVideoSizeChanged(PlayerAdapter wrapper, int width, int height) {
            MLSPlaybackBaseControlGlue.this.mVideoWidth = width;
            MLSPlaybackBaseControlGlue.this.mVideoHeight = height;
            if (MLSPlaybackBaseControlGlue.this.mPlayerCallback != null) {
                MLSPlaybackBaseControlGlue.this.mPlayerCallback.onVideoSizeChanged(width, height);
            }
        }

        public void onError(PlayerAdapter wrapper, int errorCode, String errorMessage) {
            MLSPlaybackBaseControlGlue.this.mErrorSet = true;
            MLSPlaybackBaseControlGlue.this.mErrorCode = errorCode;
            MLSPlaybackBaseControlGlue.this.mErrorMessage = errorMessage;
            if (MLSPlaybackBaseControlGlue.this.mPlayerCallback != null) {
                MLSPlaybackBaseControlGlue.this.mPlayerCallback.onError(errorCode, (CharSequence)errorMessage);
            }
        }

        public void onBufferingStateChanged(PlayerAdapter wrapper, boolean start) {
            MLSPlaybackBaseControlGlue.this.mBuffering = start;
            MLSPlaybackBaseControlGlue.this.controllerAgent.onBufferingStateChanged(start);
        }

        public void onMetadataChanged(PlayerAdapter wrapper) {
            MLSPlaybackBaseControlGlue.this.onMetadataChanged();
        }
    };

    public MLSPlaybackBaseControlGlue(Context context, T impl, MLSTVConfiguration config2, ControllerAgent controllerAgent) {
        super(context);
        this.mPlayerAdapter = impl;
        this.mPlayerAdapter.setCallback(this.mAdapterCallback);
        this.config = config2;
        this.controllerAgent = controllerAgent;
    }

    public final T getPlayerAdapter() {
        return this.mPlayerAdapter;
    }

    protected void onAttachedToHost(PlaybackGlueHost host) {
        super.onAttachedToHost(host);
        host.setOnKeyInterceptListener((View.OnKeyListener)this);
        host.setOnActionClickedListener((OnActionClickedListener)this);
        this.onCreateDefaultControlsRow();
        this.onCreateDefaultRowPresenter();
        host.setPlaybackRowPresenter(this.getPlaybackRowPresenter());
        host.setPlaybackRow((Row)this.getControlsRow());
        this.mPlayerCallback = host.getPlayerCallback();
        this.onAttachHostCallback();
        this.mPlayerAdapter.onAttachedToHost(host);
    }

    void onAttachHostCallback() {
        if (this.mPlayerCallback != null) {
            if (this.mVideoWidth != 0 && this.mVideoHeight != 0) {
                this.mPlayerCallback.onVideoSizeChanged(this.mVideoWidth, this.mVideoHeight);
            }
            if (this.mErrorSet) {
                this.mPlayerCallback.onError(this.mErrorCode, (CharSequence)this.mErrorMessage);
            }
            this.controllerAgent.onBufferingStateChanged(this.mBuffering);
        }
    }

    void onDetachHostCallback() {
        this.mErrorSet = false;
        this.mErrorCode = 0;
        this.mErrorMessage = null;
        this.controllerAgent.onBufferingStateChanged(false);
    }

    protected void onHostStart() {
        this.mPlayerAdapter.setProgressUpdatingEnabled(true);
    }

    protected void onHostStop() {
        this.mPlayerAdapter.setProgressUpdatingEnabled(false);
    }

    protected void onDetachedFromHost() {
        this.onDetachHostCallback();
        this.mPlayerCallback = null;
        this.mPlayerAdapter.onDetachedFromHost();
        this.mPlayerAdapter.setProgressUpdatingEnabled(false);
        super.onDetachedFromHost();
    }

    void onCreateDefaultControlsRow() {
        if (this.mControlsRow == null) {
            PlaybackControlsRow controlsRow = new PlaybackControlsRow((Object)this);
            this.setControlsRow(controlsRow);
        }
    }

    void onCreateDefaultRowPresenter() {
        if (this.mControlsRowPresenter == null) {
            this.setPlaybackRowPresenter(this.onCreateRowPresenter(this.controllerAgent));
        }
    }

    protected abstract PlaybackRowPresenter onCreateRowPresenter(ControllerAgent var1);

    public void setControlsOverlayAutoHideEnabled(boolean enable) {
        this.mFadeWhenPlaying = enable;
        if (!this.mFadeWhenPlaying && this.getHost() != null) {
            this.getHost().setControlsOverlayAutoHideEnabled(false);
        }
    }

    public boolean isControlsOverlayAutoHideEnabled() {
        return this.mFadeWhenPlaying;
    }

    public void setControlsRow(PlaybackControlsRow controlsRow) {
        this.mControlsRow = controlsRow;
        this.mControlsRow.setCurrentPosition(-1L);
        this.mControlsRow.setDuration(-1L);
        this.mControlsRow.setBufferedPosition(-1L);
        if (this.mControlsRow.getPrimaryActionsAdapter() == null) {
            ArrayObjectAdapter adapter = new ArrayObjectAdapter((PresenterSelector)new ControlButtonPresenterSelector());
            this.onCreatePrimaryActions(adapter);
            this.mControlsRow.setPrimaryActionsAdapter((ObjectAdapter)adapter);
        }
        if (this.mControlsRow.getSecondaryActionsAdapter() == null) {
            ArrayObjectAdapter secondaryActions = new ArrayObjectAdapter((PresenterSelector)new ControlButtonPresenterSelector());
            this.onCreateSecondaryActions(secondaryActions);
            this.getControlsRow().setSecondaryActionsAdapter((ObjectAdapter)secondaryActions);
        }
        this.updateControlsRow();
    }

    public void setPlaybackRowPresenter(PlaybackRowPresenter presenter) {
        this.mControlsRowPresenter = presenter;
    }

    public PlaybackControlsRow getControlsRow() {
        return this.mControlsRow;
    }

    public PlaybackRowPresenter getPlaybackRowPresenter() {
        return this.mControlsRowPresenter;
    }

    public abstract void onActionClicked(Action var1);

    public abstract boolean onKey(View var1, int var2, KeyEvent var3);

    private void updateControlsRow() {
        this.onMetadataChanged();
    }

    public final boolean isPlaying() {
        return this.mPlayerAdapter.isPlaying();
    }

    public void play() {
        this.mPlayerAdapter.play();
    }

    public void pause() {
        this.mPlayerAdapter.pause();
    }

    public void next() {
        this.mPlayerAdapter.next();
    }

    public void previous() {
        this.mPlayerAdapter.previous();
    }

    public void rewind() {
        long currentPosition = this.getCurrentPosition();
        if (currentPosition < 0L) {
            return;
        }
        if (currentPosition > 10000L) {
            this.seekTo(currentPosition - 10000L);
        } else {
            this.seekTo(0L);
        }
    }

    public void fastForward() {
        long currentPosition = this.getCurrentPosition();
        long duration = this.getDuration();
        if (currentPosition < 0L || duration < 0L) {
            return;
        }
        if (currentPosition + 1000L < duration) {
            this.seekTo(currentPosition + 10000L);
        } else {
            this.seekTo(duration);
        }
    }

    protected static void notifyItemChanged(ArrayObjectAdapter adapter, Object object) {
        int index = adapter.indexOf(object);
        if (index >= 0) {
            adapter.notifyArrayItemRangeChanged(index, 1);
        }
    }

    protected void onCreatePrimaryActions(ArrayObjectAdapter primaryActionsAdapter) {
    }

    protected void onCreateSecondaryActions(ArrayObjectAdapter secondaryActionsAdapter) {
    }

    @CallSuper
    protected void onUpdateProgress() {
        if (this.mControlsRow != null) {
            this.mControlsRow.setCurrentPosition(this.mPlayerAdapter.isPrepared() ? this.getCurrentPosition() : -1L);
        }
    }

    @CallSuper
    protected void onUpdateBufferedProgress() {
        if (this.mControlsRow != null) {
            this.mControlsRow.setBufferedPosition(this.mPlayerAdapter.getBufferedPosition());
        }
    }

    @CallSuper
    protected void onUpdateDuration() {
        if (this.mControlsRow != null) {
            this.mControlsRow.setDuration(this.mPlayerAdapter.isPrepared() ? this.mPlayerAdapter.getDuration() : -1L);
        }
    }

    public final long getDuration() {
        return this.mPlayerAdapter.getDuration();
    }

    public long getCurrentPosition() {
        return this.mPlayerAdapter.getCurrentPosition();
    }

    public final long getBufferedPosition() {
        return this.mPlayerAdapter.getBufferedPosition();
    }

    public final boolean isPrepared() {
        return this.mPlayerAdapter.isPrepared();
    }

    @CallSuper
    protected void onPreparedStateChanged() {
        this.onUpdateDuration();
        List callbacks = this.getPlayerCallbacks();
        if (callbacks != null) {
            int size = callbacks.size();
            for (int i = 0; i < size; ++i) {
                ((PlaybackGlue.PlayerCallback)callbacks.get(i)).onPreparedStateChanged((PlaybackGlue)this);
            }
        }
    }

    public void setArt(Drawable cover) {
        if (this.mCover == cover) {
            return;
        }
        this.mCover = cover;
        this.mControlsRow.setImageDrawable(this.mCover);
        if (this.getHost() != null) {
            this.getHost().notifyPlaybackRowChanged();
        }
    }

    public Drawable getArt() {
        return this.mCover;
    }

    public void setSubtitle(CharSequence subtitle) {
        if (TextUtils.equals(subtitle, this.mSubtitle)) {
            return;
        }
        this.mSubtitle = subtitle;
        if (this.getHost() != null) {
            this.getHost().notifyPlaybackRowChanged();
        }
    }

    public CharSequence getSubtitle() {
        return this.mSubtitle;
    }

    public void setTitle(CharSequence title) {
        if (TextUtils.equals(title, this.mTitle)) {
            return;
        }
        this.mTitle = title;
        if (this.getHost() != null) {
            this.getHost().notifyPlaybackRowChanged();
        }
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    protected void onMetadataChanged() {
        if (this.mControlsRow == null) {
            return;
        }
        this.mControlsRow.setImageDrawable(this.getArt());
        this.mControlsRow.setDuration(this.getDuration());
        this.mControlsRow.setCurrentPosition(this.getCurrentPosition());
        if (this.getHost() != null) {
            this.getHost().notifyPlaybackRowChanged();
        }
    }

    @CallSuper
    protected void onPlayStateChanged() {
        List callbacks = this.getPlayerCallbacks();
        if (callbacks != null) {
            int size = callbacks.size();
            for (int i = 0; i < size; ++i) {
                ((PlaybackGlue.PlayerCallback)callbacks.get(i)).onPlayStateChanged((PlaybackGlue)this);
            }
        }
    }

    @CallSuper
    protected void onPlayCompleted() {
        List callbacks = this.getPlayerCallbacks();
        if (callbacks != null) {
            int size = callbacks.size();
            for (int i = 0; i < size; ++i) {
                ((PlaybackGlue.PlayerCallback)callbacks.get(i)).onPlayCompleted((PlaybackGlue)this);
            }
        }
    }

    public final void seekTo(long position) {
        this.mPlayerAdapter.seekTo(position);
    }

    public long getSupportedActions() {
        return this.mPlayerAdapter.getSupportedActions();
    }
}

