/*
 * Decompiled with CFR 0.152.
 */
package tv.mycujoo.mcls.tv.internal.presenter;

import android.content.Context;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.leanback.widget.ObjectAdapter;
import androidx.leanback.widget.PlaybackControlsRow;
import androidx.leanback.widget.Presenter;
import tv.mycujoo.mcls.R;
import tv.mycujoo.mcls.tv.internal.presenter.MLSControlBarPresenter;
import tv.mycujoo.mcls.utils.MathUtils;

public class MLSPlaybackControlPresenter
extends MLSControlBarPresenter {
    private boolean mMoreActionsEnabled = true;
    private static int sChildMarginBigger;
    private static int sChildMarginBiggest;

    static void formatTime(long seconds, StringBuilder sb) {
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        seconds -= minutes * 60L;
        minutes -= hours * 60L;
        sb.setLength(0);
        if (hours > 0L) {
            sb.append(hours).append(':');
            if (minutes < 10L) {
                sb.append('0');
            }
        }
        sb.append(minutes).append(':');
        if (seconds < 10L) {
            sb.append('0');
        }
        sb.append(seconds);
    }

    public MLSPlaybackControlPresenter(int layoutResourceId) {
        super(layoutResourceId);
    }

    public void enableSecondaryActions(boolean enable) {
        this.mMoreActionsEnabled = enable;
    }

    public boolean areMoreActionsEnabled() {
        return this.mMoreActionsEnabled;
    }

    public void setProgressColor(ViewHolder vh, @ColorInt int color2) {
        ClipDrawable drawable2 = new ClipDrawable((Drawable)new ColorDrawable(color2), 3, 1);
        ((LayerDrawable)vh.mProgressBar.getProgressDrawable()).setDrawableByLayerId(16908301, (Drawable)drawable2);
    }

    public void setTotalTime(ViewHolder vh, int ms) {
        this.setTotalTimeLong(vh, ms);
    }

    public void setTotalTimeLong(ViewHolder vh, long ms) {
        vh.setTotalTime(ms);
    }

    public int getTotalTime(ViewHolder vh) {
        return MathUtils.Companion.safeLongToInt(this.getTotalTimeLong(vh));
    }

    public long getTotalTimeLong(ViewHolder vh) {
        return vh.getTotalTime();
    }

    public void setCurrentTime(ViewHolder vh, int ms) {
        this.setCurrentTimeLong(vh, ms);
    }

    public void setCurrentTimeLong(ViewHolder vh, long ms) {
        vh.setCurrentTime(ms);
    }

    public int getCurrentTime(ViewHolder vh) {
        return MathUtils.Companion.safeLongToInt(this.getCurrentTimeLong(vh));
    }

    public long getCurrentTimeLong(ViewHolder vh) {
        return vh.getCurrentTime();
    }

    public void setSecondaryProgress(ViewHolder vh, int progressMs) {
        this.setSecondaryProgressLong(vh, progressMs);
    }

    public void setSecondaryProgressLong(ViewHolder vh, long progressMs) {
        vh.setSecondaryProgress(progressMs);
    }

    public int getSecondaryProgress(ViewHolder vh) {
        return MathUtils.Companion.safeLongToInt(this.getSecondaryProgressLong(vh));
    }

    public long getSecondaryProgressLong(ViewHolder vh) {
        return vh.getSecondaryProgress();
    }

    public void showPrimaryActions(ViewHolder vh) {
        if (vh.mMoreActionsShowing) {
            vh.toggleMoreActions();
        }
    }

    public void resetFocus(ViewHolder vh) {
        vh.mControlBar.requestFocus();
    }

    public void enableTimeMargins(ViewHolder vh, boolean enable) {
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)vh.mCurrentTime.getLayoutParams();
        lp.setMarginStart(enable ? vh.mCurrentTimeMarginStart : 0);
        vh.mCurrentTime.setLayoutParams((ViewGroup.LayoutParams)lp);
        lp = (ViewGroup.MarginLayoutParams)vh.mTotalTime.getLayoutParams();
        lp.setMarginEnd(enable ? vh.mTotalTimeMarginEnd : 0);
        vh.mTotalTime.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    @Override
    public Presenter.ViewHolder onCreateViewHolder(ViewGroup parent) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(this.getLayoutResourceId(), parent, false);
        return new MLSControlBarPresenter.ViewHolder(v);
    }

    @Override
    public void onBindViewHolder(Presenter.ViewHolder holder, Object item) {
        ViewHolder vh = (ViewHolder)holder;
        BoundData data = (BoundData)item;
        if (vh.mMoreActionsAdapter != data.secondaryActionsAdapter) {
            vh.mMoreActionsAdapter = data.secondaryActionsAdapter;
            vh.mMoreActionsAdapter.registerObserver(vh.mMoreActionsObserver);
            vh.mMoreActionsShowing = false;
        }
        super.onBindViewHolder(holder, item);
        vh.showMoreActions(this.mMoreActionsEnabled);
    }

    @Override
    public void onUnbindViewHolder(Presenter.ViewHolder holder) {
        super.onUnbindViewHolder(holder);
        ViewHolder vh = (ViewHolder)holder;
        if (vh.mMoreActionsAdapter != null) {
            vh.mMoreActionsAdapter.unregisterObserver(vh.mMoreActionsObserver);
            vh.mMoreActionsAdapter = null;
        }
    }

    int getChildMarginBigger(Context context) {
        if (sChildMarginBigger == 0) {
            sChildMarginBigger = context.getResources().getDimensionPixelSize(R.dimen.lb_playback_controls_child_margin_bigger);
        }
        return sChildMarginBigger;
    }

    int getChildMarginBiggest(Context context) {
        if (sChildMarginBiggest == 0) {
            sChildMarginBiggest = context.getResources().getDimensionPixelSize(R.dimen.lb_playback_controls_child_margin_biggest);
        }
        return sChildMarginBiggest;
    }

    class ViewHolder
    extends MLSControlBarPresenter.ViewHolder {
        ObjectAdapter mMoreActionsAdapter;
        ObjectAdapter.DataObserver mMoreActionsObserver;
        final FrameLayout mMoreActionsDock;
        Presenter.ViewHolder mMoreActionsViewHolder;
        boolean mMoreActionsShowing;
        final TextView mCurrentTime;
        final TextView mTotalTime;
        final ProgressBar mProgressBar;
        long mCurrentTimeInMs;
        long mTotalTimeInMs;
        long mSecondaryProgressInMs;
        StringBuilder mTotalTimeStringBuilder;
        StringBuilder mCurrentTimeStringBuilder;
        int mCurrentTimeMarginStart;
        int mTotalTimeMarginEnd;

        ViewHolder(View rootView) {
            super(rootView);
            this.mCurrentTimeInMs = -1L;
            this.mTotalTimeInMs = -1L;
            this.mSecondaryProgressInMs = -1L;
            this.mTotalTimeStringBuilder = new StringBuilder();
            this.mCurrentTimeStringBuilder = new StringBuilder();
            this.mMoreActionsDock = (FrameLayout)rootView.findViewById(R.id.more_actions_dock);
            this.mCurrentTime = (TextView)rootView.findViewById(R.id.current_time);
            this.mTotalTime = (TextView)rootView.findViewById(R.id.total_time);
            this.mProgressBar = (ProgressBar)rootView.findViewById(R.id.playback_progress);
            this.mMoreActionsObserver = new ObjectAdapter.DataObserver(){

                public void onChanged() {
                    if (ViewHolder.this.mMoreActionsShowing) {
                        ViewHolder.this.showControls(ViewHolder.this.mPresenter);
                    }
                }

                public void onItemRangeChanged(int positionStart, int itemCount) {
                    if (ViewHolder.this.mMoreActionsShowing) {
                        for (int i = 0; i < itemCount; ++i) {
                            ViewHolder.this.bindControlToAction(positionStart + i, ViewHolder.this.mPresenter);
                        }
                    }
                }
            };
            this.mCurrentTimeMarginStart = ((ViewGroup.MarginLayoutParams)this.mCurrentTime.getLayoutParams()).getMarginStart();
            this.mTotalTimeMarginEnd = ((ViewGroup.MarginLayoutParams)this.mTotalTime.getLayoutParams()).getMarginEnd();
        }

        void showMoreActions(boolean show) {
            if (show) {
                if (this.mMoreActionsViewHolder == null) {
                    PlaybackControlsRow.MoreActions action = new PlaybackControlsRow.MoreActions(this.mMoreActionsDock.getContext());
                    this.mMoreActionsViewHolder = this.mPresenter.onCreateViewHolder((ViewGroup)this.mMoreActionsDock);
                    this.mPresenter.onBindViewHolder(this.mMoreActionsViewHolder, (Object)action);
                    this.mPresenter.setOnClickListener(this.mMoreActionsViewHolder, new View.OnClickListener(){

                        public void onClick(View v) {
                            ViewHolder.this.toggleMoreActions();
                        }
                    });
                }
                if (this.mMoreActionsViewHolder.view.getParent() == null) {
                    this.mMoreActionsDock.addView(this.mMoreActionsViewHolder.view);
                }
            } else if (this.mMoreActionsViewHolder != null && this.mMoreActionsViewHolder.view.getParent() != null) {
                this.mMoreActionsDock.removeView(this.mMoreActionsViewHolder.view);
            }
        }

        void toggleMoreActions() {
            this.mMoreActionsShowing = !this.mMoreActionsShowing;
            this.showControls(this.mPresenter);
        }

        @Override
        ObjectAdapter getDisplayedAdapter() {
            return this.mMoreActionsShowing ? this.mMoreActionsAdapter : this.mAdapter;
        }

        @Override
        int getChildMarginFromCenter(Context context, int numControls) {
            int margin = MLSPlaybackControlPresenter.this.getControlIconWidth(context);
            margin = numControls < 4 ? (margin += MLSPlaybackControlPresenter.this.getChildMarginBiggest(context)) : (numControls < 6 ? (margin += MLSPlaybackControlPresenter.this.getChildMarginBigger(context)) : (margin += MLSPlaybackControlPresenter.this.getChildMarginDefault(context)));
            return margin;
        }

        void setTotalTime(long totalTimeMs) {
            if (totalTimeMs <= 0L) {
                this.mTotalTime.setVisibility(8);
                this.mProgressBar.setVisibility(8);
            } else {
                this.mTotalTime.setVisibility(0);
                this.mProgressBar.setVisibility(0);
                this.mTotalTimeInMs = totalTimeMs;
                MLSPlaybackControlPresenter.formatTime(totalTimeMs / 1000L, this.mTotalTimeStringBuilder);
                this.mTotalTime.setText((CharSequence)this.mTotalTimeStringBuilder.toString());
                this.mProgressBar.setMax(Integer.MAX_VALUE);
            }
        }

        long getTotalTime() {
            return this.mTotalTimeInMs;
        }

        void setCurrentTime(long currentTimeMs) {
            long seconds = currentTimeMs / 1000L;
            if (currentTimeMs != this.mCurrentTimeInMs) {
                this.mCurrentTimeInMs = currentTimeMs;
                MLSPlaybackControlPresenter.formatTime(seconds, this.mCurrentTimeStringBuilder);
                this.mCurrentTime.setText((CharSequence)this.mCurrentTimeStringBuilder.toString());
            }
            double ratio = (double)this.mCurrentTimeInMs / (double)this.mTotalTimeInMs;
            double progressRatio = ratio * 2.147483647E9;
            this.mProgressBar.setProgress((int)progressRatio);
        }

        long getCurrentTime() {
            return this.mTotalTimeInMs;
        }

        void setSecondaryProgress(long progressMs) {
            this.mSecondaryProgressInMs = progressMs;
            double ratio = (double)progressMs / (double)this.mTotalTimeInMs;
            double progressRatio = ratio * 2.147483647E9;
            this.mProgressBar.setSecondaryProgress((int)progressRatio);
        }

        long getSecondaryProgress() {
            return this.mSecondaryProgressInMs;
        }
    }

    static class BoundData
    extends MLSControlBarPresenter.BoundData {
        ObjectAdapter secondaryActionsAdapter;

        BoundData() {
        }
    }
}

