/*
 * Decompiled with CFR 0.152.
 */
package tv.mycujoo.domain.entity;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.mycujoo.domain.entity.AnimationType;
import tv.mycujoo.domain.entity.OverlayAct;
import tv.mycujoo.domain.entity.SvgData;
import tv.mycujoo.domain.entity.TransitionSpec;
import tv.mycujoo.domain.entity.ViewSpec;
import tv.mycujoo.mcls.helper.AnimationClassifierHelper;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u001b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f\u00a2\u0006\u0002\u0010\rJ\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010*\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010+\u001a\u00020\u0007H\u00c6\u0003J\t\u0010,\u001a\u00020\tH\u00c6\u0003J\t\u0010-\u001a\u00020\tH\u00c6\u0003J\u000f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u00c6\u0003JM\u0010/\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u00c6\u0001J\u0013\u00100\u001a\u00020\u00172\b\u00101\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00102\u001a\u000203H\u00d6\u0001J\u0010\u00104\u001a\u00020\u00172\u0006\u00105\u001a\u000206H\u0002J\u0010\u00107\u001a\u00020\u00172\u0006\u00105\u001a\u000206H\u0002J\u0010\u00108\u001a\u00020\u00172\u0006\u00105\u001a\u000206H\u0002J\u0010\u00109\u001a\u00020\u00172\u0006\u00105\u001a\u000206H\u0002J\u0010\u0010:\u001a\u00020\u00172\u0006\u00105\u001a\u000206H\u0002J\t\u0010;\u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010<\u001a\u00020=2\u0006\u00105\u001a\u000206R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0018\"\u0004\b\u001c\u0010\u001aR\u001a\u0010\n\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0013\"\u0004\b\u001e\u0010\u0015R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(\u00a8\u0006>"}, d2={"Ltv/mycujoo/domain/entity/OverlayEntity;", "", "id", "", "svgData", "Ltv/mycujoo/domain/entity/SvgData;", "viewSpec", "Ltv/mycujoo/domain/entity/ViewSpec;", "introTransitionSpec", "Ltv/mycujoo/domain/entity/TransitionSpec;", "outroTransitionSpec", "variablePlaceHolders", "", "(Ljava/lang/String;Ltv/mycujoo/domain/entity/SvgData;Ltv/mycujoo/domain/entity/ViewSpec;Ltv/mycujoo/domain/entity/TransitionSpec;Ltv/mycujoo/domain/entity/TransitionSpec;Ljava/util/List;)V", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "getIntroTransitionSpec", "()Ltv/mycujoo/domain/entity/TransitionSpec;", "setIntroTransitionSpec", "(Ltv/mycujoo/domain/entity/TransitionSpec;)V", "isDownloading", "", "()Z", "setDownloading", "(Z)V", "isOnScreen", "setOnScreen", "getOutroTransitionSpec", "setOutroTransitionSpec", "getSvgData", "()Ltv/mycujoo/domain/entity/SvgData;", "setSvgData", "(Ltv/mycujoo/domain/entity/SvgData;)V", "getVariablePlaceHolders", "()Ljava/util/List;", "getViewSpec", "()Ltv/mycujoo/domain/entity/ViewSpec;", "setViewSpec", "(Ltv/mycujoo/domain/entity/ViewSpec;)V", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "introIsInCurrentTimeRange", "currentTime", "", "isLingeringInIntroAnimation", "isLingeringInMidway", "isLingeringInOutroAnimation", "outroIsInCurrentTimeRange", "toString", "update", "Ltv/mycujoo/domain/entity/OverlayAct;", "mls_release"})
public final class OverlayEntity {
    private boolean isDownloading;
    private boolean isOnScreen;
    @NotNull
    private String id;
    @Nullable
    private SvgData svgData;
    @NotNull
    private ViewSpec viewSpec;
    @NotNull
    private TransitionSpec introTransitionSpec;
    @NotNull
    private TransitionSpec outroTransitionSpec;
    @NotNull
    private final List<String> variablePlaceHolders;

    public final boolean isDownloading() {
        return this.isDownloading;
    }

    public final void setDownloading(boolean bl) {
        this.isDownloading = bl;
    }

    public final boolean isOnScreen() {
        return this.isOnScreen;
    }

    public final void setOnScreen(boolean bl) {
        this.isOnScreen = bl;
    }

    @NotNull
    public final OverlayAct update(long currentTime) {
        if (this.isDownloading) {
            return OverlayAct.DO_NOTHING;
        }
        if (!this.isOnScreen && this.introIsInCurrentTimeRange(currentTime)) {
            return OverlayAct.INTRO;
        }
        if (this.isOnScreen && this.outroIsInCurrentTimeRange(currentTime)) {
            return OverlayAct.OUTRO;
        }
        return OverlayAct.DO_NOTHING;
    }

    private final boolean introIsInCurrentTimeRange(long currentTime) {
        return this.introTransitionSpec.getOffset() >= currentTime && this.introTransitionSpec.getOffset() < currentTime + 1000L;
    }

    private final boolean outroIsInCurrentTimeRange(long currentTime) {
        if (this.outroTransitionSpec.getAnimationType() == AnimationType.NONE) {
            return false;
        }
        return this.outroTransitionSpec.getOffset() >= currentTime && this.outroTransitionSpec.getOffset() < currentTime + 1000L;
    }

    private final boolean isLingeringInIntroAnimation(long currentTime) {
        if (this.introTransitionSpec.getOffset() > currentTime) {
            return false;
        }
        long leftBound = this.introTransitionSpec.getOffset();
        long rightBound = this.introTransitionSpec.getOffset() + this.introTransitionSpec.getAnimationDuration();
        return leftBound <= currentTime && currentTime < rightBound;
    }

    private final boolean isLingeringInMidway(long currentTime) {
        Function1<Long, Boolean> $fun$isLingeringUnbounded$1 = new Function1<Long, Boolean>(this){
            final /* synthetic */ OverlayEntity this$0;

            public final boolean invoke(long currentTime) {
                if (this.this$0.getIntroTransitionSpec().getOffset() > currentTime) {
                    return false;
                }
                if (this.this$0.getOutroTransitionSpec().getAnimationType() == AnimationType.NONE || this.this$0.getOutroTransitionSpec().getAnimationDuration() == -1L) {
                    return AnimationClassifierHelper.Companion.hasIntroAnimation(this.this$0.getIntroTransitionSpec().getAnimationType()) ? currentTime > this.this$0.getIntroTransitionSpec().getOffset() + this.this$0.getIntroTransitionSpec().getAnimationDuration() : currentTime > this.this$0.getIntroTransitionSpec().getOffset();
                }
                return false;
            }
            {
                this.this$0 = overlayEntity;
                super(1);
            }
        };
        Function1<Long, Boolean> $fun$isLingeringBounded$2 = new Function1<Long, Boolean>(this){
            final /* synthetic */ OverlayEntity this$0;

            public final boolean invoke(long currentTime) {
                if (this.this$0.getIntroTransitionSpec().getOffset() > currentTime) {
                    return false;
                }
                if (this.this$0.getOutroTransitionSpec().getOffset() == -1L || this.this$0.getOutroTransitionSpec().getAnimationDuration() == 0L) {
                    return false;
                }
                long leftBound = this.this$0.getIntroTransitionSpec().getOffset();
                long rightBound = 0L;
                if (AnimationClassifierHelper.Companion.hasIntroAnimation(this.this$0.getIntroTransitionSpec().getAnimationType())) {
                    leftBound = this.this$0.getIntroTransitionSpec().getOffset() + this.this$0.getIntroTransitionSpec().getAnimationDuration();
                }
                if (AnimationClassifierHelper.Companion.hasOutroAnimation(this.this$0.getOutroTransitionSpec().getAnimationType())) {
                    rightBound = this.this$0.getOutroTransitionSpec().getOffset();
                }
                return currentTime > leftBound && currentTime < rightBound;
            }
            {
                this.this$0 = overlayEntity;
                super(1);
            }
        };
        return $fun$isLingeringUnbounded$1.invoke(currentTime) || $fun$isLingeringBounded$2.invoke(currentTime);
    }

    private final boolean isLingeringInOutroAnimation(long currentTime) {
        if (this.introTransitionSpec.getOffset() > currentTime) {
            return false;
        }
        if (this.outroTransitionSpec.getAnimationDuration() == -1L || this.outroTransitionSpec.getAnimationDuration() > currentTime) {
            return false;
        }
        long leftBound = this.outroTransitionSpec.getOffset();
        long rightBound = this.outroTransitionSpec.getOffset() + this.outroTransitionSpec.getAnimationDuration();
        return leftBound <= currentTime && currentTime < rightBound;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final void setId(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        this.id = string2;
    }

    @Nullable
    public final SvgData getSvgData() {
        return this.svgData;
    }

    public final void setSvgData(@Nullable SvgData svgData) {
        this.svgData = svgData;
    }

    @NotNull
    public final ViewSpec getViewSpec() {
        return this.viewSpec;
    }

    public final void setViewSpec(@NotNull ViewSpec viewSpec) {
        Intrinsics.checkParameterIsNotNull((Object)viewSpec, (String)"<set-?>");
        this.viewSpec = viewSpec;
    }

    @NotNull
    public final TransitionSpec getIntroTransitionSpec() {
        return this.introTransitionSpec;
    }

    public final void setIntroTransitionSpec(@NotNull TransitionSpec transitionSpec) {
        Intrinsics.checkParameterIsNotNull((Object)transitionSpec, (String)"<set-?>");
        this.introTransitionSpec = transitionSpec;
    }

    @NotNull
    public final TransitionSpec getOutroTransitionSpec() {
        return this.outroTransitionSpec;
    }

    public final void setOutroTransitionSpec(@NotNull TransitionSpec transitionSpec) {
        Intrinsics.checkParameterIsNotNull((Object)transitionSpec, (String)"<set-?>");
        this.outroTransitionSpec = transitionSpec;
    }

    @NotNull
    public final List<String> getVariablePlaceHolders() {
        return this.variablePlaceHolders;
    }

    public OverlayEntity(@NotNull String id2, @Nullable SvgData svgData, @NotNull ViewSpec viewSpec, @NotNull TransitionSpec introTransitionSpec, @NotNull TransitionSpec outroTransitionSpec, @NotNull List<String> variablePlaceHolders) {
        Intrinsics.checkParameterIsNotNull((Object)id2, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)viewSpec, (String)"viewSpec");
        Intrinsics.checkParameterIsNotNull((Object)introTransitionSpec, (String)"introTransitionSpec");
        Intrinsics.checkParameterIsNotNull((Object)outroTransitionSpec, (String)"outroTransitionSpec");
        Intrinsics.checkParameterIsNotNull(variablePlaceHolders, (String)"variablePlaceHolders");
        this.id = id2;
        this.svgData = svgData;
        this.viewSpec = viewSpec;
        this.introTransitionSpec = introTransitionSpec;
        this.outroTransitionSpec = outroTransitionSpec;
        this.variablePlaceHolders = variablePlaceHolders;
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    @Nullable
    public final SvgData component2() {
        return this.svgData;
    }

    @NotNull
    public final ViewSpec component3() {
        return this.viewSpec;
    }

    @NotNull
    public final TransitionSpec component4() {
        return this.introTransitionSpec;
    }

    @NotNull
    public final TransitionSpec component5() {
        return this.outroTransitionSpec;
    }

    @NotNull
    public final List<String> component6() {
        return this.variablePlaceHolders;
    }

    @NotNull
    public final OverlayEntity copy(@NotNull String id2, @Nullable SvgData svgData, @NotNull ViewSpec viewSpec, @NotNull TransitionSpec introTransitionSpec, @NotNull TransitionSpec outroTransitionSpec, @NotNull List<String> variablePlaceHolders) {
        Intrinsics.checkParameterIsNotNull((Object)id2, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)viewSpec, (String)"viewSpec");
        Intrinsics.checkParameterIsNotNull((Object)introTransitionSpec, (String)"introTransitionSpec");
        Intrinsics.checkParameterIsNotNull((Object)outroTransitionSpec, (String)"outroTransitionSpec");
        Intrinsics.checkParameterIsNotNull(variablePlaceHolders, (String)"variablePlaceHolders");
        return new OverlayEntity(id2, svgData, viewSpec, introTransitionSpec, outroTransitionSpec, variablePlaceHolders);
    }

    public static /* synthetic */ OverlayEntity copy$default(OverlayEntity overlayEntity, String string2, SvgData svgData, ViewSpec viewSpec, TransitionSpec transitionSpec, TransitionSpec transitionSpec2, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = overlayEntity.id;
        }
        if ((n & 2) != 0) {
            svgData = overlayEntity.svgData;
        }
        if ((n & 4) != 0) {
            viewSpec = overlayEntity.viewSpec;
        }
        if ((n & 8) != 0) {
            transitionSpec = overlayEntity.introTransitionSpec;
        }
        if ((n & 0x10) != 0) {
            transitionSpec2 = overlayEntity.outroTransitionSpec;
        }
        if ((n & 0x20) != 0) {
            list = overlayEntity.variablePlaceHolders;
        }
        return overlayEntity.copy(string2, svgData, viewSpec, transitionSpec, transitionSpec2, list);
    }

    @NotNull
    public String toString() {
        return "OverlayEntity(id=" + this.id + ", svgData=" + this.svgData + ", viewSpec=" + this.viewSpec + ", introTransitionSpec=" + this.introTransitionSpec + ", outroTransitionSpec=" + this.outroTransitionSpec + ", variablePlaceHolders=" + this.variablePlaceHolders + ")";
    }

    public int hashCode() {
        String string2 = this.id;
        SvgData svgData = this.svgData;
        ViewSpec viewSpec = this.viewSpec;
        TransitionSpec transitionSpec = this.introTransitionSpec;
        TransitionSpec transitionSpec2 = this.outroTransitionSpec;
        List<String> list = this.variablePlaceHolders;
        return (((((string2 != null ? string2.hashCode() : 0) * 31 + (svgData != null ? ((Object)svgData).hashCode() : 0)) * 31 + (viewSpec != null ? ((Object)viewSpec).hashCode() : 0)) * 31 + (transitionSpec != null ? ((Object)transitionSpec).hashCode() : 0)) * 31 + (transitionSpec2 != null ? ((Object)transitionSpec2).hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof OverlayEntity)) break block3;
                OverlayEntity overlayEntity = (OverlayEntity)object;
                if (!Intrinsics.areEqual((Object)this.id, (Object)overlayEntity.id) || !Intrinsics.areEqual((Object)this.svgData, (Object)overlayEntity.svgData) || !Intrinsics.areEqual((Object)this.viewSpec, (Object)overlayEntity.viewSpec) || !Intrinsics.areEqual((Object)this.introTransitionSpec, (Object)overlayEntity.introTransitionSpec) || !Intrinsics.areEqual((Object)this.outroTransitionSpec, (Object)overlayEntity.outroTransitionSpec) || !Intrinsics.areEqual(this.variablePlaceHolders, overlayEntity.variablePlaceHolders)) break block3;
            }
            return true;
        }
        return false;
    }
}

