/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.pm.ApplicationInfo;
import android.content.res.Resources;
import android.graphics.Picture;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.PictureDrawable;
import android.net.Uri;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.provider.Settings;
import android.text.format.Formatter;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.DatePicker;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.media3.common.Format;
import androidx.media3.common.TrackGroup;
import androidx.media3.common.TrackSelectionParameters;
import androidx.media3.common.Tracks;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.source.TrackGroupArray;
import androidx.media3.exoplayer.trackselection.DefaultTrackSelector;
import androidx.media3.exoplayer.trackselection.MappingTrackSelector;
import androidx.media3.ui.SubtitleView;
import com.caverock.androidsvg.SVG;
import com.caverock.androidsvg.SVGParseException;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tv.brid.domain.Language;
import tv.brid.domain.Player;
import tv.brid.domain.Track;
import tv.brid.domain.Video;
import tv.brid.sdk.AdIdCallback;
import tv.brid.sdk.R;
import tv.brid.sdk.brid_network.network.location.Location;

public class Utils {
    public static final String[] LANGUAGES = new String[]{"en", "es", "de", "fr", "it", "ru", "pt", "sr", "me", "hr", "bs", "sl"};

    public static void log(Object msg) {
    }

    public static void loadAdvertisingIdAsync(Context context, AdIdCallback callback2) {
        new Thread(() -> {
            HashMap<String, String> macros = new HashMap<String, String>();
            try {
                AdvertisingIdClient.Info adInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)context);
                if (adInfo != null) {
                    String rdid = adInfo.getId();
                    boolean isLat = adInfo.isLimitAdTrackingEnabled();
                    macros.put("rdid", isLat ? "" : (rdid != null ? rdid : ""));
                    macros.put("is_lat", isLat ? "1" : "0");
                    macros.put("idtype", "gaid");
                }
            }
            catch (Exception e) {
                macros.put("rdid", "");
                macros.put("is_lat", "0");
                macros.put("idtype", "gaid");
            }
            callback2.onAdIdReady(macros);
        }).start();
    }

    private static String generateGivn() {
        return UUID.randomUUID().toString();
    }

    public static String formatAdUrl(Context context, String baseUrl, HashMap<String, String> macroTargeting, long timestamp, int width, int height, Video video, Player player, Location location) {
        String custRaw;
        WifiManager wm;
        boolean splitCommaValuesIntoIndexedKeys = true;
        ApplicationInfo applicationInfo = context.getApplicationContext().getApplicationInfo();
        int stringId = applicationInfo.labelRes;
        String appName = stringId == 0 ? String.valueOf(applicationInfo.nonLocalizedLabel) : context.getApplicationContext().getString(stringId);
        String androidId = Settings.Secure.getString((ContentResolver)context.getApplicationContext().getContentResolver(), (String)"android_id");
        String videoTitle = Utils.nz(video.getName());
        String description = Utils.nz(video.getDescription());
        String videoDurSec = String.valueOf(video.getDuration());
        String mute = String.valueOf(player.getForce_muted());
        String videoID = String.valueOf(video.getId());
        String playerID = String.valueOf(player.getId());
        String autoplay = String.valueOf(player.getAutoplay());
        String originVideo = Utils.nz(video.getOrigin_video());
        String latitude = "";
        String longitude = "";
        if (location != null) {
            longitude = String.valueOf(location.getLongitude());
            latitude = String.valueOf(location.getLatitude());
        }
        String ip = (wm = (WifiManager)context.getApplicationContext().getSystemService("wifi")) != null && wm.getConnectionInfo() != null ? Formatter.formatIpAddress((int)wm.getConnectionInfo().getIpAddress()) : "0.0.0.0";
        try {
            AdvertisingIdClient.Info adInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)context.getApplicationContext());
            macroTargeting.put("rdid", adInfo != null && adInfo.getId() != null ? adInfo.getId() : "");
            macroTargeting.put("is_lat", adInfo != null && adInfo.isLimitAdTrackingEnabled() ? "1" : "0");
            macroTargeting.put("idtype", "gaid");
            macroTargeting.put("givn", Utils.generateGivn());
        }
        catch (Exception ignore) {
            macroTargeting.put("rdid", "");
            macroTargeting.put("is_lat", "0");
            macroTargeting.put("idtype", "gaid");
        }
        macroTargeting.put("ip", ip != null ? ip : "0.0.0.0");
        Uri t = Uri.parse((String)baseUrl);
        String scheme = Utils.hasText(t.getScheme()) ? t.getScheme() : "https";
        String host = Utils.hasText(t.getHost()) ? t.getHost() : "pubads.g.doubleclick.net";
        String path = Utils.hasText(t.getPath()) ? t.getPath() : "/gampad/ads";
        String iu = t.getQueryParameter("iu");
        String sz = t.getQueryParameter("sz");
        Uri.Builder b = new Uri.Builder().scheme(scheme).authority(host).path(path);
        if (Utils.hasText(iu)) {
            b.appendQueryParameter("iu", iu);
        }
        if (Utils.hasText(sz)) {
            b.appendQueryParameter("sz", sz);
        }
        b.appendQueryParameter("gdfp_req", "1");
        b.appendQueryParameter("output", "vast");
        b.appendQueryParameter("unviewed_position_start", "1");
        b.appendQueryParameter("env", "vp");
        b.appendQueryParameter("impl", "s");
        long corr = timestamp > 0L ? timestamp / 1000L : System.currentTimeMillis() / 1000L;
        b.appendQueryParameter("correlator", String.valueOf(corr));
        String descriptionUrl = Utils.safeGet(macroTargeting, "description_url", "");
        if (Utils.hasText(descriptionUrl) && !Utils.isPlaceholder(descriptionUrl)) {
            b.appendQueryParameter("description_url", descriptionUrl);
        }
        LinkedHashMap<String, String> cust = new LinkedHashMap<String, String>();
        BiConsumer<String, String> putMulti = (key, value) -> {
            if (!Utils.hasText(value)) {
                return;
            }
            if (value.contains(",")) {
                int i = 1;
                for (String part : value.split(",")) {
                    String v = part.trim();
                    if (!Utils.hasText(v)) continue;
                    cust.put(key + "_" + i, v);
                    ++i;
                }
            } else {
                cust.put((String)key, value.trim());
            }
        };
        if (Build.VERSION.SDK_INT >= 24) {
            putMulti.accept("video_category", Utils.notPH(Utils.safeGet(macroTargeting, "video_channel", "")));
            putMulti.accept("video_tags", Utils.notPH(Utils.safeGet(macroTargeting, "video_tags", "")));
            putMulti.accept("video_title", Utils.notPH(Utils.safeGet(macroTargeting, "video_title", videoTitle)));
            putMulti.accept("video_id", Utils.notPH(Utils.safeGet(macroTargeting, "video_id", videoID)));
            putMulti.accept("video_iabt", Utils.notPH(Utils.safeGet(macroTargeting, "video_iab_categories", "")));
            putMulti.accept("video_origin", Utils.notPH(Utils.safeGet(macroTargeting, "video_origin", originVideo)));
        }
        if (Utils.hasText(playerID)) {
            cust.put("player_id", playerID);
        }
        if (Utils.hasText(videoDurSec)) {
            cust.put("video_duration", videoDurSec);
        }
        if (Utils.hasText(mute)) {
            cust.put("vpmute", mute);
        }
        if (Utils.hasText(autoplay)) {
            cust.put("autoplay", autoplay);
        }
        if (Utils.hasText(custRaw = Utils.joinAsRawQuery(cust))) {
            b.appendQueryParameter("cust_params", custRaw);
        }
        b.appendQueryParameter("tfcd", "0");
        b.appendQueryParameter("npa", "0");
        String finalUrl = b.build().toString();
        System.out.println("macro final url: " + finalUrl);
        return finalUrl;
    }

    private static String joinAsRawQuery(LinkedHashMap<String, String> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> e : map.entrySet()) {
            if (!Utils.hasText(e.getKey()) || e.getValue() == null) continue;
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(e.getKey()).append("=").append(e.getValue());
        }
        return sb.toString();
    }

    private static boolean hasText(String s) {
        return s != null && !s.trim().isEmpty();
    }

    private static String nz(String s) {
        return s == null ? "" : s;
    }

    private static boolean isPlaceholder(String s) {
        String t = s == null ? "" : s.trim();
        return t.startsWith("[") && t.endsWith("]");
    }

    private static String notPH(String v) {
        return Utils.isPlaceholder(v) ? "" : v;
    }

    private static String safeGet(Map<String, String> m, String key, String defVal) {
        if (m == null) {
            return defVal;
        }
        String v = m.get(key);
        return v == null ? defVal : v;
    }

    private static void putCustIfHasText(Map<String, String> m, String k, String v) {
        if (Utils.hasText(v)) {
            m.put(k, v);
        }
    }

    private static String joinAsRawQuery(Map<String, String> m) {
        if (m == null || m.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> e : m.entrySet()) {
            if (!first) {
                sb.append('&');
            }
            sb.append(e.getKey()).append('=').append(e.getValue());
            first = false;
        }
        return sb.toString();
    }

    public static String macroReplace(String url, String key, String value, HashMap<String, String> macroTargeting) {
        String customValue = macroTargeting.get(key);
        String values = value == null ? "" : value;
        return url.replace("[" + key + "]", customValue == null ? values : customValue);
    }

    public static String encodeString(String s) {
        if (s == null) {
            return "";
        }
        try {
            return URLEncoder.encode(s, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String getAdBreakXml(String url, String timeOffset, String breakId, int index) {
        return "<vmap:AdBreak timeOffset=\"" + timeOffset + "\" breakType=\"linear,nonlinear\" breakId=\"" + breakId + (breakId.equals("midroll") ? "-" + index : "") + "\"><vmap:AdSource id=\"" + breakId + (breakId.equals("midroll") ? "-ad-" + index : "") + "\" allowMultipleAds=\"false\" followRedirects=\"true\"><vmap:AdTagURI templateType=\"vast3\"><![CDATA[" + url + "]]></vmap:AdTagURI></vmap:AdSource></vmap:AdBreak>";
    }

    public static void ViewAnimate(View v, String type) {
        ObjectAnimator fadeOut = ObjectAnimator.ofFloat((Object)v, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        fadeOut.setDuration(300L);
        ObjectAnimator fadeIn = ObjectAnimator.ofFloat((Object)v, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        fadeIn.setDuration(300L);
        AnimatorSet mAnimationSet = new AnimatorSet();
        final String mType = type;
        mAnimationSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (mType.equals("fadeout")) {
                    // empty if block
                }
            }
        });
        if (type.equals("fadein")) {
            mAnimationSet.play((Animator)fadeIn);
        } else {
            mAnimationSet.play((Animator)fadeOut);
        }
        mAnimationSet.start();
    }

    public static void log(String filter, Class cls, String msg, String ... args) {
    }

    public static void log(Class cls, String msg, String ... args) {
        Utils.log("BridPlayer - Log", cls, msg, args);
    }

    public static float convertDpToPixel(float dp, Context context) {
        Resources resources = context.getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        float px = dp * ((float)metrics.densityDpi / 160.0f);
        return px;
    }

    public static float convertPixelsToDp(float px, Context context) {
        return px / ((float)context.getResources().getDisplayMetrics().densityDpi / 160.0f);
    }

    public static String convertStringToInt(String seconds) {
        int hours = 0;
        int minutes = 0;
        int remainingSeconds = 0;
        String timeString = "";
        try {
            int result = Integer.parseInt(seconds);
            hours = result / 3600;
            minutes = result % 3600 / 60;
            remainingSeconds = result % 60;
            timeString = hours == 0 && minutes == 0 ? remainingSeconds + " sec" : (hours == 0 ? (minutes >= 10 ? (remainingSeconds >= 10 ? "" + minutes + ":" + remainingSeconds : "" + minutes + ":0" + remainingSeconds) : (remainingSeconds >= 10 ? "0" + minutes + ":" + remainingSeconds : "0" + minutes + ":0" + remainingSeconds)) : (minutes >= 10 ? (remainingSeconds >= 10 ? hours + ":" + minutes + ":" + remainingSeconds : hours + ":" + minutes + ":0" + remainingSeconds) : (remainingSeconds >= 10 ? hours + ":0" + minutes + ":" + remainingSeconds : hours + ":0" + minutes + ":0" + remainingSeconds)));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return "0";
        }
        return timeString;
    }

    public static Drawable convertSvgToDrawable(String svgString, Context context) {
        try {
            String[] svgStr = svgString.split("><", 2);
            String[] dimensions = svgStr[0].split(" ");
            String width = dimensions[0];
            String height = dimensions[1];
            int test = Utils.convertDpToPx(24, context);
            String fill = "";
            String path = "";
            path = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"" + test + "\" height=\"" + test + "\"><" + svgStr[1] + "</svg>";
            SVG svg = SVG.getFromString((String)path);
            svg.setDocumentViewBox(0.0f, 0.0f, 24.0f, 24.0f);
            Picture picture = svg.renderToPicture();
            PictureDrawable drawable2 = new PictureDrawable(picture);
            return drawable2;
        }
        catch (SVGParseException | StringIndexOutOfBoundsException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static float convertPxToDp(float px, Context context) {
        return px / context.getResources().getDisplayMetrics().density;
    }

    public static int convertDpToPx(int dp, Context context) {
        return Math.round((float)dp * ((float)context.getResources().getDisplayMetrics().densityDpi / 160.0f));
    }

    public static String getTranslationByCode(Context context, String messageCode, String countryCode) {
        try {
            String errorCode = messageCode + "_" + countryCode;
            int resourceId = context.getResources().getIdentifier(errorCode, "string", context.getPackageName());
            if (resourceId != 0) {
                return context.getString(resourceId);
            }
            String defaultErrorCode = "network_error_" + countryCode;
            int defaultResourceId = context.getResources().getIdentifier(defaultErrorCode, "string", context.getPackageName());
            if (defaultResourceId != 0) {
                return context.getString(defaultResourceId);
            }
            return messageCode;
        }
        catch (Resources.NotFoundException e) {
            return messageCode;
        }
    }

    public static String isLanguageSupported(String searchString) {
        String defaultLanguage = "en";
        boolean found = Arrays.asList(LANGUAGES).contains(searchString);
        return found ? searchString : defaultLanguage;
    }

    public static Activity getActivityFromContext(Context context) {
        Context baseContext;
        if (context instanceof Activity) {
            return (Activity)context;
        }
        if (context instanceof ContextWrapper && (baseContext = ((ContextWrapper)context).getBaseContext()) instanceof Activity) {
            return (Activity)baseContext;
        }
        return null;
    }

    public static boolean isOlderThan(DatePicker datePicker, int years) {
        int year = datePicker.getYear();
        int month = datePicker.getMonth();
        int day = datePicker.getDayOfMonth();
        Calendar selectedDate = Calendar.getInstance();
        selectedDate.set(year, month, day);
        Calendar today = Calendar.getInstance();
        int age = today.get(1) - selectedDate.get(1);
        if (selectedDate.get(2) > today.get(2) || selectedDate.get(2) == today.get(2) && selectedDate.get(5) > today.get(5)) {
            --age;
        }
        return age >= years;
    }

    public static String convertVttToJpg(String url) {
        if (url != null && url.endsWith(".vtt")) {
            return url.replaceAll("\\.vtt$", ".jpg");
        }
        return url;
    }

    public static void changePlayPauseWithAnimationTv(boolean playWhenReady, Context context, ImageButton playPauseBtn) {
        Animation fadeOut = AnimationUtils.loadAnimation((Context)context, (int)R.anim.scale_and_fade);
        if (playWhenReady) {
            playPauseBtn.setImageResource(R.drawable.ic_play_tv);
        } else {
            playPauseBtn.setImageResource(R.drawable.ic_pause_tv);
        }
        playPauseBtn.startAnimation(fadeOut);
    }

    public static List<Language> extractLanguagesForCaptions(List<Track> tracks) {
        if (tracks == null) {
            return Collections.emptyList();
        }
        if (Build.VERSION.SDK_INT >= 24) {
            return tracks.stream().filter(track -> "captions".equalsIgnoreCase(track.getKind())).flatMap(track -> {
                if (track.getLanguages() == null) {
                    return Stream.empty();
                }
                return track.getLanguages().stream();
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @OptIn(markerClass={UnstableApi.class})
    public static List<Format> getAvailableSubtitleFormats(DefaultTrackSelector trackSelector) {
        ArrayList<Format> subtitles = new ArrayList<Format>();
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo = trackSelector.getCurrentMappedTrackInfo();
        if (mappedTrackInfo != null) {
            for (int rendererIndex = 0; rendererIndex < mappedTrackInfo.getRendererCount(); ++rendererIndex) {
                if (mappedTrackInfo.getRendererType(rendererIndex) != 3) continue;
                TrackGroupArray trackGroups = mappedTrackInfo.getTrackGroups(rendererIndex);
                for (int groupIndex = 0; groupIndex < trackGroups.length; ++groupIndex) {
                    TrackGroup trackGroup = trackGroups.get(groupIndex);
                    for (int trackIndex = 0; trackIndex < trackGroup.length; ++trackIndex) {
                        Format format = trackGroup.getFormat(trackIndex);
                        subtitles.add(format);
                    }
                }
            }
        }
        return subtitles;
    }

    @OptIn(markerClass={UnstableApi.class})
    public static void selectSubtitle(DefaultTrackSelector trackSelector, Format selectedFormatOrNull) {
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo = trackSelector.getCurrentMappedTrackInfo();
        if (mappedTrackInfo == null) {
            return;
        }
        for (int rendererIndex = 0; rendererIndex < mappedTrackInfo.getRendererCount(); ++rendererIndex) {
            if (mappedTrackInfo.getRendererType(rendererIndex) != 3) continue;
            TrackGroupArray trackGroups = mappedTrackInfo.getTrackGroups(rendererIndex);
            if (selectedFormatOrNull == null) {
                DefaultTrackSelector.Parameters parameters = trackSelector.buildUponParameters().clearSelectionOverrides(rendererIndex).setRendererDisabled(rendererIndex, true).build();
                trackSelector.setParameters((TrackSelectionParameters)parameters);
                return;
            }
            for (int groupIndex = 0; groupIndex < trackGroups.length; ++groupIndex) {
                TrackGroup group = trackGroups.get(groupIndex);
                for (int trackIndex = 0; trackIndex < group.length; ++trackIndex) {
                    Format format = group.getFormat(trackIndex);
                    if (!format.equals((Object)selectedFormatOrNull)) continue;
                    DefaultTrackSelector.SelectionOverride override = new DefaultTrackSelector.SelectionOverride(groupIndex, new int[]{trackIndex});
                    DefaultTrackSelector.Parameters parameters = trackSelector.buildUponParameters().setRendererDisabled(rendererIndex, false).setSelectionOverride(rendererIndex, trackGroups, override).build();
                    trackSelector.setParameters((TrackSelectionParameters)parameters);
                    return;
                }
            }
        }
    }

    @OptIn(markerClass={UnstableApi.class})
    public static void setSubtitleBottomOffset(SubtitleView subtitleView, int bottomMarginPx) {
        if (subtitleView == null) {
            return;
        }
        ViewGroup.LayoutParams params = subtitleView.getLayoutParams();
        if (params instanceof FrameLayout.LayoutParams) {
            FrameLayout.LayoutParams flp = (FrameLayout.LayoutParams)params;
            flp.bottomMargin = bottomMarginPx;
            subtitleView.setLayoutParams((ViewGroup.LayoutParams)flp);
        }
    }

    @OptIn(markerClass={UnstableApi.class})
    public static int getCurrentSubtitleIndex(DefaultTrackSelector trackSelector, List<Format> formats) {
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo = trackSelector.getCurrentMappedTrackInfo();
        if (mappedTrackInfo == null) {
            return 0;
        }
        for (int rendererIndex = 0; rendererIndex < mappedTrackInfo.getRendererCount(); ++rendererIndex) {
            if (mappedTrackInfo.getRendererType(rendererIndex) != 3) continue;
            TrackGroupArray trackGroups = mappedTrackInfo.getTrackGroups(rendererIndex);
            DefaultTrackSelector.SelectionOverride override = trackSelector.getParameters().getSelectionOverride(rendererIndex, trackGroups);
            if (override == null) continue;
            int groupIndex = override.groupIndex;
            int trackIndex = override.tracks[0];
            Format selected = trackGroups.get(groupIndex).getFormat(trackIndex);
            for (int i = 0; i < formats.size(); ++i) {
                if (!formats.get(i).equals((Object)selected)) continue;
                return i + 1;
            }
        }
        return 0;
    }

    @OptIn(markerClass={UnstableApi.class})
    public static boolean isSubtitleTrackSelected(DefaultTrackSelector trackSelector) {
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo = trackSelector.getCurrentMappedTrackInfo();
        if (mappedTrackInfo == null) {
            return false;
        }
        for (int rendererIndex = 0; rendererIndex < mappedTrackInfo.getRendererCount(); ++rendererIndex) {
            if (mappedTrackInfo.getRendererType(rendererIndex) != 3) continue;
            TrackGroupArray trackGroups = mappedTrackInfo.getTrackGroups(rendererIndex);
            DefaultTrackSelector.SelectionOverride override = trackSelector.getParameters().getSelectionOverride(rendererIndex, trackGroups);
            if (override == null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Format getActiveSubtitleFormat(Tracks tracks) {
        for (Tracks.Group group : tracks.getGroups()) {
            if (group.getType() != 3) continue;
            for (int i = 0; i < group.length; ++i) {
                if (!group.isTrackSelected(i)) continue;
                return group.getTrackFormat(i);
            }
        }
        return null;
    }

    public static int getSubtitleFormatIndex(Format activeFormat, List<Format> formats) {
        for (int i = 0; i < formats.size(); ++i) {
            if (!formats.get(i).equals((Object)activeFormat)) continue;
            return i + 1;
        }
        return 0;
    }
}

