/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.player.settings;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.PopupWindow;
import androidx.annotation.OptIn;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.ui.R;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.util.List;
import java.util.Map;
import tv.brid.sdk.player.settings.SettingsAdapter;

public abstract class OptionsList<T> {
    private PopupWindow settingsWindow;
    private RecyclerView settingsView;
    private int settingsWindowMargin;
    private View styledPlayerControlView;
    protected Context context;
    protected List<String> sources;
    protected String currentValue;

    public abstract void onSettingClicked(String var1);

    public abstract int setSelectedIndex();

    protected abstract List<String> convertMapToList(Map<String, T> var1);

    @OptIn(markerClass={UnstableApi.class})
    public OptionsList(View styledPlayerControlView, PopupWindow.OnDismissListener dismissListener, Map<String, T> sourcesMap, String currentValue) {
        this.currentValue = currentValue;
        this.styledPlayerControlView = styledPlayerControlView;
        this.sources = this.convertMapToList(sourcesMap);
        this.context = styledPlayerControlView.getContext();
        Resources resources = this.context.getResources();
        String[] settingTexts = new String[this.sources.size()];
        Drawable[] settingIcons = new Drawable[this.sources.size()];
        for (int i = 0; i < this.sources.size(); ++i) {
            settingTexts[i] = this.sources.get(i);
        }
        settingIcons[this.setSelectedIndex()] = resources.getDrawable(R.drawable.exo_ic_check);
        SettingsAdapter settingsAdapter = new SettingsAdapter(settingTexts, settingIcons, option -> {
            this.onSettingClicked(option);
            this.dismissPopupWindow();
        });
        this.settingsWindowMargin = this.context.getResources().getDimensionPixelSize(R.dimen.exo_settings_offset);
        this.settingsView = (RecyclerView)LayoutInflater.from((Context)this.context).inflate(R.layout.exo_styled_settings_list, null);
        this.settingsView.setAdapter((RecyclerView.Adapter)settingsAdapter);
        this.settingsView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.context));
        this.settingsWindow = new PopupWindow((View)this.settingsView, -2, -2, false);
        if (Util.SDK_INT < 23) {
            this.settingsWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        }
        this.settingsWindow.setOnDismissListener(dismissListener);
        this.displaySettingsWindow(settingsAdapter);
    }

    public void dismissPopupWindow() {
        this.settingsWindow.dismiss();
    }

    private void displaySettingsWindow(RecyclerView.Adapter<?> adapter) {
        this.settingsView.setAdapter(adapter);
        this.updateSettingsWindowSize();
        this.settingsWindow.dismiss();
        int xoff = this.styledPlayerControlView.getWidth() - this.settingsWindow.getWidth() - this.settingsWindowMargin;
        int yoff = -this.settingsWindow.getHeight() - this.settingsWindowMargin;
        this.settingsWindow.setOutsideTouchable(true);
        this.settingsWindow.showAsDropDown(this.styledPlayerControlView, xoff, yoff);
    }

    private void updateSettingsWindowSize() {
        this.settingsView.measure(0, 0);
        int maxWidth = this.styledPlayerControlView.getWidth() - this.settingsWindowMargin * 2;
        int itemWidth = this.settingsView.getMeasuredWidth();
        int width = Math.min(itemWidth, maxWidth);
        this.settingsWindow.setWidth(width);
        int maxHeight = this.styledPlayerControlView.getHeight() - this.settingsWindowMargin * 2;
        int totalHeight = this.settingsView.getMeasuredHeight();
        int height = Math.min(maxHeight, totalHeight);
        this.settingsWindow.setHeight(height);
    }

    public static boolean isInteger(String s, int radix) {
        if (s.isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!(i == 0 && s.charAt(i) == '-' ? s.length() == 1 : Character.digit(s.charAt(i), radix) < 0)) continue;
            return false;
        }
        return true;
    }
}

