/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.player.playback.playlist.loop.timer;

import android.content.Context;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatButton;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.Transformation;
import tv.brid.domain.Video;
import tv.brid.sdk.R;
import tv.brid.sdk.player.playback.playlist.loop.timer.CountableStepReciever;
import tv.brid.sdk.player.playback.playlist.loop.timer.CountingRunnable;
import tv.brid.sdk.player.ui.CountFinishedListener;
import tv.brid.sdk.player.ui.glide_transformation.GlideBlurTransformation;

public class CountablePlayView
extends FrameLayout
implements CountableStepReciever {
    private Handler handler;
    private ImageView poster;
    private ProgressBar progressBar;
    private CountingRunnable countingRunnable;
    private CountFinishedListener listener;
    private TextView txtTitle;
    private ImageButton playCountdown;
    private AppCompatButton btnCancel;

    public CountablePlayView(@NonNull Context context) {
        super(context);
        this.initAttributes(context, null);
    }

    public CountablePlayView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initAttributes(context, attrs);
    }

    public CountablePlayView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttributes(context, attrs);
    }

    public CountablePlayView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initAttributes(context, attrs);
    }

    private void initAttributes(Context context, AttributeSet attrs) {
        CountablePlayView.inflate((Context)context, (int)R.layout.countable_play_view, (ViewGroup)this);
        this.handler = new Handler();
        this.poster = (ImageView)this.findViewById(R.id.imgPoster);
        this.progressBar = (ProgressBar)this.findViewById(R.id.progressBar);
        this.playCountdown = (ImageButton)this.findViewById(R.id.play_countdown);
        this.playCountdown.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CountablePlayView.this.listener != null) {
                    CountablePlayView.this.listener.onCountdownFinished();
                }
            }
        });
        this.txtTitle = (TextView)this.findViewById(R.id.txtTitle);
        this.btnCancel = (AppCompatButton)this.findViewById(R.id.btnCancel);
        this.btnCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CountablePlayView.this.listener != null) {
                    CountablePlayView.this.listener.onCountdownCanceled();
                }
            }
        });
        this.countingRunnable = new CountingRunnable(this.handler, this);
        this.handler.post((Runnable)this.countingRunnable);
        this.playCountdown.requestFocus();
    }

    private void setProgress(int progress) {
        this.progressBar.setProgress(progress);
    }

    public void setPoster(Video video) {
        this.txtTitle.setText((CharSequence)video.getName());
        ((RequestBuilder)Glide.with((View)this.poster).load(video.getThumbnail()).transform((Transformation)new GlideBlurTransformation(this.getContext()))).into(this.poster);
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (!hasWindowFocus) {
            this.countingRunnable.pause();
        } else {
            this.countingRunnable.resume();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.countingRunnable != null) {
            this.countingRunnable.pause();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    @Override
    public void onStart() {
    }

    public void setCountFinishedListener(CountFinishedListener listener) {
        this.listener = listener;
    }

    @Override
    public void onCount(int step) {
        this.setProgress(step * 5);
    }

    @Override
    public void onEnd() {
        this.setProgress(100);
        if (this.listener != null) {
            this.listener.onCountdownFinished();
        }
    }
}

