/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.player.adapters;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import tv.brid.domain.Video;
import tv.brid.sdk.R;
import tv.brid.sdk.Utils;
import tv.brid.sdk.player.ui.Image;

public class PlaylistAdapter
extends ArrayAdapter {
    private static final int RESOURCE = R.layout.row_playlist_item;
    private ArrayList<Video> videoVOS;
    private int currentVideo;
    private int currentVideoBgColor;
    @DrawableRes
    private int placeholderResId = 0;

    public PlaylistAdapter(Context context, ArrayList<Video> videoVOS, int currentVideo) {
        super(context, RESOURCE, videoVOS);
        this.videoVOS = videoVOS;
        this.currentVideo = currentVideo;
        this.currentVideoBgColor = context.getResources().getColor(R.color.playListActiveBackground);
    }

    public void setCurrentVideo(int currentVideo) {
        this.currentVideo = currentVideo;
    }

    public void setPlaceholderResId(@DrawableRes int drawableRes) {
        this.placeholderResId = drawableRes;
    }

    public int getCount() {
        int count = super.getCount();
        return count;
    }

    @NonNull
    @SuppressLint(value={"ViewHolder"})
    public View getView(int position, View convertView, @NonNull ViewGroup parent) {
        LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
        convertView = inflater.inflate(RESOURCE, parent, false);
        convertView.findViewById(R.id.playlistItem).setBackgroundColor(position == this.currentVideo ? this.currentVideoBgColor : 0);
        ImageView imgVideo = (ImageView)convertView.findViewById(R.id.imgVideo);
        TextView txtVideo = (TextView)convertView.findViewById(R.id.txtVideo);
        TextView txtVideoDuration = (TextView)convertView.findViewById(R.id.txtVideoDuration);
        new Image().loadImageInView(this.videoVOS.get(position).getThumbnail(), imgVideo, 5, this.placeholderResId);
        txtVideo.setText((CharSequence)this.videoVOS.get(position).getName());
        txtVideoDuration.setText((CharSequence)Utils.convertStringToInt(this.videoVOS.get(position).getDuration()));
        return convertView;
    }
}

