/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.settings;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;

public final class Settings {
    private static SharedPreferences sharedPreferences;

    private Settings(Context context) {
        sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
    }

    public static Settings getInstance(Context context) {
        return new Settings(context);
    }

    public String getStringValue(String key) {
        return sharedPreferences.getString(key, "");
    }

    public int getIntValue(String key) {
        return sharedPreferences.getInt(key, -1);
    }

    private boolean getBooleanValue(String key) {
        return sharedPreferences.getBoolean(key, false);
    }

    private void setStringValue(String key, String value) {
        sharedPreferences.edit().putString(key, value).commit();
    }

    private void setIntValue(String key, int value) {
        sharedPreferences.edit().putInt(key, value).commit();
    }

    private void setBooleanValue(String key, boolean value) {
        sharedPreferences.edit().putBoolean(key, value).commit();
    }

    public void saveCaption(boolean caption) {
        this.setBooleanValue("SETTING_KEY_CAPTION", caption);
    }

    public boolean getCaption() {
        return this.getBooleanValue("SETTING_KEY_CAPTION");
    }

    public boolean getIsMuted() {
        return this.getBooleanValue("SETTING_KEY_IS_MUTED");
    }

    public void saveIsMutedStatus(boolean isMuted) {
        this.setBooleanValue("SETTING_KEY_IS_MUTED", isMuted);
    }
}

