/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.player.drm;

import android.content.Context;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.media3.common.C;
import androidx.media3.common.MediaItem;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DefaultHttpDataSource;
import androidx.media3.datasource.HttpDataSource;
import androidx.media3.datasource.TransferListener;
import androidx.media3.exoplayer.ExoPlayer;
import androidx.media3.exoplayer.dash.DashChunkSource;
import androidx.media3.exoplayer.dash.DashMediaSource;
import androidx.media3.exoplayer.dash.DefaultDashChunkSource;
import androidx.media3.exoplayer.drm.DrmSessionEventListener;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.upstream.DefaultBandwidthMeter;
import java.util.UUID;
import tv.brid.domain.Video;
import tv.brid.sdk.player.drm.OfflineRemoteLicenceFetcher;
import tv.brid.sdk.player.drm.store.BaseKeyStore;
import tv.brid.sdk.player.drm.store.DrmKeyVO;
import tv.brid.sdk.player.listeners.BridPlayerListener;

public class DRMPlayer {
    private ExoPlayer exoPlayer;
    private Video videoVO;
    private Context context;
    private BridPlayerListener mListener;
    private byte[] key;
    private String licenceURL = "";
    private String videoURL = "";

    public DRMPlayer(Context context, ExoPlayer exoPlayer, Video videoVO, BridPlayerListener listener) {
        this.context = context;
        this.exoPlayer = exoPlayer;
        this.videoVO = videoVO;
        this.mListener = listener;
        this.licenceURL = videoVO.getDrmConfigVO().getWidevine().getWidevineAlpha().getServerURL() + "&os=a&rd=3600";
        this.videoURL = videoVO.getDashUrl();
    }

    private void downloadLicence(String licenceUrl, String videoUrl) {
        DownloadLicenceTask downloadLicenceTask = new DownloadLicenceTask(this, this.context, licenceUrl, videoUrl, this.videoVO.getId());
        downloadLicenceTask.execute(new Object[0]);
    }

    @OptIn(markerClass={UnstableApi.class})
    public void playDRMVideo() {
        UUID drmSchemeUuid = C.WIDEVINE_UUID;
        BaseKeyStore baseKeyStore = BaseKeyStore.INSTANCE(this.context);
        DrmKeyVO drmKeyVO = baseKeyStore.get(String.valueOf(this.videoVO.getId()));
        boolean isLicenceExpired = this.isLicenceExpired(drmKeyVO);
        if (drmKeyVO != null && !isLicenceExpired) {
            this.key = drmKeyVO.getKey();
            DefaultHttpDataSource.Factory defaultHttpDataSourceFactory = new DefaultHttpDataSource.Factory().setTransferListener((TransferListener)new DefaultBandwidthMeter.Builder(this.context).setResetOnNetworkTypeChange(false).build());
            DefaultDashChunkSource.Factory dashChunkSourceFactory = new DefaultDashChunkSource.Factory((DataSource.Factory)defaultHttpDataSourceFactory);
            DefaultHttpDataSource.Factory manifestDataSourceFactory = new DefaultHttpDataSource.Factory();
            DashMediaSource.Factory msf = new DashMediaSource.Factory((DashChunkSource.Factory)dashChunkSourceFactory, (DataSource.Factory)manifestDataSourceFactory);
            MediaItem.DrmConfiguration.Builder drmConfiguration = new MediaItem.DrmConfiguration.Builder(drmSchemeUuid);
            drmConfiguration.setKeySetId(this.key);
            MediaSource mDrmMediaSource = msf.createMediaSource(new MediaItem.Builder().setUri(Uri.parse((String)this.videoURL)).setDrmConfiguration(drmConfiguration.build()).setMimeType("application/dash+xml").setTag(null).build());
            mDrmMediaSource.addDrmEventListener(new Handler(Looper.getMainLooper()), new DrmSessionEventListener(){

                public void onDrmSessionAcquired(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, int state) {
                    super.onDrmSessionAcquired(windowIndex, mediaPeriodId, state);
                }

                public void onDrmKeysLoaded(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
                    super.onDrmKeysLoaded(windowIndex, mediaPeriodId);
                }

                public void onDrmSessionManagerError(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, Exception error) {
                    DRMPlayer.this.mListener.onEvent("pcerror", null);
                    super.onDrmSessionManagerError(windowIndex, mediaPeriodId, error);
                }

                public void onDrmKeysRestored(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
                    super.onDrmKeysRestored(windowIndex, mediaPeriodId);
                }

                public void onDrmKeysRemoved(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
                    super.onDrmKeysRemoved(windowIndex, mediaPeriodId);
                }

                public void onDrmSessionReleased(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
                    super.onDrmSessionReleased(windowIndex, mediaPeriodId);
                }
            });
            this.exoPlayer.setMediaSource(mDrmMediaSource);
            this.exoPlayer.prepare();
        } else {
            this.downloadLicence(this.licenceURL, this.videoURL);
        }
    }

    public boolean isLicenceExpired(DrmKeyVO drmKeyVO) {
        if (drmKeyVO == null) {
            return false;
        }
        long expirationTime = drmKeyVO.getExpirationTime();
        return System.currentTimeMillis() > expirationTime;
    }

    static class DownloadLicenceTask
    extends AsyncTask {
        private DRMPlayer drmPlayer;
        private Context context;
        private String licenceUrl;
        private String videoUrl;
        private int videoId;

        public DownloadLicenceTask(DRMPlayer drmPlayer, Context context, String licenceUrl, String videoUrl, int videoId) {
            this.drmPlayer = drmPlayer;
            this.context = context;
            this.licenceUrl = licenceUrl;
            this.videoUrl = videoUrl;
            this.videoId = videoId;
        }

        protected Object doInBackground(Object[] objects) {
            OfflineRemoteLicenceFetcher offlineRemoteLicenceFetcher = new OfflineRemoteLicenceFetcher(this.drmPlayer, this.context, (HttpDataSource.Factory)new DefaultHttpDataSource.Factory());
            offlineRemoteLicenceFetcher.downloadLicense(this.licenceUrl, Uri.parse((String)this.videoUrl), this.videoId);
            return null;
        }
    }
}

