/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.player.adPlayer.web;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.media3.common.util.UnstableApi;
import java.util.ArrayList;
import tv.brid.domain.Partner;
import tv.brid.domain.Player;
import tv.brid.sdk.Utils;
import tv.brid.sdk.api.BridPlayer;
import tv.brid.sdk.brid_network.domain.AdTagVO;
import tv.brid.sdk.engine.ads.AdAnalyticDC;
import tv.brid.sdk.player.adPlayer.AdPlayerType;
import tv.brid.sdk.player.adPlayer.IAdPlayer;

@UnstableApi
public class WebPlayer
extends IAdPlayer {
    public static final String VPAID_BRIDGE_URL = "https://services.brid.tv/webbridge.html";
    private WebView webView;
    private boolean webViewloaded = false;
    private WebSettings webSettings;
    private Context context;
    private boolean isMuted = false;
    private String adString = "";
    private BridPlayer bridPlayer;
    private AdAnalyticDC adAnalyticDC;
    private ArrayList<AdTagVO> adTagsList;
    private Player player;
    private Partner partner;

    public WebPlayer(final WebView webView, Partner partnerVO, Player playerVO, BridPlayer bridPlayer, final AdAnalyticDC adAnalyticDC, ArrayList<AdTagVO> adTagVOArrayList) {
        this.partner = partnerVO;
        this.player = playerVO;
        this.adAnalyticDC = adAnalyticDC;
        this.adTagsList = adTagVOArrayList;
        this.bridPlayer = bridPlayer;
        this.webView = webView;
        this.context = webView.getContext();
        this.webSettings = webView.getSettings();
        this.webSettings.setJavaScriptEnabled(true);
        if (Build.VERSION.SDK_INT >= 17) {
            this.webSettings.setMediaPlaybackRequiresUserGesture(false);
        }
        webView.addJavascriptInterface((Object)this, "Android");
        webView.setWebChromeClient(new WebChromeClient(){

            @Nullable
            public Bitmap getDefaultVideoPoster() {
                return Bitmap.createBitmap((int)10, (int)10, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
        });
        webView.setWebViewClient(new WebViewClient(){

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                if (!WebPlayer.this.webViewloaded) {
                    if (WebPlayer.this.partner == null) {
                        return;
                    }
                    webView.loadUrl("javascript:setPartnerConfig(" + WebPlayer.this.partner.getJsonObject() + ");");
                    webView.loadUrl("javascript:setPlayerConfig(" + WebPlayer.this.player.getJsonObject() + ");");
                    WebPlayer.this.webViewloaded = true;
                    if (WebPlayer.this.adTagsList != null && adAnalyticDC != null) {
                        WebPlayer.this.playAd(WebPlayer.this.adTagsList, adAnalyticDC);
                        WebPlayer.this.adTagsList = null;
                    }
                }
            }

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (url.toLowerCase().startsWith("http")) {
                    WebPlayer.this.openUrl(url);
                    return true;
                }
                return false;
            }
        });
    }

    public void loadWebUrl() {
        Utils.log(this.getClass(), "loadWebUrl", new String[0]);
        this.webView.loadUrl(VPAID_BRIDGE_URL);
    }

    private void openUrl(String url) {
        Intent browserIntent = new Intent("android.intent.action.VIEW");
        browserIntent.setData(Uri.parse((String)url));
        this.context.startActivity(browserIntent);
    }

    @JavascriptInterface
    public void bridgeEvent(final String event) {
        Utils.log(this.getClass(), "bridgeEvent", event);
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                WebPlayer.this.parseBridgeEvent(event);
            }
        });
    }

    void parseBridgeEvent(String event) {
        Utils.log(this.getClass(), "parseBridgeEvent", event);
    }

    public void killAdPlayer() {
        Utils.log(this.getClass(), "killAdPlayer", new String[0]);
        this.webView.loadUrl("javascript:destroyPlayer();");
    }

    public void muteWebPlayer(boolean isMuted) {
        Utils.log(this.getClass(), "muteWebPlayer", new String[0]);
        this.isMuted = isMuted;
        this.webView.loadUrl("javascript:setMuted($isMuted);");
    }

    public void setAd(String adString) {
        Utils.log(this.getClass(), "setAd", new String[0]);
        this.adString = adString;
        this.webView.loadUrl("javascript:playAd(" + adString + "," + this.adAnalyticDC.getAdType() + ");");
    }

    @Override
    public void playAd(@NonNull ArrayList<AdTagVO> adTags, @NonNull AdAnalyticDC adAnalyticDC) {
        Utils.log(this.getClass(), "playAd", new String[0]);
        this.setAd(this.adString);
    }

    @Override
    public void releaseAdPlayer() {
        Utils.log(this.getClass(), "releaseAdPlayer", new String[0]);
        this.killAdPlayer();
    }

    public void setAdTagVOArrayList(ArrayList<AdTagVO> adTagVOArrayList) {
        this.adTagsList = adTagVOArrayList;
    }

    public boolean getWebViewloaded() {
        return this.webViewloaded;
    }

    public void setPlayerVO(Player playerVO) {
        this.player = playerVO;
    }

    public void setPartnerVO(Partner partnerVO) {
        this.partner = partnerVO;
    }

    @Override
    public void muteAdVideo(Boolean isMuted) {
        this.muteWebPlayer(isMuted);
    }

    @Override
    public void pause() {
    }

    @Override
    @NonNull
    public AdPlayerType getAdPlayerType() {
        return AdPlayerType.WebPlayer;
    }

    @Override
    public void setPlayerData(@NonNull Player player, @NonNull Partner partner) {
        this.setPlayerVO(player);
        this.setPartnerVO(partner);
    }

    @Override
    public void loadAdContent() {
        this.loadWebUrl();
    }

    @Override
    public boolean isAdInProgress() {
        return this.webViewloaded;
    }

    @Override
    public void setAnalytics(@NonNull AdAnalyticDC adAnalyticDC) {
        this.adAnalyticDC = adAnalyticDC;
    }

    @Override
    public void setAdRequest(@NonNull String adString) {
        this.setAd(adString);
    }

    @Override
    public void releaseAdsLoader() {
    }
}

