/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.player.ui.double_tap_layout;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.OptIn;
import androidx.annotation.StyleRes;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.core.content.ContextCompat;
import androidx.core.widget.TextViewCompat;
import androidx.media3.common.Player;
import androidx.media3.common.util.UnstableApi;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.brid.sdk.R;
import tv.brid.sdk.player.BridStyledPlayerView;
import tv.brid.sdk.player.ui.CircleClipTapView;
import tv.brid.sdk.player.ui.double_tap_layout.PlayerDoubleTapListener;
import tv.brid.sdk.player.ui.double_tap_layout.SecondsView;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0014\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0001TB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010;\u001a\u00020\nJ\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00002\b\b\u0001\u0010=\u001a\u00020\u0016J\u0010\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0002J\u0010\u0010B\u001a\u00020\u00002\b\b\u0001\u0010C\u001a\u00020\u0016J\u0010\u0010D\u001a\u00020\u00002\b\b\u0001\u0010=\u001a\u00020\u0016J\b\u0010E\u001a\u00020?H\u0002J\u0010\u0010\u001e\u001a\u00020\u00002\b\b\u0001\u0010=\u001a\u00020\u0016J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010;\u001a\u00020\nJ\b\u0010F\u001a\u00020?H\u0002J\b\u0010G\u001a\u00020?H\u0015J\u0018\u0010H\u001a\u00020?2\u0006\u0010I\u001a\u00020\u00102\u0006\u0010J\u001a\u00020\u0010H\u0016J\u0018\u0010K\u001a\u00020?2\u0006\u0010I\u001a\u00020\u00102\u0006\u0010J\u001a\u00020\u0010H\u0016J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010L\u001a\u00020%J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010(\u001a\u00020)J\b\u0010M\u001a\u00020?H\u0002J\u000e\u00103\u001a\u00020\u00002\u0006\u0010N\u001a\u00020\u0016J\u0017\u0010O\u001a\u00020?2\b\u0010P\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0002\u0010QJ\u0010\u0010R\u001a\u00020\u00002\b\b\u0001\u0010C\u001a\u00020\u0016J\u0010\u0010S\u001a\u00020\u00002\b\b\u0001\u0010=\u001a\u00020\u0016J\u0010\u00108\u001a\u00020\u00002\b\b\u0001\u0010=\u001a\u00020\u0016R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00108F@@X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u00168F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u001e\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u00168F@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0019\"\u0004\b \u0010\u001bR&\u0010!\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\r\"\u0004\b#\u0010\u000fR\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010,\u001a\u00020-8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u000e\u00100\u001a\u000201X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u00103\u001a\u00020\u00162\u0006\u00102\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u0019R$\u00105\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u00168F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b6\u0010\u0019\"\u0004\b7\u0010\u001bR&\u00108\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u00168\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010\u0019\"\u0004\b:\u0010\u001b\u00a8\u0006U"}, d2={"Ltv/brid/sdk/player/ui/double_tap_layout/BridPlayerOverlay;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "Ltv/brid/sdk/player/ui/double_tap_layout/PlayerDoubleTapListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "value", "", "animationDuration", "getAnimationDuration", "()J", "setAnimationDuration", "(J)V", "", "arcSize", "getArcSize", "()F", "setArcSize$bridsdk_release", "(F)V", "", "circleBackgroundColor", "getCircleBackgroundColor", "()I", "setCircleBackgroundColor", "(I)V", "circleClipTapView", "Ltv/brid/sdk/player/ui/CircleClipTapView;", "icon", "getIcon", "setIcon", "iconAnimationDuration", "getIconAnimationDuration", "setIconAnimationDuration", "performListener", "Ltv/brid/sdk/player/ui/double_tap_layout/BridPlayerOverlay$PerformListener;", "player", "Landroidx/media3/common/Player;", "playerView", "Ltv/brid/sdk/player/BridStyledPlayerView;", "playerViewRef", "rootLayout", "secondsTextView", "Landroid/widget/TextView;", "getSecondsTextView", "()Landroid/widget/TextView;", "secondsView", "Ltv/brid/sdk/player/ui/double_tap_layout/SecondsView;", "<set-?>", "seekSeconds", "getSeekSeconds", "tapCircleColor", "getTapCircleColor", "setTapCircleColor", "textAppearance", "getTextAppearance", "setTextAppearance", "duration", "px", "resId", "changeConstraints", "", "forward", "", "circleBackgroundColorInt", "color", "circleBackgroundColorRes", "forwarding", "initializeAttributes", "onAttachedToWindow", "onDoubleTapProgressUp", "posX", "posY", "onDoubleTapStarted", "listener", "rewinding", "seconds", "seekToPosition", "newPosition", "(Ljava/lang/Long;)V", "tapCircleColorInt", "tapCircleColorRes", "PerformListener", "bridsdk_release"})
@UnstableApi
public final class BridPlayerOverlay
extends ConstraintLayout
implements PlayerDoubleTapListener {
    @Nullable
    private final AttributeSet attrs;
    @NotNull
    private ConstraintLayout rootLayout;
    @NotNull
    private SecondsView secondsView;
    @NotNull
    private CircleClipTapView circleClipTapView;
    private int playerViewRef;
    @Nullable
    private BridStyledPlayerView playerView;
    @Nullable
    private Player player;
    @Nullable
    private PerformListener performListener;
    private int seekSeconds;
    private long iconAnimationDuration;
    @DrawableRes
    private int icon;
    @StyleRes
    private int textAppearance;

    public BridPlayerOverlay(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.attrs = attrs;
        this.playerViewRef = -1;
        LayoutInflater.from((Context)context).inflate(R.layout.brid_overlay, (ViewGroup)this, true);
        View view = this.findViewById(R.id.root_constraint_layout);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.root_constraint_layout)");
        this.rootLayout = (ConstraintLayout)view;
        View view2 = this.findViewById(R.id.seconds_view);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(R.id.seconds_view)");
        this.secondsView = (SecondsView)view2;
        View view3 = this.findViewById(R.id.circle_clip_tap_view);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById(R.id.circle_clip_tap_view)");
        this.circleClipTapView = (CircleClipTapView)view3;
        this.initializeAttributes();
        this.secondsView.setForward(true);
        this.changeConstraints(true);
        this.circleClipTapView.setPerformAtEnd((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                PerformListener performListener = performListener;
                if (performListener != null) {
                    performListener.onAnimationEnd();
                }
                secondsView.setVisibility(4);
                secondsView.setSeconds(0);
                secondsView.stop();
            }
        }));
        this.iconAnimationDuration = 750L;
    }

    public BridPlayerOverlay(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null);
        this.setVisibility(4);
    }

    private final void initializeAttributes() {
        if (this.attrs != null) {
            TypedArray typedArray = this.getContext().obtainStyledAttributes(this.attrs, R.styleable.BridOverlay, 0, 0);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026leable.BridOverlay, 0, 0)");
            TypedArray a = typedArray;
            this.playerViewRef = a.getResourceId(R.styleable.BridOverlay_yt_playerView, -1);
            this.setAnimationDuration(a.getInt(R.styleable.BridOverlay_yt_animationDuration, 650));
            this.seekSeconds = a.getInt(R.styleable.BridOverlay_yt_seekSeconds, 5);
            this.setIconAnimationDuration(a.getInt(R.styleable.BridOverlay_yt_iconAnimationDuration, 750));
            this.setArcSize$bridsdk_release(a.getDimensionPixelSize(R.styleable.BridOverlay_yt_arcSize, this.getContext().getResources().getDimensionPixelSize(R.dimen.dtpv_yt_arc_size)));
            this.setTapCircleColor(a.getColor(R.styleable.BridOverlay_yt_tapCircleColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.dtpv_yt_tap_circle_color)));
            this.setCircleBackgroundColor(a.getColor(R.styleable.BridOverlay_yt_backgroundCircleColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.dtpv_yt_background_circle_color)));
            this.setTextAppearance(a.getResourceId(R.styleable.BridOverlay_yt_textAppearance, R.style.YTOSecondsTextAppearance));
            this.setIcon(a.getResourceId(R.styleable.BridOverlay_yt_icon, R.drawable.exo_icon_play));
            a.recycle();
        } else {
            this.setArcSize$bridsdk_release(this.getContext().getResources().getDimensionPixelSize(R.dimen.dtpv_yt_arc_size));
            this.setTapCircleColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.dtpv_yt_tap_circle_color));
            this.setCircleBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.dtpv_yt_background_circle_color));
            this.setAnimationDuration(650L);
            this.setIconAnimationDuration(750L);
            this.seekSeconds = 10;
            this.setTextAppearance(R.style.YTOSecondsTextAppearance);
        }
    }

    @OptIn(markerClass={UnstableApi.class})
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.playerViewRef != -1) {
            ViewParent viewParent = this.getParent();
            Intrinsics.checkNotNull((Object)viewParent, (String)"null cannot be cast to non-null type android.view.View");
            View view = ((View)viewParent).findViewById(this.playerViewRef);
            Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type tv.brid.sdk.player.BridStyledPlayerView");
            this.playerView((BridStyledPlayerView)view);
        }
    }

    @NotNull
    public final BridPlayerOverlay playerView(@NotNull BridStyledPlayerView playerView) {
        BridPlayerOverlay bridPlayerOverlay;
        Intrinsics.checkNotNullParameter((Object)((Object)playerView), (String)"playerView");
        BridPlayerOverlay $this$playerView_u24lambda_u240 = bridPlayerOverlay = this;
        boolean bl = false;
        $this$playerView_u24lambda_u240.playerView = playerView;
        return bridPlayerOverlay;
    }

    @NotNull
    public final BridPlayerOverlay player(@NotNull Player player) {
        BridPlayerOverlay bridPlayerOverlay;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        BridPlayerOverlay $this$player_u24lambda_u241 = bridPlayerOverlay = this;
        boolean bl = false;
        $this$player_u24lambda_u241.player = player;
        return bridPlayerOverlay;
    }

    @NotNull
    public final BridPlayerOverlay performListener(@NotNull PerformListener listener) {
        BridPlayerOverlay bridPlayerOverlay;
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        BridPlayerOverlay $this$performListener_u24lambda_u242 = bridPlayerOverlay = this;
        boolean bl = false;
        $this$performListener_u24lambda_u242.performListener = listener;
        return bridPlayerOverlay;
    }

    public final int getSeekSeconds() {
        return this.seekSeconds;
    }

    @NotNull
    public final BridPlayerOverlay seekSeconds(int seconds) {
        BridPlayerOverlay bridPlayerOverlay;
        BridPlayerOverlay $this$seekSeconds_u24lambda_u243 = bridPlayerOverlay = this;
        boolean bl = false;
        $this$seekSeconds_u24lambda_u243.seekSeconds = seconds;
        return bridPlayerOverlay;
    }

    public final int getTapCircleColor() {
        return this.circleClipTapView.getCircleColor();
    }

    private final void setTapCircleColor(int value) {
        this.circleClipTapView.setCircleColor(value);
    }

    @NotNull
    public final BridPlayerOverlay tapCircleColorRes(@ColorRes int resId) {
        BridPlayerOverlay bridPlayerOverlay;
        BridPlayerOverlay $this$tapCircleColorRes_u24lambda_u244 = bridPlayerOverlay = this;
        boolean bl = false;
        $this$tapCircleColorRes_u24lambda_u244.setTapCircleColor(ContextCompat.getColor((Context)$this$tapCircleColorRes_u24lambda_u244.getContext(), (int)resId));
        return bridPlayerOverlay;
    }

    @NotNull
    public final BridPlayerOverlay tapCircleColorInt(@ColorInt int color2) {
        BridPlayerOverlay bridPlayerOverlay;
        BridPlayerOverlay $this$tapCircleColorInt_u24lambda_u245 = bridPlayerOverlay = this;
        boolean bl = false;
        $this$tapCircleColorInt_u24lambda_u245.setTapCircleColor(color2);
        return bridPlayerOverlay;
    }

    public final int getCircleBackgroundColor() {
        return this.circleClipTapView.getCircleBackgroundColor();
    }

    private final void setCircleBackgroundColor(int value) {
        this.circleClipTapView.setCircleBackgroundColor(value);
    }

    @NotNull
    public final BridPlayerOverlay circleBackgroundColorRes(@ColorRes int resId) {
        BridPlayerOverlay bridPlayerOverlay;
        BridPlayerOverlay $this$circleBackgroundColorRes_u24lambda_u246 = bridPlayerOverlay = this;
        boolean bl = false;
        $this$circleBackgroundColorRes_u24lambda_u246.setCircleBackgroundColor(ContextCompat.getColor((Context)$this$circleBackgroundColorRes_u24lambda_u246.getContext(), (int)resId));
        return bridPlayerOverlay;
    }

    @NotNull
    public final BridPlayerOverlay circleBackgroundColorInt(@ColorInt int color2) {
        BridPlayerOverlay bridPlayerOverlay;
        BridPlayerOverlay $this$circleBackgroundColorInt_u24lambda_u247 = bridPlayerOverlay = this;
        boolean bl = false;
        $this$circleBackgroundColorInt_u24lambda_u247.setCircleBackgroundColor(color2);
        return bridPlayerOverlay;
    }

    public final long getAnimationDuration() {
        return this.circleClipTapView.getAnimationDuration();
    }

    private final void setAnimationDuration(long value) {
        this.circleClipTapView.setAnimationDuration(value);
    }

    @NotNull
    public final BridPlayerOverlay animationDuration(long duration) {
        BridPlayerOverlay bridPlayerOverlay;
        BridPlayerOverlay $this$animationDuration_u24lambda_u248 = bridPlayerOverlay = this;
        boolean bl = false;
        $this$animationDuration_u24lambda_u248.setAnimationDuration(duration);
        return bridPlayerOverlay;
    }

    public final float getArcSize() {
        return this.circleClipTapView.getArcSize();
    }

    public final void setArcSize$bridsdk_release(float value) {
        this.circleClipTapView.setArcSize(value);
    }

    @NotNull
    public final BridPlayerOverlay arcSize(@DimenRes int resId) {
        BridPlayerOverlay bridPlayerOverlay;
        BridPlayerOverlay $this$arcSize_u24lambda_u249 = bridPlayerOverlay = this;
        boolean bl = false;
        $this$arcSize_u24lambda_u249.setArcSize$bridsdk_release($this$arcSize_u24lambda_u249.getContext().getResources().getDimension(resId));
        return bridPlayerOverlay;
    }

    @NotNull
    public final BridPlayerOverlay arcSize(float px) {
        BridPlayerOverlay bridPlayerOverlay;
        BridPlayerOverlay $this$arcSize_u24lambda_u2410 = bridPlayerOverlay = this;
        boolean bl = false;
        $this$arcSize_u24lambda_u2410.setArcSize$bridsdk_release(px);
        return bridPlayerOverlay;
    }

    public final long getIconAnimationDuration() {
        return this.secondsView.getCycleDuration();
    }

    private final void setIconAnimationDuration(long value) {
        this.secondsView.setCycleDuration(value);
        this.iconAnimationDuration = value;
    }

    @NotNull
    public final BridPlayerOverlay iconAnimationDuration(long duration) {
        BridPlayerOverlay bridPlayerOverlay;
        BridPlayerOverlay $this$iconAnimationDuration_u24lambda_u2411 = bridPlayerOverlay = this;
        boolean bl = false;
        $this$iconAnimationDuration_u24lambda_u2411.setIconAnimationDuration(duration);
        return bridPlayerOverlay;
    }

    public final int getIcon() {
        return this.secondsView.getIcon();
    }

    private final void setIcon(int value) {
        this.secondsView.stop();
        this.secondsView.setIcon(value);
        this.icon = value;
    }

    @NotNull
    public final BridPlayerOverlay icon(@DrawableRes int resId) {
        BridPlayerOverlay bridPlayerOverlay;
        BridPlayerOverlay $this$icon_u24lambda_u2412 = bridPlayerOverlay = this;
        boolean bl = false;
        $this$icon_u24lambda_u2412.setIcon(resId);
        return bridPlayerOverlay;
    }

    public final int getTextAppearance() {
        return this.textAppearance;
    }

    private final void setTextAppearance(int value) {
        TextViewCompat.setTextAppearance((TextView)this.secondsView.getTextView(), (int)value);
        this.textAppearance = value;
    }

    @NotNull
    public final BridPlayerOverlay textAppearance(@StyleRes int resId) {
        BridPlayerOverlay bridPlayerOverlay;
        BridPlayerOverlay $this$textAppearance_u24lambda_u2413 = bridPlayerOverlay = this;
        boolean bl = false;
        $this$textAppearance_u24lambda_u2413.setTextAppearance(resId);
        return bridPlayerOverlay;
    }

    @NotNull
    public final TextView getSecondsTextView() {
        return this.secondsView.getTextView();
    }

    @Override
    public void onDoubleTapStarted(float posX, float posY) {
        Boolean bl;
        if (this.player == null || this.playerView == null) {
            return;
        }
        PerformListener performListener = this.performListener;
        if (performListener != null) {
            Player player = this.player;
            Intrinsics.checkNotNull((Object)player);
            BridStyledPlayerView bridStyledPlayerView = this.playerView;
            Intrinsics.checkNotNull((Object)((Object)bridStyledPlayerView));
            bl = performListener.shouldForward(player, bridStyledPlayerView, posX);
        } else {
            bl = null;
        }
        if (bl == null) {
            return;
        }
    }

    @Override
    public void onDoubleTapProgressUp(float posX, float posY) {
        Boolean bl;
        Boolean shouldForward;
        if (this.player == null || this.playerView == null) {
            return;
        }
        PerformListener performListener = this.performListener;
        if (performListener != null) {
            Player player = this.player;
            Intrinsics.checkNotNull((Object)player);
            BridStyledPlayerView bridStyledPlayerView = this.playerView;
            Intrinsics.checkNotNull((Object)((Object)bridStyledPlayerView));
            v3 = performListener.shouldForward(player, bridStyledPlayerView, posX);
        } else {
            v3 = shouldForward = null;
        }
        if (this.getVisibility() != 0) {
            if (shouldForward != null) {
                PerformListener performListener2 = this.performListener;
                if (performListener2 != null) {
                    performListener2.onAnimationStart();
                }
                this.secondsView.setVisibility(0);
                this.secondsView.start();
            } else {
                return;
            }
        }
        if (Intrinsics.areEqual((Object)(bl = shouldForward), (Object)false)) {
            if (this.secondsView.isForward()) {
                SecondsView secondsView;
                this.changeConstraints(false);
                SecondsView $this$onDoubleTapProgressUp_u24lambda_u2414 = secondsView = this.secondsView;
                boolean bl2 = false;
                $this$onDoubleTapProgressUp_u24lambda_u2414.setForward(false);
                $this$onDoubleTapProgressUp_u24lambda_u2414.setSeconds(0);
            }
            this.circleClipTapView.resetAnimation((Function0<Unit>)((Function0)new Function0<Unit>(this, posX, posY){
                final /* synthetic */ BridPlayerOverlay this$0;
                final /* synthetic */ float $posX;
                final /* synthetic */ float $posY;
                {
                    this.this$0 = $receiver;
                    this.$posX = $posX;
                    this.$posY = $posY;
                    super(0);
                }

                public final void invoke() {
                    BridPlayerOverlay.access$getCircleClipTapView$p(this.this$0).updatePosition(this.$posX, this.$posY);
                }
            }));
            this.rewinding();
        } else if (Intrinsics.areEqual((Object)bl, (Object)true)) {
            if (!this.secondsView.isForward()) {
                SecondsView secondsView;
                this.changeConstraints(true);
                SecondsView $this$onDoubleTapProgressUp_u24lambda_u2415 = secondsView = this.secondsView;
                boolean bl3 = false;
                $this$onDoubleTapProgressUp_u24lambda_u2415.setForward(true);
                $this$onDoubleTapProgressUp_u24lambda_u2415.setSeconds(0);
            }
            this.circleClipTapView.resetAnimation((Function0<Unit>)((Function0)new Function0<Unit>(this, posX, posY){
                final /* synthetic */ BridPlayerOverlay this$0;
                final /* synthetic */ float $posX;
                final /* synthetic */ float $posY;
                {
                    this.this$0 = $receiver;
                    this.$posX = $posX;
                    this.$posY = $posY;
                    super(0);
                }

                public final void invoke() {
                    BridPlayerOverlay.access$getCircleClipTapView$p(this.this$0).updatePosition(this.$posX, this.$posY);
                }
            }));
            this.forwarding();
        }
    }

    private final void seekToPosition(Long newPosition) {
        block6: {
            if (newPosition == null) {
                return;
            }
            if (newPosition <= 0L) {
                Player player = this.player;
                if (player != null) {
                    player.seekTo(0L);
                }
                return;
            }
            Player player = this.player;
            if (player != null) {
                long total = player.getDuration();
                boolean bl = false;
                if (newPosition >= total) {
                    Player player2 = this.player;
                    if (player2 != null) {
                        player2.seekTo(total);
                    }
                    return;
                }
            }
            Player player3 = this.player;
            if (player3 == null) break block6;
            player3.seekTo(newPosition.longValue());
        }
    }

    private final void forwarding() {
        SecondsView secondsView = this.secondsView;
        secondsView.setSeconds(secondsView.getSeconds() + this.seekSeconds);
        Player player = this.player;
        this.seekToPosition(player != null ? Long.valueOf(player.getCurrentPosition() + (long)(this.seekSeconds * 1000)) : null);
    }

    private final void rewinding() {
        SecondsView secondsView = this.secondsView;
        secondsView.setSeconds(secondsView.getSeconds() + this.seekSeconds);
        Player player = this.player;
        this.seekToPosition(player != null ? Long.valueOf(player.getCurrentPosition() - (long)(this.seekSeconds * 1000)) : null);
    }

    private final void changeConstraints(boolean forward) {
        ConstraintSet constraintSet;
        ConstraintSet $this$changeConstraints_u24lambda_u2417 = constraintSet = new ConstraintSet();
        boolean bl = false;
        $this$changeConstraints_u24lambda_u2417.clone(this.rootLayout);
        if (forward) {
            $this$changeConstraints_u24lambda_u2417.clear(this.secondsView.getId(), 6);
            $this$changeConstraints_u24lambda_u2417.connect(this.secondsView.getId(), 7, 0, 7);
        } else {
            $this$changeConstraints_u24lambda_u2417.clear(this.secondsView.getId(), 7);
            $this$changeConstraints_u24lambda_u2417.connect(this.secondsView.getId(), 6, 0, 6);
        }
        this.secondsView.start();
        $this$changeConstraints_u24lambda_u2417.applyTo(this.rootLayout);
    }

    public static final /* synthetic */ CircleClipTapView access$getCircleClipTapView$p(BridPlayerOverlay $this) {
        return $this.circleClipTapView;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&J'\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH&\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Ltv/brid/sdk/player/ui/double_tap_layout/BridPlayerOverlay$PerformListener;", "", "onAnimationEnd", "", "onAnimationStart", "shouldForward", "", "player", "Landroidx/media3/common/Player;", "playerView", "Ltv/brid/sdk/player/BridStyledPlayerView;", "posX", "", "(Landroidx/media3/common/Player;Ltv/brid/sdk/player/BridStyledPlayerView;F)Ljava/lang/Boolean;", "bridsdk_release"})
    public static interface PerformListener {
        public void onAnimationStart();

        public void onAnimationEnd();

        @Nullable
        public Boolean shouldForward(@NotNull Player var1, @NotNull BridStyledPlayerView var2, float var3);
    }
}

