/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.player.adapters;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import java.util.List;
import tv.brid.sdk.R;
import tv.brid.sdk.player.settings.SpeedOption;

public class SettingsOptionTvAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private static final int RESOURCE = R.layout.item_settings_child_tv;
    private List<SpeedOption> settingsOptionList;
    private LayoutInflater inflater;
    private int selectedPosition = 0;
    private Context currentContext;
    private OnItemClickListener listener;
    private View itemView;
    private SpeedOption settingsItem;
    private int prevPosition = 3;

    public SettingsOptionTvAdapter(Context context, List<SpeedOption> settingsOptions, OnItemClickListener listener) {
        this.inflater = LayoutInflater.from((Context)context);
        this.currentContext = context;
        this.listener = listener;
        this.settingsOptionList = settingsOptions;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        this.itemView = this.inflater.inflate(RESOURCE, parent, false);
        return new ViewHolder(this.itemView);
    }

    public void onBindViewHolder(final ViewHolder holder, final @SuppressLint(value={"RecyclerView"}) int position) {
        this.settingsItem = this.settingsOptionList.get(position);
        holder.itemTitle.setText((CharSequence)this.settingsItem.getDisplayText());
        holder.itemView.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (hasFocus) {
                    SettingsOptionTvAdapter.this.selectedPosition = holder.getAdapterPosition();
                    holder.itemTitle.setTextColor(ContextCompat.getColor((Context)SettingsOptionTvAdapter.this.currentContext, (int)R.color.tv_text_main_selected));
                    if (!SettingsOptionTvAdapter.this.settingsOptionList.get(SettingsOptionTvAdapter.this.selectedPosition).isChecked()) {
                        holder.checkboxImage.setImageDrawable(ContextCompat.getDrawable((Context)SettingsOptionTvAdapter.this.currentContext, (int)R.drawable.icon_unchecked_selected));
                    } else {
                        holder.checkboxImage.setImageDrawable(ContextCompat.getDrawable((Context)SettingsOptionTvAdapter.this.currentContext, (int)R.drawable.icon_checked_selected));
                    }
                } else {
                    holder.itemTitle.setTextColor(ContextCompat.getColor((Context)SettingsOptionTvAdapter.this.currentContext, (int)R.color.tv_text_main));
                    if (!SettingsOptionTvAdapter.this.settingsOptionList.get(SettingsOptionTvAdapter.this.selectedPosition).isChecked()) {
                        holder.checkboxImage.setImageDrawable(ContextCompat.getDrawable((Context)SettingsOptionTvAdapter.this.currentContext, (int)R.drawable.icon_unchecked));
                    } else {
                        holder.checkboxImage.setImageDrawable(ContextCompat.getDrawable((Context)SettingsOptionTvAdapter.this.currentContext, (int)R.drawable.icon_checked));
                    }
                }
            }
        });
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (SettingsOptionTvAdapter.this.prevPosition != position) {
                    SettingsOptionTvAdapter.this.settingsOptionList.get(SettingsOptionTvAdapter.this.prevPosition).setChecked(false);
                    SettingsOptionTvAdapter.this.notifyItemChanged(SettingsOptionTvAdapter.this.prevPosition);
                }
                SettingsOptionTvAdapter.this.settingsOptionList.get(position).setChecked(true);
                SettingsOptionTvAdapter.this.notifyItemChanged(position);
                SettingsOptionTvAdapter.this.prevPosition = position;
                if (SettingsOptionTvAdapter.this.listener != null) {
                    SettingsOptionTvAdapter.this.listener.onItemClick(SettingsOptionTvAdapter.this.settingsOptionList.get(position).getSpeed(), SettingsOptionTvAdapter.this.settingsOptionList.get(position).getDisplayText());
                }
            }
        });
        holder.itemView.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View view, int i, KeyEvent keyEvent) {
                if (i == 4 && keyEvent.getAction() == 0) {
                    SettingsOptionTvAdapter.this.listener.onItemBackClick();
                    return true;
                }
                return false;
            }
        });
    }

    public int getItemCount() {
        return this.settingsOptionList.size();
    }

    public int getLastSelectedPosition() {
        return this.selectedPosition;
    }

    public void setCheckedPosition(int checkedPosition) {
        this.settingsOptionList.get(checkedPosition).setChecked(true);
    }

    public static interface OnItemClickListener {
        public void onItemClick(float var1, String var2);

        public void onItemBackClick();
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        public ImageView checkboxImage;
        public TextView itemTitle;

        public ViewHolder(View itemView) {
            super(itemView);
            this.checkboxImage = (ImageView)itemView.findViewById(R.id.settings_check_btn);
            this.itemTitle = (TextView)itemView.findViewById(R.id.tv_settings_child_text);
        }
    }
}

