/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.player;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.PictureInPictureParams;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Rational;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Toast;
import androidx.core.view.GestureDetectorCompat;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.ui.PlayerView;
import androidx.media3.ui.R;
import tv.brid.domain.Player;
import tv.brid.sdk.R;
import tv.brid.sdk.player.ui.UtilsKt;
import tv.brid.sdk.player.ui.double_tap_layout.DoubleTapGestureListener;
import tv.brid.sdk.player.ui.double_tap_layout.PlayerDoubleTapListener;

@UnstableApi
public class BridStyledPlayerView
extends PlayerView {
    private GestureDetectorCompat gestureDetector;
    private int controllerRef = -1;
    private final DoubleTapGestureListener gestureListener = new DoubleTapGestureListener(this.getRootView());
    private boolean isDoubleTapEnabled = true;
    private Context currentContext;
    private Activity currentActivity;
    private TouchListener touchListener;

    public PlayerDoubleTapListener getController() {
        return this.gestureListener.getControls();
    }

    public void setController(PlayerDoubleTapListener value) {
        this.gestureListener.setControls(value);
    }

    public BridStyledPlayerView(Context context) {
        super(context);
    }

    public BridStyledPlayerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public BridStyledPlayerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @SuppressLint(value={"ResourceType"})
    private void init(Context context, AttributeSet attrs) {
        this.currentContext = context;
        if (this.currentContext instanceof Activity) {
            this.currentActivity = (Activity)this.currentContext;
        }
        this.gestureDetector = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)this.gestureListener);
        if (attrs != null) {
            TypedArray a = context != null ? context.obtainStyledAttributes(attrs, R.styleable.BridStyledPlayerView, 0, 0) : null;
            this.controllerRef = a != null ? a.getResourceId(R.styleable.BridStyledPlayerView_dtpv_controller, -1) : -1;
            a.recycle();
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 0 && this.touchListener != null) {
            this.touchListener.onTouch();
        }
        if (this.isDoubleTapEnabled) {
            this.gestureDetector.onTouchEvent(event);
            return true;
        }
        return super.onTouchEvent(event);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.controllerRef != -1) {
            try {
                View view;
                View parentView = (View)this.getParent();
                if (parentView != null && (view = parentView.findViewById(this.controllerRef)) instanceof PlayerDoubleTapListener) {
                    this.setController((PlayerDoubleTapListener)view);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.e((String)"DoubleTapPlayerView", (String)("controllerRef is either invalid or not PlayerDoubleTapListener: " + e.getMessage()));
            }
        }
    }

    public void cancelDoubleTapMode() {
        this.gestureListener.cancelInDoubleTapMode();
        this.isDoubleTapEnabled = false;
    }

    public int numOfPossibleControlsToDisplay() {
        int referentBtnSize;
        int maximalSizeForLayout = this.getWidth();
        int timeViewSize = this.findViewById(R.id.exo_time).getWidth() != 0 ? this.findViewById(R.id.exo_time).getWidth() : 1;
        int n = referentBtnSize = this.findViewById(R.id.exo_mute).getWidth() != 0 ? this.findViewById(R.id.exo_mute).getWidth() : 1;
        if (maximalSizeForLayout == 1 || timeViewSize == 1 || referentBtnSize == 1) {
            return 5;
        }
        return (int)((double)((maximalSizeForLayout - timeViewSize) / referentBtnSize));
    }

    public int numberOfBasicControls(Player playerVO) {
        int i = 0;
        if (Boolean.TRUE.equals(playerVO.getFullscreen())) {
            ++i;
        }
        if (Boolean.TRUE.equals(playerVO.getCogwheel())) {
            ++i;
        }
        if (Boolean.TRUE.equals(playerVO.getShareScreen())) {
            ++i;
        }
        if (Boolean.TRUE.equals(playerVO.getPlaylistScreen())) {
            ++i;
        }
        if (Boolean.TRUE.equals(playerVO.getVolume())) {
            ++i;
        }
        return i;
    }

    public void enterPipMode() {
        if (this.isLaidOut()) {
            if (Build.VERSION.SDK_INT >= 26) {
                Rational aspectRatio = new Rational(this.getWidth(), this.getHeight());
                if (aspectRatio.isFinite()) {
                    PictureInPictureParams.Builder mPictureInPictureParamsBuilder = null;
                    mPictureInPictureParamsBuilder = new PictureInPictureParams.Builder();
                    mPictureInPictureParamsBuilder.setAspectRatio(aspectRatio);
                    this.currentActivity.enterPictureInPictureMode(mPictureInPictureParamsBuilder.build());
                } else {
                    Log.e((String)"BridPlayer - PIP", (String)"Player aspect ratio is not valid or video not loaded");
                    Toast.makeText((Context)this.currentContext, (CharSequence)"Player aspect ratio is not valid or video not loaded", (int)0).show();
                }
            } else {
                Log.e((String)"BridPlayer - PIP", (String)"PIP mode is not supported on this device");
                Toast.makeText((Context)this.currentContext, (CharSequence)"PIP mode is not supported on this device", (int)0).show();
            }
        }
    }

    public void onPictureInPictureModeChanged(boolean isInPictureInPictureMode, Configuration newConfig) {
        if (isInPictureInPictureMode) {
            this.enterPipSetup();
        } else {
            this.exitPipSetup();
        }
    }

    private void exitPipSetup() {
        this.currentActivity.getWindow().getDecorView().setSystemUiVisibility(0);
        this.setUseController(true);
    }

    private void enterPipSetup() {
        this.currentActivity.getWindow().getDecorView().setSystemUiVisibility(5380);
        this.setUseController(false);
        this.hideController();
    }

    public void setTouchListener(TouchListener listener) {
        this.touchListener = listener;
    }

    public void showController() {
        super.showController();
    }

    public void hideController() {
        super.hideController();
        if (UtilsKt.isSDKRunningOnTvDevice(this.currentContext)) {
            this.hideControllerForTvWithAnim();
        }
    }

    private void hideControllerForTvWithAnim() {
    }

    public static interface TouchListener {
        public void onTouch();
    }
}

