/*
 * Decompiled with CFR 0.152.
 */
package tv.blademaker.slash.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import kotlin.reflect.KType;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.blademaker.slash.BaseSlashCommand;
import tv.blademaker.slash.context.AutoCompleteContext;
import tv.blademaker.slash.context.SlashCommandContext;
import tv.blademaker.slash.internal.ValidOptionTypes;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ltv/blademaker/slash/internal/FunctionParameter;", "", "command", "Ltv/blademaker/slash/BaseSlashCommand;", "function", "Lkotlin/reflect/KFunction;", "name", "", "type", "Lkotlin/reflect/KType;", "(Ltv/blademaker/slash/BaseSlashCommand;Lkotlin/reflect/KFunction;Ljava/lang/String;Lkotlin/reflect/KType;)V", "isOptional", "", "getName", "()Ljava/lang/String;", "compile", "ctx", "Ltv/blademaker/slash/context/AutoCompleteContext;", "Ltv/blademaker/slash/context/SlashCommandContext;", "toString", "Slash"})
public final class FunctionParameter {
    @NotNull
    private final BaseSlashCommand command;
    @NotNull
    private final KFunction<?> function;
    @NotNull
    private final String name;
    @NotNull
    private final KType type;
    private final boolean isOptional;

    public FunctionParameter(@NotNull BaseSlashCommand command, @NotNull KFunction<?> function, @NotNull String name, @NotNull KType type) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter(function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.command = command;
        this.function = function;
        this.name = name;
        this.type = type;
        this.isOptional = this.type.isMarkedNullable();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final Object compile(@NotNull SlashCommandContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        OptionMapping eventOption = ctx.getOption(this.name);
        if (!this.isOptional && eventOption == null) {
            throw new IllegalStateException(("Parameter marked as non-optional is not present in slash command event: " + this).toString());
        }
        ValidOptionTypes validOptionTypes = ValidOptionTypes.Companion.get(this.type);
        if (validOptionTypes == null) {
            throw new IllegalStateException(("Not found valid OptionCompiler for " + this.type.getClassifier()).toString());
        }
        ValidOptionTypes converter = validOptionTypes;
        return converter.convert(eventOption);
    }

    @Nullable
    public final Object compile(@NotNull AutoCompleteContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        OptionMapping eventOption = ctx.getOption(this.name);
        if (!this.isOptional && eventOption == null) {
            throw new IllegalStateException(("Parameter marked as non-optional is not present in auto-complete event: " + this).toString());
        }
        ValidOptionTypes validOptionTypes = ValidOptionTypes.Companion.get(this.type);
        if (validOptionTypes == null) {
            throw new IllegalStateException(("Not found valid OptionCompiler for " + this.type.getClassifier()).toString());
        }
        ValidOptionTypes converter = validOptionTypes;
        return converter.convert(eventOption);
    }

    @NotNull
    public String toString() {
        return this.command.getCommandName() + "#" + this.function.getName() + "(ctx, ..." + this.name + ")";
    }
}

