/*
 * Decompiled with CFR 0.152.
 */
package tv.blademaker.slash.exceptions;

import io.sentry.SentryEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlinx.coroutines.TimeoutCancellationException;
import net.dv8tion.jda.api.events.interaction.ModalInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.GenericCommandInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.MessageContextInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.UserContextInteractionEvent;
import net.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import net.dv8tion.jda.api.requests.FluentRestAction;
import net.dv8tion.jda.api.requests.restaction.WebhookMessageCreateAction;
import net.dv8tion.jda.api.requests.restaction.interactions.ReplyCallbackAction;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tv.blademaker.slash.BaseSlashCommand;
import tv.blademaker.slash.MessageCommand;
import tv.blademaker.slash.PermissionTarget;
import tv.blademaker.slash.SlashUtils;
import tv.blademaker.slash.UserCommand;
import tv.blademaker.slash.annotations.InteractionTarget;
import tv.blademaker.slash.exceptions.ExceptionHandler;
import tv.blademaker.slash.exceptions.InteractionTargetMismatch;
import tv.blademaker.slash.exceptions.PermissionsLackException;
import tv.blademaker.slash.extensions.InteractionsKt;
import tv.blademaker.slash.extensions.SentryKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000eH\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000fH\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0010H\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u0012H\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0018H\u0016J-\u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006\u001f"}, d2={"Ltv/blademaker/slash/exceptions/ExceptionHandlerImpl;", "Ltv/blademaker/slash/exceptions/ExceptionHandler;", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "onException", "", "ex", "", "command", "Ltv/blademaker/slash/BaseSlashCommand;", "event", "Lnet/dv8tion/jda/api/events/interaction/ModalInteractionEvent;", "Lnet/dv8tion/jda/api/events/interaction/command/CommandAutoCompleteInteractionEvent;", "Lnet/dv8tion/jda/api/events/interaction/command/SlashCommandInteractionEvent;", "Lnet/dv8tion/jda/api/events/interaction/component/ButtonInteractionEvent;", "Ltv/blademaker/slash/MessageCommand;", "Lnet/dv8tion/jda/api/events/interaction/command/MessageContextInteractionEvent;", "Ltv/blademaker/slash/UserCommand;", "Lnet/dv8tion/jda/api/events/interaction/command/UserContextInteractionEvent;", "onInteractionTargetMismatch", "Ltv/blademaker/slash/exceptions/InteractionTargetMismatch;", "onPermissionLackException", "Ltv/blademaker/slash/exceptions/PermissionsLackException;", "onTimeoutCancellationException", "Lkotlinx/coroutines/TimeoutCancellationException;", "timeout", "Lkotlin/time/Duration;", "onTimeoutCancellationException-SxA4cEA", "(Lkotlinx/coroutines/TimeoutCancellationException;Lnet/dv8tion/jda/api/events/interaction/command/SlashCommandInteractionEvent;J)V", "Slash"})
public final class ExceptionHandlerImpl
implements ExceptionHandler {
    private final Logger log = LoggerFactory.getLogger((String)"ExceptionHandler");

    @Override
    public void onException(@NotNull Throwable ex, @NotNull BaseSlashCommand command, @NotNull ModalInteractionEvent event) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String message2 = "Exception executing handler for modal `" + event.getModalId() + "`:\n```\n" + ex.getMessage() + "\n```";
        SentryKt.captureSentryEvent(this.log, (Function1<? super SentryEvent, Unit>)((Function1)new Function1<SentryEvent, Unit>(message2, ex){
            final /* synthetic */ String $message;
            final /* synthetic */ Throwable $ex;
            {
                this.$message = $message;
                this.$ex = $ex;
                super(1);
            }

            public final void invoke(@NotNull SentryEvent $this$captureSentryEvent) {
                Intrinsics.checkNotNullParameter((Object)$this$captureSentryEvent, (String)"$this$captureSentryEvent");
                SentryKt.message($this$captureSentryEvent, this.$message);
                SentryKt.throwable($this$captureSentryEvent, this.$ex);
            }
        }));
        if (event.isAcknowledged()) {
            event.getHook().sendMessage(message2).setEphemeral(true).queue();
        } else {
            event.reply(message2).setEphemeral(true).queue();
        }
    }

    @Override
    public void onException(@NotNull Throwable ex, @NotNull BaseSlashCommand command, @NotNull SlashCommandInteractionEvent event) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String message2 = "Exception executing handler for slash command `" + InteractionsKt.getCommandPath((GenericCommandInteractionEvent)event) + "`:\n```\n" + ex.getMessage() + "\n```";
        SentryKt.captureSentryEvent(this.log, (Function1<? super SentryEvent, Unit>)((Function1)new Function1<SentryEvent, Unit>(message2, ex){
            final /* synthetic */ String $message;
            final /* synthetic */ Throwable $ex;
            {
                this.$message = $message;
                this.$ex = $ex;
                super(1);
            }

            public final void invoke(@NotNull SentryEvent $this$captureSentryEvent) {
                Intrinsics.checkNotNullParameter((Object)$this$captureSentryEvent, (String)"$this$captureSentryEvent");
                SentryKt.message($this$captureSentryEvent, this.$message);
                SentryKt.throwable($this$captureSentryEvent, this.$ex);
            }
        }));
        if (event.isAcknowledged()) {
            event.getHook().sendMessage(message2).setEphemeral(true).queue();
        } else {
            event.reply(message2).setEphemeral(true).queue();
        }
    }

    @Override
    public void onException(@NotNull Throwable ex, @NotNull BaseSlashCommand command, @NotNull CommandAutoCompleteInteractionEvent event) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        SentryKt.captureSentryEvent(this.log, (Function1<? super SentryEvent, Unit>)((Function1)new Function1<SentryEvent, Unit>(event, ex){
            final /* synthetic */ CommandAutoCompleteInteractionEvent $event;
            final /* synthetic */ Throwable $ex;
            {
                this.$event = $event;
                this.$ex = $ex;
                super(1);
            }

            public final void invoke(@NotNull SentryEvent $this$captureSentryEvent) {
                Intrinsics.checkNotNullParameter((Object)$this$captureSentryEvent, (String)"$this$captureSentryEvent");
                SentryKt.message($this$captureSentryEvent, "Exception executing handler for auto-complete interaction `" + InteractionsKt.getCommandPath(this.$event) + "`:\n```\n" + this.$ex.getMessage() + "\n```");
                SentryKt.throwable($this$captureSentryEvent, this.$ex);
            }
        }));
    }

    @Override
    public void onException(@NotNull Throwable ex, @NotNull BaseSlashCommand command, @NotNull ButtonInteractionEvent event) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        SentryKt.captureSentryEvent(this.log, (Function1<? super SentryEvent, Unit>)((Function1)new Function1<SentryEvent, Unit>(event, ex){
            final /* synthetic */ ButtonInteractionEvent $event;
            final /* synthetic */ Throwable $ex;
            {
                this.$event = $event;
                this.$ex = $ex;
                super(1);
            }

            public final void invoke(@NotNull SentryEvent $this$captureSentryEvent) {
                Intrinsics.checkNotNullParameter((Object)$this$captureSentryEvent, (String)"$this$captureSentryEvent");
                SentryKt.message($this$captureSentryEvent, "Exception executing handler for button interaction `" + this.$event.getButton().getId() + "`:\n```\n" + this.$ex.getMessage() + "\n```");
                SentryKt.throwable($this$captureSentryEvent, this.$ex);
            }
        }));
    }

    @Override
    public void onException(@NotNull Throwable ex, @NotNull MessageCommand command, @NotNull MessageContextInteractionEvent event) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        SentryKt.captureSentryEvent(this.log, (Function1<? super SentryEvent, Unit>)((Function1)new Function1<SentryEvent, Unit>(event, ex){
            final /* synthetic */ MessageContextInteractionEvent $event;
            final /* synthetic */ Throwable $ex;
            {
                this.$event = $event;
                this.$ex = $ex;
                super(1);
            }

            public final void invoke(@NotNull SentryEvent $this$captureSentryEvent) {
                Intrinsics.checkNotNullParameter((Object)$this$captureSentryEvent, (String)"$this$captureSentryEvent");
                SentryKt.message($this$captureSentryEvent, "Exception executing handler for Message Command interaction `" + this.$event.getFullCommandName() + "`:\n```\n" + this.$ex.getMessage() + "\n```");
                SentryKt.throwable($this$captureSentryEvent, this.$ex);
            }
        }));
    }

    @Override
    public void onException(@NotNull Throwable ex, @NotNull UserCommand command, @NotNull UserContextInteractionEvent event) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        SentryKt.captureSentryEvent(this.log, (Function1<? super SentryEvent, Unit>)((Function1)new Function1<SentryEvent, Unit>(event, ex){
            final /* synthetic */ UserContextInteractionEvent $event;
            final /* synthetic */ Throwable $ex;
            {
                this.$event = $event;
                this.$ex = $ex;
                super(1);
            }

            public final void invoke(@NotNull SentryEvent $this$captureSentryEvent) {
                Intrinsics.checkNotNullParameter((Object)$this$captureSentryEvent, (String)"$this$captureSentryEvent");
                SentryKt.message($this$captureSentryEvent, "Exception executing handler for User Command interaction `" + this.$event.getFullCommandName() + "`:\n```\n" + this.$ex.getMessage() + "\n```");
                SentryKt.throwable($this$captureSentryEvent, this.$ex);
            }
        }));
    }

    @Override
    public void onPermissionLackException(@NotNull PermissionsLackException ex) {
        ReplyCallbackAction replyCallbackAction;
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        switch (WhenMappings.$EnumSwitchMapping$0[ex.getTarget().ordinal()]) {
            case 1: {
                String perms = SlashUtils.toHuman$default(SlashUtils.INSTANCE, ex.getPermissions(), false, 1, null);
                this.log.warn("Bot doesn't have the required permissions to execute '" + ex.getContext().getEvent().getCommandString() + "'.");
                replyCallbackAction = ex.getContext().replyMessage("\ud83d\udeab The bot does not have the necessary permissions to carry out this action.\nRequired permissions: **" + perms + "**.");
                break;
            }
            case 2: {
                String perms = SlashUtils.toHuman$default(SlashUtils.INSTANCE, ex.getPermissions(), false, 1, null);
                this.log.warn("User " + ex.getContext().getUser() + " doesn't have the required permissions to execute '" + ex.getContext().getEvent().getCommandString() + "'.");
                replyCallbackAction = ex.getContext().replyMessage("\ud83d\udeab You do not have the necessary permissions to carry out this action.\nRequired permissions: **" + perms + "**.");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        replyCallbackAction.setEphemeral(true).queue();
    }

    @Override
    public void onInteractionTargetMismatch(@NotNull InteractionTargetMismatch ex) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        switch (WhenMappings.$EnumSwitchMapping$1[ex.getTarget().ordinal()]) {
            case 1: {
                ex.getContext().message("This command cannot be used outside of a **Guild**.").queue();
                break;
            }
            case 2: {
                ex.getContext().message("This command cannot be used on a **Guild**.").queue();
                break;
            }
            default: {
                String message2 = "Received InteractionTargetMismatch on a command with target InteractionTarget.ALL, report this to developer.";
                ex.getContext().message(message2).queue();
                SentryKt.captureSentryEvent(this.log, (Function1<? super SentryEvent, Unit>)((Function1)new Function1<SentryEvent, Unit>(message2){
                    final /* synthetic */ String $message;
                    {
                        this.$message = $message;
                        super(1);
                    }

                    public final void invoke(@NotNull SentryEvent $this$captureSentryEvent) {
                        Intrinsics.checkNotNullParameter((Object)$this$captureSentryEvent, (String)"$this$captureSentryEvent");
                        SentryKt.message($this$captureSentryEvent, this.$message);
                    }
                }));
            }
        }
    }

    @Override
    public void onTimeoutCancellationException-SxA4cEA(@NotNull TimeoutCancellationException ex, @NotNull SlashCommandInteractionEvent event, long timeout) {
        WebhookMessageCreateAction webhookMessageCreateAction;
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String message2 = "\ud83d\udeab It has not been possible to complete the execution of the command in the estimated time of " + Duration.getInWholeSeconds-impl((long)timeout) + " seconds.";
        boolean bl = event.isAcknowledged();
        if (bl) {
            webhookMessageCreateAction = event.getHook().sendMessage(message2).setEphemeral(true);
        } else if (!bl) {
            webhookMessageCreateAction = event.reply(message2).setEphemeral(true);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        ((FluentRestAction)webhookMessageCreateAction).queue();
    }

    @Override
    public void wrap(@NotNull Throwable e, @NotNull BaseSlashCommand command, @NotNull SlashCommandInteractionEvent event) {
        ExceptionHandler.DefaultImpls.wrap((ExceptionHandler)this, e, command, event);
    }

    @Override
    public void wrap(@NotNull Throwable e, @NotNull BaseSlashCommand command, @NotNull CommandAutoCompleteInteractionEvent event) {
        ExceptionHandler.DefaultImpls.wrap((ExceptionHandler)this, e, command, event);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PermissionTarget.values().length];
            try {
                nArray[PermissionTarget.BOT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionTarget.USER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[InteractionTarget.values().length];
            try {
                nArray[InteractionTarget.GUILD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InteractionTarget.DM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

