/*
 * Decompiled with CFR 0.152.
 */
package tv.blademaker.slash.client;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.events.GenericEvent;
import net.dv8tion.jda.api.sharding.ShardManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.blademaker.slash.client.SlashCommandClient;
import tv.blademaker.slash.context.MessageCommandContext;
import tv.blademaker.slash.context.SlashCommandContext;
import tv.blademaker.slash.context.UserCommandContext;
import tv.blademaker.slash.exceptions.ExceptionHandler;
import tv.blademaker.slash.exceptions.ExceptionHandlerImpl;
import tv.blademaker.slash.internal.Interceptor;
import tv.blademaker.slash.internal.MessageCommandInterceptor;
import tv.blademaker.slash.internal.SlashCommandInterceptor;
import tv.blademaker.slash.internal.UserCommandInterceptor;
import tv.blademaker.slash.metrics.MetricsStrategy;
import tv.blademaker.slash.ratelimit.RateLimitClient;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0014\u001a\u00020\u00002\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u000fJA\u0010\u0016\u001a\u00020\u000021\u0010\u0017\u001a-\b\u0001\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0018\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020 JA\u0010!\u001a\u00020\u000021\u0010\u0017\u001a-\b\u0001\u0012\u0013\u0012\u00110\"\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0018\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020#JA\u0010$\u001a\u00020\u000021\u0010\u0017\u001a-\b\u0001\u0012\u0013\u0012\u00110%\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0018\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010$\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020&J\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020+J\u000e\u0010)\u001a\u00020(2\u0006\u0010,\u001a\u00020-J\u0006\u0010.\u001a\u00020\u0000J\u001f\u0010.\u001a\u00020\u00002\u0017\u0010\u0017\u001a\u0013\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u0002000/\u00a2\u0006\u0002\b1J\u0010\u00102\u001a\u00020\u00002\b\u00103\u001a\u0004\u0018\u00010\u0013J\u0014\u00104\u001a\u00020\u00002\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u001b\u00105\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b6\u00107R\u0019\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u00068"}, d2={"Ltv/blademaker/slash/client/SlashCommandClientBuilder;", "", "packageName", "", "(Ljava/lang/String;)V", "duration", "Lkotlin/time/Duration;", "J", "eventsFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lnet/dv8tion/jda/api/events/GenericEvent;", "exceptionHandler", "Ltv/blademaker/slash/exceptions/ExceptionHandler;", "interceptors", "", "Ltv/blademaker/slash/internal/Interceptor;", "metrics", "Ltv/blademaker/slash/metrics/MetricsStrategy;", "rateLimitClient", "Ltv/blademaker/slash/ratelimit/RateLimitClient;", "addInterceptor", "interceptor", "addMessageInterceptor", "builder", "Lkotlin/Function2;", "Ltv/blademaker/slash/context/MessageCommandContext;", "Lkotlin/ParameterName;", "name", "ctx", "Lkotlin/coroutines/Continuation;", "", "(Lkotlin/jvm/functions/Function2;)Ltv/blademaker/slash/client/SlashCommandClientBuilder;", "Ltv/blademaker/slash/internal/MessageCommandInterceptor;", "addSlashInterceptor", "Ltv/blademaker/slash/context/SlashCommandContext;", "Ltv/blademaker/slash/internal/SlashCommandInterceptor;", "addUserInterceptor", "Ltv/blademaker/slash/context/UserCommandContext;", "Ltv/blademaker/slash/internal/UserCommandInterceptor;", "build", "Ltv/blademaker/slash/client/SlashCommandClient;", "buildWith", "jda", "Lnet/dv8tion/jda/api/JDA;", "shardManager", "Lnet/dv8tion/jda/api/sharding/ShardManager;", "enableMetrics", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "setRateLimitClient", "client", "withEventFlow", "withTimeout", "withTimeout-LRDsOJo", "(J)Ltv/blademaker/slash/client/SlashCommandClientBuilder;", "Slash"})
public final class SlashCommandClientBuilder {
    @NotNull
    private final String packageName;
    @Nullable
    private MetricsStrategy metrics;
    @Nullable
    private ExceptionHandler exceptionHandler;
    @NotNull
    private final Set<Interceptor<?>> interceptors;
    @Nullable
    private RateLimitClient rateLimitClient;
    private long duration;
    @Nullable
    private MutableSharedFlow<GenericEvent> eventsFlow;

    public SlashCommandClientBuilder(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        this.packageName = packageName;
        this.interceptors = new LinkedHashSet();
        this.duration = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES);
    }

    @NotNull
    public final SlashCommandClientBuilder enableMetrics() {
        this.metrics = new MetricsStrategy();
        return this;
    }

    @NotNull
    public final SlashCommandClientBuilder enableMetrics(@NotNull Function1<? super MetricsStrategy, Unit> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        MetricsStrategy metricsStrategy = new MetricsStrategy();
        builder.invoke((Object)metricsStrategy);
        this.metrics = metricsStrategy;
        return this;
    }

    @NotNull
    public final SlashCommandClientBuilder addSlashInterceptor(@NotNull SlashCommandInterceptor interceptor) {
        Intrinsics.checkNotNullParameter((Object)interceptor, (String)"interceptor");
        if (this.interceptors.contains(interceptor)) {
            throw new IllegalStateException("SlashCommandInterceptor already registered.".toString());
        }
        this.interceptors.add(interceptor);
        return this;
    }

    @NotNull
    public final SlashCommandClientBuilder addSlashInterceptor(@NotNull Function2<? super SlashCommandContext, ? super Continuation<? super Boolean>, ? extends Object> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        return this.addSlashInterceptor(new SlashCommandInterceptor(builder){
            final /* synthetic */ Function2<SlashCommandContext, Continuation<? super Boolean>, Object> $builder;
            {
                this.$builder = $builder;
            }

            @Nullable
            public Object intercept(@NotNull SlashCommandContext ctx, @NotNull Continuation<? super Boolean> $completion) {
                return this.$builder.invoke((Object)ctx, $completion);
            }
        });
    }

    @NotNull
    public final SlashCommandClientBuilder addUserInterceptor(@NotNull UserCommandInterceptor interceptor) {
        Intrinsics.checkNotNullParameter((Object)interceptor, (String)"interceptor");
        if (this.interceptors.contains(interceptor)) {
            throw new IllegalStateException("UserCommandInterceptor already registered.".toString());
        }
        this.interceptors.add(interceptor);
        return this;
    }

    @NotNull
    public final SlashCommandClientBuilder addUserInterceptor(@NotNull Function2<? super UserCommandContext, ? super Continuation<? super Boolean>, ? extends Object> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        return this.addUserInterceptor(new UserCommandInterceptor(builder){
            final /* synthetic */ Function2<UserCommandContext, Continuation<? super Boolean>, Object> $builder;
            {
                this.$builder = $builder;
            }

            @Nullable
            public Object intercept(@NotNull UserCommandContext ctx, @NotNull Continuation<? super Boolean> $completion) {
                return this.$builder.invoke((Object)ctx, $completion);
            }
        });
    }

    @NotNull
    public final SlashCommandClientBuilder addMessageInterceptor(@NotNull MessageCommandInterceptor interceptor) {
        Intrinsics.checkNotNullParameter((Object)interceptor, (String)"interceptor");
        if (this.interceptors.contains(interceptor)) {
            throw new IllegalStateException("MessageCommandInterceptor already registered.".toString());
        }
        this.interceptors.add(interceptor);
        return this;
    }

    @NotNull
    public final SlashCommandClientBuilder addMessageInterceptor(@NotNull Function2<? super MessageCommandContext, ? super Continuation<? super Boolean>, ? extends Object> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        return this.addMessageInterceptor(new MessageCommandInterceptor(builder){
            final /* synthetic */ Function2<MessageCommandContext, Continuation<? super Boolean>, Object> $builder;
            {
                this.$builder = $builder;
            }

            @Nullable
            public Object intercept(@NotNull MessageCommandContext ctx, @NotNull Continuation<? super Boolean> $completion) {
                return this.$builder.invoke((Object)ctx, $completion);
            }
        });
    }

    @NotNull
    public final SlashCommandClientBuilder addInterceptor(@NotNull Interceptor<?> interceptor) {
        Intrinsics.checkNotNullParameter(interceptor, (String)"interceptor");
        if (this.interceptors.contains(interceptor)) {
            throw new IllegalStateException((interceptor.getClass().getSimpleName() + " already registered.").toString());
        }
        this.interceptors.add(interceptor);
        return this;
    }

    @NotNull
    public final SlashCommandClientBuilder setRateLimitClient(@Nullable RateLimitClient client) {
        this.rateLimitClient = client;
        return this;
    }

    @NotNull
    public final SlashCommandClientBuilder withTimeout-LRDsOJo(long duration) {
        this.duration = duration;
        return this;
    }

    @NotNull
    public final SlashCommandClientBuilder withEventFlow(@NotNull MutableSharedFlow<GenericEvent> eventsFlow) {
        Intrinsics.checkNotNullParameter(eventsFlow, (String)"eventsFlow");
        this.eventsFlow = eventsFlow;
        return this;
    }

    @NotNull
    public final SlashCommandClient build() {
        ExceptionHandler exceptionHandler;
        MutableSharedFlow mutableSharedFlow = this.eventsFlow;
        if (mutableSharedFlow == null) {
            mutableSharedFlow = SharedFlowKt.MutableSharedFlow$default((int)0, (int)0, null, (int)6, null);
        }
        if ((exceptionHandler = this.exceptionHandler) == null) {
            exceptionHandler = new ExceptionHandlerImpl();
        }
        return new SlashCommandClient(this.packageName, mutableSharedFlow, exceptionHandler, this.interceptors, this.duration, this.rateLimitClient, this.metrics, null);
    }

    @NotNull
    public final SlashCommandClient buildWith(@NotNull JDA jda) {
        Intrinsics.checkNotNullParameter((Object)jda, (String)"jda");
        if (this.eventsFlow != null) {
            throw new IllegalStateException("Cannot use buildWith() when you set your own eventsFlow, use build() instead.".toString());
        }
        SlashCommandClient client = this.build();
        Object[] objectArray = new Object[]{client};
        jda.addEventListener(objectArray);
        return client;
    }

    @NotNull
    public final SlashCommandClient buildWith(@NotNull ShardManager shardManager) {
        Intrinsics.checkNotNullParameter((Object)shardManager, (String)"shardManager");
        if (this.eventsFlow != null) {
            throw new IllegalStateException("Cannot use buildWith() when you set your own eventsFlow, use build() instead.".toString());
        }
        SlashCommandClient client = this.build();
        Object[] objectArray = new Object[]{client};
        shardManager.addEventListener(objectArray);
        return client;
    }
}

