/*
 * Decompiled with CFR 0.152.
 */
package tv.blademaker.slash.ratelimit;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.dv8tion.jda.api.events.interaction.command.GenericCommandInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.blademaker.slash.context.SlashCommandContext;
import tv.blademaker.slash.extensions.InteractionsKt;
import tv.blademaker.slash.ratelimit.RateLimit;
import tv.blademaker.slash.utils.MessageCreateBuilderKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J#\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0003H\u0016\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0011"}, d2={"Ltv/blademaker/slash/ratelimit/RateLimitClient;", "", "acquire", "", "annotation", "Ltv/blademaker/slash/ratelimit/RateLimit;", "event", "Lnet/dv8tion/jda/api/events/interaction/command/SlashCommandInteractionEvent;", "(Ltv/blademaker/slash/ratelimit/RateLimit;Lnet/dv8tion/jda/api/events/interaction/command/SlashCommandInteractionEvent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createBucketKey", "", "onRateLimitHit", "", "ctx", "Ltv/blademaker/slash/context/SlashCommandContext;", "rateLimit", "waitFor", "Slash"})
public interface RateLimitClient {
    public void onRateLimitHit(@NotNull SlashCommandContext var1, @NotNull RateLimit var2, long var3);

    @NotNull
    public String createBucketKey(@NotNull RateLimit var1, @NotNull SlashCommandInteractionEvent var2);

    @Nullable
    public Object acquire(@NotNull RateLimit var1, @NotNull SlashCommandInteractionEvent var2, @NotNull Continuation<? super Long> var3);

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RateLimit.Target.values().length];
            try {
                nArray[RateLimit.Target.GUILD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RateLimit.Target.CHANNEL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RateLimit.Target.USER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void onRateLimitHit(@NotNull RateLimitClient $this, @NotNull SlashCommandContext ctx, @NotNull RateLimit rateLimit, long waitFor) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)rateLimit, (String)"rateLimit");
            long seconds = waitFor / (long)1000 % (long)60;
            ctx.message((Function1<? super MessageCreateBuilder, Unit>)((Function1)new Function1<MessageCreateBuilder, Unit>(seconds, rateLimit){
                final /* synthetic */ long $seconds;
                final /* synthetic */ RateLimit $rateLimit;
                {
                    this.$seconds = $seconds;
                    this.$rateLimit = $rateLimit;
                    super(1);
                }

                public final void invoke(@NotNull MessageCreateBuilder $this$message) {
                    Intrinsics.checkNotNullParameter((Object)$this$message, (String)"$this$message");
                    MessageCreateBuilderKt.appendLine($this$message, "\ud83d\uded1 **RATE LIMIT**: Wait for **" + this.$seconds + " seconds** to execute this command.");
                    MessageCreateBuilderKt.appendLine($this$message);
                    MessageCreateBuilderKt.appendLine($this$message, "Rate Limit bucket information:");
                    MessageCreateBuilderKt.appendCodeBlock($this$message, "Bucket {\n\tQuota: " + this.$rateLimit.quota() + "\n\tWindow: " + this.$rateLimit.duration() + "\n\tUnit: " + this.$rateLimit.unit() + "\n\tTarget: " + this.$rateLimit.target() + "\n}", "hocon");
                }
            })).setEphemeral(true).queue();
        }

        @NotNull
        public static String createBucketKey(@NotNull RateLimitClient $this, @NotNull RateLimit annotation, @NotNull SlashCommandInteractionEvent event) {
            String string;
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            switch (WhenMappings.$EnumSwitchMapping$0[annotation.target().ordinal()]) {
                case 1: {
                    Object object = event.getGuild();
                    if (object == null || (object = object.getId()) == null) {
                        object = "unknown";
                    }
                    string = "limit:guild:" + (String)object + ":" + InteractionsKt.getCommandPath((GenericCommandInteractionEvent)event);
                    break;
                }
                case 2: {
                    string = "limit:channel:" + event.getChannel().getId() + ":" + InteractionsKt.getCommandPath((GenericCommandInteractionEvent)event);
                    break;
                }
                case 3: {
                    string = "limit:user:" + event.getUser().getId() + ":" + InteractionsKt.getCommandPath((GenericCommandInteractionEvent)event);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }
    }
}

