/*
 * Decompiled with CFR 0.152.
 */
package tv.blademaker.kotify.services;

import io.ktor.http.HttpMethod;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.blademaker.kotify.Kotify;
import tv.blademaker.kotify.models.AlbumsSearchResult;
import tv.blademaker.kotify.models.ArtistsSearchResult;
import tv.blademaker.kotify.models.PlaylistsSearchResult;
import tv.blademaker.kotify.models.TracksSearchResult;
import tv.blademaker.kotify.request.Request;
import tv.blademaker.kotify.services.Service;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J-\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ-\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ-\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ-\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0015"}, d2={"Ltv/blademaker/kotify/services/SearchService;", "Ltv/blademaker/kotify/services/Service;", "kotify", "Ltv/blademaker/kotify/Kotify;", "(Ltv/blademaker/kotify/Kotify;)V", "getKotify", "()Ltv/blademaker/kotify/Kotify;", "searchAlbums", "Ltv/blademaker/kotify/models/AlbumsSearchResult;", "query", "", "limit", "", "offset", "(Ljava/lang/String;IILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "searchArtists", "Ltv/blademaker/kotify/models/ArtistsSearchResult;", "searchPlaylists", "Ltv/blademaker/kotify/models/PlaylistsSearchResult;", "searchTracks", "Ltv/blademaker/kotify/models/TracksSearchResult;", "Kotify"})
public final class SearchService
implements Service {
    @NotNull
    private final Kotify kotify;

    public SearchService(@NotNull Kotify kotify) {
        Intrinsics.checkNotNullParameter((Object)kotify, (String)"kotify");
        this.kotify = kotify;
    }

    @Override
    @NotNull
    public Kotify getKotify() {
        return this.kotify;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object searchTracks(@NotNull String query, int limit, int offset, @NotNull Continuation<? super TracksSearchResult> $completion) {
        void path$iv;
        void this_$iv$iv;
        void $this$get$iv;
        if (!(((CharSequence)query).length() > 0)) {
            boolean $i$a$-require-SearchService$searchTracks$52 = false;
            String $i$a$-require-SearchService$searchTracks$52 = "query is empty";
            throw new IllegalArgumentException($i$a$-require-SearchService$searchTracks$52.toString());
        }
        if (!(1 <= limit ? limit < 51 : false)) {
            boolean $i$a$-require-SearchService$searchTracks$62 = false;
            String $i$a$-require-SearchService$searchTracks$62 = "not valid limit";
            throw new IllegalArgumentException($i$a$-require-SearchService$searchTracks$62.toString());
        }
        if (!(offset >= 0)) {
            boolean $i$a$-require-SearchService$searchTracks$72 = false;
            String $i$a$-require-SearchService$searchTracks$72 = "not valid offset";
            throw new IllegalArgumentException($i$a$-require-SearchService$searchTracks$72.toString());
        }
        Service service = this;
        String $i$a$-require-SearchService$searchTracks$72 = "/v1/search";
        KSerializer<TracksSearchResult> serializer$iv = TracksSearchResult.Companion.serializer();
        boolean $i$f$get = false;
        Kotify kotify = $this$get$iv.getKotify();
        HttpMethod method$iv$iv = HttpMethod.Companion.getGet();
        boolean $i$f$newRequest$Kotify = false;
        Request<TracksSearchResult> request = new Request<TracksSearchResult>((Kotify)this_$iv$iv, serializer$iv, method$iv$iv, (String)path$iv);
        String string = URLEncoder.encode(query, StandardCharsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(query, StandardCharsets.UTF_8)");
        return request.addEncodedQuery("q", string).addQuery("type", "track").limit(limit).offset(offset).execute($completion);
    }

    public static /* synthetic */ Object searchTracks$default(SearchService searchService, String string, int n, int n2, Continuation continuation, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 50;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        return searchService.searchTracks(string, n, n2, (Continuation<? super TracksSearchResult>)continuation);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object searchArtists(@NotNull String query, int limit, int offset, @NotNull Continuation<? super ArtistsSearchResult> $completion) {
        void path$iv;
        void this_$iv$iv;
        void $this$get$iv;
        if (!(((CharSequence)query).length() > 0)) {
            boolean $i$a$-require-SearchService$searchArtists$52 = false;
            String $i$a$-require-SearchService$searchArtists$52 = "query is empty";
            throw new IllegalArgumentException($i$a$-require-SearchService$searchArtists$52.toString());
        }
        if (!(1 <= limit ? limit < 51 : false)) {
            boolean $i$a$-require-SearchService$searchArtists$62 = false;
            String $i$a$-require-SearchService$searchArtists$62 = "not valid limit";
            throw new IllegalArgumentException($i$a$-require-SearchService$searchArtists$62.toString());
        }
        if (!(offset >= 0)) {
            boolean $i$a$-require-SearchService$searchArtists$72 = false;
            String $i$a$-require-SearchService$searchArtists$72 = "not valid offset";
            throw new IllegalArgumentException($i$a$-require-SearchService$searchArtists$72.toString());
        }
        Service service = this;
        String $i$a$-require-SearchService$searchArtists$72 = "/v1/search";
        KSerializer<ArtistsSearchResult> serializer$iv = ArtistsSearchResult.Companion.serializer();
        boolean $i$f$get = false;
        Kotify kotify = $this$get$iv.getKotify();
        HttpMethod method$iv$iv = HttpMethod.Companion.getGet();
        boolean $i$f$newRequest$Kotify = false;
        Request<ArtistsSearchResult> request = new Request<ArtistsSearchResult>((Kotify)this_$iv$iv, serializer$iv, method$iv$iv, (String)path$iv);
        String string = URLEncoder.encode(query, StandardCharsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(query, StandardCharsets.UTF_8)");
        return request.addEncodedQuery("q", string).addQuery("type", "artist").limit(limit).offset(offset).execute($completion);
    }

    public static /* synthetic */ Object searchArtists$default(SearchService searchService, String string, int n, int n2, Continuation continuation, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 50;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        return searchService.searchArtists(string, n, n2, (Continuation<? super ArtistsSearchResult>)continuation);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object searchPlaylists(@NotNull String query, int limit, int offset, @NotNull Continuation<? super PlaylistsSearchResult> $completion) {
        void path$iv;
        void this_$iv$iv;
        void $this$get$iv;
        if (!(((CharSequence)query).length() > 0)) {
            boolean $i$a$-require-SearchService$searchPlaylists$52 = false;
            String $i$a$-require-SearchService$searchPlaylists$52 = "query is empty";
            throw new IllegalArgumentException($i$a$-require-SearchService$searchPlaylists$52.toString());
        }
        if (!(1 <= limit ? limit < 51 : false)) {
            boolean $i$a$-require-SearchService$searchPlaylists$62 = false;
            String $i$a$-require-SearchService$searchPlaylists$62 = "not valid limit";
            throw new IllegalArgumentException($i$a$-require-SearchService$searchPlaylists$62.toString());
        }
        if (!(offset >= 0)) {
            boolean $i$a$-require-SearchService$searchPlaylists$72 = false;
            String $i$a$-require-SearchService$searchPlaylists$72 = "not valid offset";
            throw new IllegalArgumentException($i$a$-require-SearchService$searchPlaylists$72.toString());
        }
        Service service = this;
        String $i$a$-require-SearchService$searchPlaylists$72 = "/v1/search";
        KSerializer<PlaylistsSearchResult> serializer$iv = PlaylistsSearchResult.Companion.serializer();
        boolean $i$f$get = false;
        Kotify kotify = $this$get$iv.getKotify();
        HttpMethod method$iv$iv = HttpMethod.Companion.getGet();
        boolean $i$f$newRequest$Kotify = false;
        Request<PlaylistsSearchResult> request = new Request<PlaylistsSearchResult>((Kotify)this_$iv$iv, serializer$iv, method$iv$iv, (String)path$iv);
        String string = URLEncoder.encode(query, StandardCharsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(query, StandardCharsets.UTF_8)");
        return request.addEncodedQuery("q", string).addQuery("type", "playlist").limit(limit).offset(offset).execute($completion);
    }

    public static /* synthetic */ Object searchPlaylists$default(SearchService searchService, String string, int n, int n2, Continuation continuation, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 50;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        return searchService.searchPlaylists(string, n, n2, (Continuation<? super PlaylistsSearchResult>)continuation);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object searchAlbums(@NotNull String query, int limit, int offset, @NotNull Continuation<? super AlbumsSearchResult> $completion) {
        void path$iv;
        void this_$iv$iv;
        void $this$get$iv;
        if (!(((CharSequence)query).length() > 0)) {
            boolean $i$a$-require-SearchService$searchAlbums$52 = false;
            String $i$a$-require-SearchService$searchAlbums$52 = "query is empty";
            throw new IllegalArgumentException($i$a$-require-SearchService$searchAlbums$52.toString());
        }
        if (!(1 <= limit ? limit < 51 : false)) {
            boolean $i$a$-require-SearchService$searchAlbums$62 = false;
            String $i$a$-require-SearchService$searchAlbums$62 = "not valid limit";
            throw new IllegalArgumentException($i$a$-require-SearchService$searchAlbums$62.toString());
        }
        if (!(offset >= 0)) {
            boolean $i$a$-require-SearchService$searchAlbums$72 = false;
            String $i$a$-require-SearchService$searchAlbums$72 = "not valid offset";
            throw new IllegalArgumentException($i$a$-require-SearchService$searchAlbums$72.toString());
        }
        Service service = this;
        String $i$a$-require-SearchService$searchAlbums$72 = "/v1/search";
        KSerializer<AlbumsSearchResult> serializer$iv = AlbumsSearchResult.Companion.serializer();
        boolean $i$f$get = false;
        Kotify kotify = $this$get$iv.getKotify();
        HttpMethod method$iv$iv = HttpMethod.Companion.getGet();
        boolean $i$f$newRequest$Kotify = false;
        Request<AlbumsSearchResult> request = new Request<AlbumsSearchResult>((Kotify)this_$iv$iv, serializer$iv, method$iv$iv, (String)path$iv);
        String string = URLEncoder.encode(query, StandardCharsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(query, StandardCharsets.UTF_8)");
        return request.addEncodedQuery("q", string).addQuery("type", "album").limit(limit).offset(offset).execute($completion);
    }

    public static /* synthetic */ Object searchAlbums$default(SearchService searchService, String string, int n, int n2, Continuation continuation, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 50;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        return searchService.searchAlbums(string, n, n2, (Continuation<? super AlbumsSearchResult>)continuation);
    }
}

