/*
 * Decompiled with CFR 0.152.
 */
package tv.blademaker.kotify;

import io.ktor.client.HttpClient;
import io.ktor.client.HttpClientKt;
import io.ktor.client.engine.HttpClientEngineFactory;
import io.ktor.client.engine.cio.CIO;
import java.io.Closeable;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tv.blademaker.kotify.Kotify;
import tv.blademaker.kotify.internal.CredentialsManager;
import tv.blademaker.kotify.request.Request;
import tv.blademaker.kotify.services.AlbumsService;
import tv.blademaker.kotify.services.ArtistsService;
import tv.blademaker.kotify.services.AuthorizationService;
import tv.blademaker.kotify.services.CategoriesService;
import tv.blademaker.kotify.services.EpisodesService;
import tv.blademaker.kotify.services.PlaylistsService;
import tv.blademaker.kotify.services.RecommendationsService;
import tv.blademaker.kotify.services.SearchService;
import tv.blademaker.kotify.services.ShowsService;
import tv.blademaker.kotify.services.TracksService;
import tv.blademaker.kotify.services.UsersService;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 N2\u00020\u0001:\u0002NOB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\b\u0010L\u001a\u00020MH\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\u0004\u0018\u00010 8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001c\u0010#\u001a\u00020$8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b%\u0010&\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0018\u0010-\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030/0.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00100\u001a\u000201\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R$\u00105\u001a\u00020 2\u0006\u00104\u001a\u00020 8@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u000e\u0010:\u001a\u00020;X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010<\u001a\u00020=\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0011\u0010@\u001a\u00020A\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u0011\u0010D\u001a\u00020E\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010GR\u0011\u0010H\u001a\u00020I\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010K\u00a8\u0006P"}, d2={"Ltv/blademaker/kotify/Kotify;", "Ljava/io/Closeable;", "clientID", "", "clientSecret", "baseUrl", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "albums", "Ltv/blademaker/kotify/services/AlbumsService;", "getAlbums", "()Ltv/blademaker/kotify/services/AlbumsService;", "artists", "Ltv/blademaker/kotify/services/ArtistsService;", "getArtists", "()Ltv/blademaker/kotify/services/ArtistsService;", "authorization", "Ltv/blademaker/kotify/services/AuthorizationService;", "getAuthorization", "()Ltv/blademaker/kotify/services/AuthorizationService;", "categories", "Ltv/blademaker/kotify/services/CategoriesService;", "getCategories", "()Ltv/blademaker/kotify/services/CategoriesService;", "credentials", "Ltv/blademaker/kotify/internal/CredentialsManager;", "getCredentials$Kotify", "()Ltv/blademaker/kotify/internal/CredentialsManager;", "episodes", "Ltv/blademaker/kotify/services/EpisodesService;", "getEpisodes", "()Ltv/blademaker/kotify/services/EpisodesService;", "getDelay", "", "getGetDelay$Kotify", "()Ljava/lang/Long;", "httpClient", "Lio/ktor/client/HttpClient;", "getHttpClient$annotations", "()V", "getHttpClient", "()Lio/ktor/client/HttpClient;", "playlists", "Ltv/blademaker/kotify/services/PlaylistsService;", "getPlaylists", "()Ltv/blademaker/kotify/services/PlaylistsService;", "queue", "Ljava/util/LinkedList;", "Ltv/blademaker/kotify/request/Request;", "recommendations", "Ltv/blademaker/kotify/services/RecommendationsService;", "getRecommendations", "()Ltv/blademaker/kotify/services/RecommendationsService;", "value", "retryAfter", "getRetryAfter$Kotify", "()J", "setRetryAfter$Kotify", "(J)V", "retryAfterRef", "Ljava/util/concurrent/atomic/AtomicLong;", "search", "Ltv/blademaker/kotify/services/SearchService;", "getSearch", "()Ltv/blademaker/kotify/services/SearchService;", "shows", "Ltv/blademaker/kotify/services/ShowsService;", "getShows", "()Ltv/blademaker/kotify/services/ShowsService;", "tracks", "Ltv/blademaker/kotify/services/TracksService;", "getTracks", "()Ltv/blademaker/kotify/services/TracksService;", "user", "Ltv/blademaker/kotify/services/UsersService;", "getUser", "()Ltv/blademaker/kotify/services/UsersService;", "close", "", "Companion", "Scope", "Kotify"})
public final class Kotify
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CredentialsManager credentials;
    @NotNull
    private final AtomicLong retryAfterRef;
    @NotNull
    private final HttpClient httpClient;
    @NotNull
    private final AlbumsService albums;
    @NotNull
    private final ArtistsService artists;
    @NotNull
    private final AuthorizationService authorization;
    @NotNull
    private final CategoriesService categories;
    @NotNull
    private final EpisodesService episodes;
    @NotNull
    private final PlaylistsService playlists;
    @NotNull
    private final RecommendationsService recommendations;
    @NotNull
    private final SearchService search;
    @NotNull
    private final ShowsService shows;
    @NotNull
    private final TracksService tracks;
    @NotNull
    private final UsersService user;
    @NotNull
    private final LinkedList<Request<?>> queue;
    private static final Logger log = LoggerFactory.getLogger((String)"Kotify");
    @NotNull
    private static String baseUrl = "https://api.spotify.com";
    @NotNull
    public static final String VERSION = "0.4.6";
    @NotNull
    private static final Json JSON = JsonKt.Json$default(null, (Function1)Companion.JSON.1.INSTANCE, (int)1, null);

    public Kotify(@NotNull String clientID, @NotNull String clientSecret, @NotNull String baseUrl) {
        Intrinsics.checkNotNullParameter((Object)clientID, (String)"clientID");
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        this.credentials = new CredentialsManager(this, clientID, clientSecret);
        this.retryAfterRef = new AtomicLong(-1L);
        Kotify.baseUrl = baseUrl;
        this.httpClient = HttpClientKt.HttpClient((HttpClientEngineFactory)((HttpClientEngineFactory)CIO.INSTANCE), (Function1)httpClient.1.INSTANCE);
        this.albums = new AlbumsService(this);
        this.artists = new ArtistsService(this);
        this.authorization = new AuthorizationService(this);
        this.categories = new CategoriesService(this);
        this.episodes = new EpisodesService(this);
        this.playlists = new PlaylistsService(this);
        this.recommendations = new RecommendationsService(this);
        this.search = new SearchService(this);
        this.shows = new ShowsService(this);
        this.tracks = new TracksService(this);
        this.user = new UsersService(this);
        this.queue = new LinkedList();
    }

    public /* synthetic */ Kotify(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string3 = "https://api.spotify.com";
        }
        this(string, string2, string3);
    }

    @NotNull
    public final CredentialsManager getCredentials$Kotify() {
        return this.credentials;
    }

    public final long getRetryAfter$Kotify() {
        return this.retryAfterRef.get();
    }

    public final void setRetryAfter$Kotify(long value) {
        log.debug("Adding a retry after of " + value + "ms.");
        this.retryAfterRef.set(System.currentTimeMillis() + value);
    }

    @Nullable
    public final Long getGetDelay$Kotify() {
        long retryAfter = this.retryAfterRef.get();
        if (retryAfter > System.currentTimeMillis() + (long)250) {
            return retryAfter - System.currentTimeMillis();
        }
        if (retryAfter != -1L) {
            this.retryAfterRef.set(-1L);
        }
        return null;
    }

    @NotNull
    public final HttpClient getHttpClient() {
        return this.httpClient;
    }

    @PublishedApi
    public static /* synthetic */ void getHttpClient$annotations() {
    }

    @NotNull
    public final AlbumsService getAlbums() {
        return this.albums;
    }

    @NotNull
    public final ArtistsService getArtists() {
        return this.artists;
    }

    @NotNull
    public final AuthorizationService getAuthorization() {
        return this.authorization;
    }

    @NotNull
    public final CategoriesService getCategories() {
        return this.categories;
    }

    @NotNull
    public final EpisodesService getEpisodes() {
        return this.episodes;
    }

    @NotNull
    public final PlaylistsService getPlaylists() {
        return this.playlists;
    }

    @NotNull
    public final RecommendationsService getRecommendations() {
        return this.recommendations;
    }

    @NotNull
    public final SearchService getSearch() {
        return this.search;
    }

    @NotNull
    public final ShowsService getShows() {
        return this.shows;
    }

    @NotNull
    public final TracksService getTracks() {
        return this.tracks;
    }

    @NotNull
    public final UsersService getUser() {
        return this.user;
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Ltv/blademaker/kotify/Kotify$Companion;", "", "()V", "JSON", "Lkotlinx/serialization/json/Json;", "getJSON", "()Lkotlinx/serialization/json/Json;", "VERSION", "", "baseUrl", "getBaseUrl$Kotify", "()Ljava/lang/String;", "setBaseUrl$Kotify", "(Ljava/lang/String;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog$Kotify", "()Lorg/slf4j/Logger;", "Kotify"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLog$Kotify() {
            return log;
        }

        @NotNull
        public final String getBaseUrl$Kotify() {
            return baseUrl;
        }

        public final void setBaseUrl$Kotify(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            baseUrl = string;
        }

        @NotNull
        public final Json getJSON() {
            return JSON;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0017\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"Ltv/blademaker/kotify/Kotify$Scope;", "", "value", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "UGC_IMAGE_UPLOAD", "USER_READ_PLAYBACK_STATE", "USER_MODIFY_PLAYBACK_STATE", "USER_READ_CURRENTLY_PLAYING", "USER_READ_PRIVATE", "USER_READ_EMAIL", "USER_FOLLOW_MODIFY", "USER_FOLLOW_READ", "USER_LIBRARY_MODIFY", "USER_LIBRARY_READ", "STREAMING", "APP_REMOTE_CONTROL", "USER_READ_PLAYBACK_POSITION", "USER_TOP_READ", "USER_READ_RECENTLY_PLAYED", "PLAYLIST_MODIFY_PRIVATE", "PLAYLIST_READ_COLLABORATIVE", "PLAYLIST_READ_PRIVATE", "PLAYLIST_MODIFY_PUBLIC", "Kotify"})
    public static final class Scope
    extends Enum<Scope> {
        @NotNull
        private final String value;
        public static final /* enum */ Scope UGC_IMAGE_UPLOAD = new Scope("ugc-image-upload");
        public static final /* enum */ Scope USER_READ_PLAYBACK_STATE = new Scope("user-read-playback-state");
        public static final /* enum */ Scope USER_MODIFY_PLAYBACK_STATE = new Scope("user-modify-playback-state");
        public static final /* enum */ Scope USER_READ_CURRENTLY_PLAYING = new Scope("user-read-currently-playing");
        public static final /* enum */ Scope USER_READ_PRIVATE = new Scope("user-read-private");
        public static final /* enum */ Scope USER_READ_EMAIL = new Scope("user-read-email");
        public static final /* enum */ Scope USER_FOLLOW_MODIFY = new Scope("user-follow-modify");
        public static final /* enum */ Scope USER_FOLLOW_READ = new Scope("user-follow-read");
        public static final /* enum */ Scope USER_LIBRARY_MODIFY = new Scope("user-library-modify");
        public static final /* enum */ Scope USER_LIBRARY_READ = new Scope("user-library-read");
        public static final /* enum */ Scope STREAMING = new Scope("streaming");
        public static final /* enum */ Scope APP_REMOTE_CONTROL = new Scope("app-remote-control");
        public static final /* enum */ Scope USER_READ_PLAYBACK_POSITION = new Scope("user-read-playback-position");
        public static final /* enum */ Scope USER_TOP_READ = new Scope("user-top-read");
        public static final /* enum */ Scope USER_READ_RECENTLY_PLAYED = new Scope("user-read-recently-played");
        public static final /* enum */ Scope PLAYLIST_MODIFY_PRIVATE = new Scope("playlist-modify-private");
        public static final /* enum */ Scope PLAYLIST_READ_COLLABORATIVE = new Scope("playlist-read-collaborative");
        public static final /* enum */ Scope PLAYLIST_READ_PRIVATE = new Scope("playlist-read-private");
        public static final /* enum */ Scope PLAYLIST_MODIFY_PUBLIC = new Scope("playlist-modify-public");
        private static final /* synthetic */ Scope[] $VALUES;

        private Scope(String value) {
            this.value = value;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public static Scope[] values() {
            return (Scope[])$VALUES.clone();
        }

        public static Scope valueOf(String value) {
            return Enum.valueOf(Scope.class, value);
        }

        static {
            $VALUES = scopeArray = new Scope[]{Scope.UGC_IMAGE_UPLOAD, Scope.USER_READ_PLAYBACK_STATE, Scope.USER_MODIFY_PLAYBACK_STATE, Scope.USER_READ_CURRENTLY_PLAYING, Scope.USER_READ_PRIVATE, Scope.USER_READ_EMAIL, Scope.USER_FOLLOW_MODIFY, Scope.USER_FOLLOW_READ, Scope.USER_LIBRARY_MODIFY, Scope.USER_LIBRARY_READ, Scope.STREAMING, Scope.APP_REMOTE_CONTROL, Scope.USER_READ_PLAYBACK_POSITION, Scope.USER_TOP_READ, Scope.USER_READ_RECENTLY_PLAYED, Scope.PLAYLIST_MODIFY_PRIVATE, Scope.PLAYLIST_READ_COLLABORATIVE, Scope.PLAYLIST_READ_PRIVATE, Scope.PLAYLIST_MODIFY_PUBLIC};
        }
    }
}

