/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.versionmatched;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.reflection.RefConstructed;
import tr.com.infumia.reflection.cls.ClassOf;
import tr.com.infumia.versionmatched.VersionClass;

public record VersionMatched<T>(@NotNull String version, @NotNull Iterable<VersionClass<? extends T>> versionClasses) {
    @SafeVarargs
    public VersionMatched(@NotNull String version, Class<? extends T> ... versionClasses) {
        this(version, Stream.of(versionClasses).map(VersionClass::new).collect(Collectors.toSet()));
    }

    @SafeVarargs
    public VersionMatched(Class<? extends T> ... versionClasses) {
        this(Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3].substring(1), Stream.of(versionClasses).map(VersionClass::new).collect(Collectors.toSet()));
    }

    @NotNull
    public RefConstructed<? extends T> of(Object ... types) {
        Class match = this.match();
        return new ClassOf<T>(match).getConstructor(types).orElseThrow(() -> new IllegalStateException("Couldn't find any constructor on '%s' version!".formatted(match.getSimpleName())));
    }

    @NotNull
    public RefConstructed<? extends T> ofPrimitive(Object ... types) {
        Class match = this.match();
        return new ClassOf<T>(match).getPrimitiveConstructor(types).orElseThrow(() -> new IllegalStateException("Couldn't find any constructor on '%s' version!".formatted(match.getSimpleName())));
    }

    @NotNull
    private Class<? extends T> match() {
        for (VersionClass<T> versionClass : this.versionClasses) {
            if (!versionClass.test(this.version)) continue;
            return versionClass.versionClass();
        }
        throw new IllegalStateException("Couldn't find any matched class on '%s' version!".formatted(this.version));
    }
}

