/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.versionmatched;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

record VersionClass<T>(@NotNull String rawClassName, @NotNull Class<? extends T> versionClass) implements Predicate<String>
{
    VersionClass(@NotNull Class<? extends T> versionClass) {
        this(versionClass.getSimpleName(), versionClass);
    }

    @Override
    public boolean test(String s) {
        return this.version().equals(s);
    }

    private int indexOfFirstNumber() {
        AtomicInteger index = new AtomicInteger();
        for (char c : this.rawClassName.toCharArray()) {
            if (Character.isDigit(c)) break;
            index.incrementAndGet();
        }
        return index.get();
    }

    @NotNull
    private String version() {
        int sub = this.indexOfFirstNumber();
        Preconditions.checkState((sub != -1 ? 1 : 0) != 0, (String)"version() -> Invalid name for \"%s\"", (Object)this.rawClassName);
        return this.rawClassName.substring(sub);
    }
}

