/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.velocity;

import com.velocitypowered.api.plugin.PluginDescription;
import com.velocitypowered.api.proxy.ProxyServer;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.time.Duration;
import net.kyori.adventure.audience.Audience;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.files.InfumiaLibConfig;
import tr.com.infumia.infumialib.kubernetes.DiscoveryScanner;
import tr.com.infumia.infumialib.kubernetes.Kubernetes;
import tr.com.infumia.infumialib.kubernetes.KubernetesDiscoveryService;
import tr.com.infumia.infumialib.messengers.ProxyMessenger;
import tr.com.infumia.infumialib.misc.GitHubUpdateChecker;
import tr.com.infumia.infumialib.platform.velocity.InfumiaLib;
import tr.com.infumia.infumialib.platform.velocity.files.VelocityConfig;
import tr.com.infumia.infumialib.platform.velocity.multiserver.LoadBalancing;
import tr.com.infumia.infumialib.platform.velocity.multiserver.ProxySynchronizer;
import tr.com.infumia.infumialib.platform.velocity.multiserver.VelocityDiscoveryWatcher;
import tr.com.infumia.infumialib.platform.velocity.multiserver.VelocityTracker;
import tr.com.infumia.infumialib.tracker.PlayerTracker;
import tr.com.infumia.infumialib.tracker.ServerTracker;

final class Initializer {
    private Initializer() {
    }

    static void init(@NotNull InfumiaLib plugin) {
        plugin.metricsFactory().make(plugin, 11422);
        InfumiaLibConfig.loadConfig(plugin.dataDirectory().resolve("config.yml"));
        VelocityConfig.loadConfig(plugin.dataDirectory().resolve("velocity.yml"));
        Initializer.checkForUpdates(plugin);
        Initializer.startMultiServer(plugin);
    }

    private static void checkForUpdates(@NotNull InfumiaLib plugin) {
        if (!InfumiaLibConfig.checkForUpdate) {
            return;
        }
        ProxyServer server = plugin.server();
        PluginDescription description = plugin.container().getDescription();
        GitHubUpdateChecker.checkForUpdate((Audience)server.getConsoleCommandSource(), plugin.logger(), (String)description.getVersion().orElseThrow(), (String)description.getName().orElseThrow(), "Infumia", "InfumiaLib");
    }

    private static void startMultiServer(@NotNull InfumiaLib plugin) {
        if (!VelocityConfig.multiServer) {
            return;
        }
        ProxyServer server = plugin.server();
        Kubernetes.initClient();
        Kubernetes.initRedis(VelocityConfig.redisPassword);
        ServerTracker serverTracker = ServerTracker.simple();
        ProxySynchronizer synchronizer = new ProxySynchronizer(server, serverTracker);
        server.getEventManager().register((Object)plugin, (Object)synchronizer);
        server.getScheduler().buildTask((Object)plugin, (Runnable)synchronizer).repeat(Duration.ofSeconds(1L)).schedule();
        PlayerTracker playerTracker = PlayerTracker.simple(ProxyMessenger.get());
        server.getEventManager().register((Object)plugin, (Object)new VelocityTracker(plugin, synchronizer, serverTracker, playerTracker));
        DiscoveryScanner scanner = new DiscoveryScanner(new KubernetesDiscoveryService((KubernetesClient)new DefaultKubernetesClient()), new VelocityDiscoveryWatcher(server));
        server.getEventManager().register((Object)plugin, (Object)new LoadBalancing(server, plugin.logger()));
        server.getScheduler().buildTask((Object)plugin, scanner::scan).repeat(Duration.ofSeconds(5L)).schedule();
    }
}

