/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.velocity.synchronizer;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.velocitypowered.api.proxy.ProxyServer;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.messaging.messengers.ProxyMessenger;
import tr.com.infumia.infumialib.messaging.proto.Definitions;
import tr.com.infumia.infumialib.platform.velocity.synchronizer.ProxyServerInfo;

public final class ProxySynchronizer
implements Runnable {
    @NotNull
    private final ProxyServerInfo info;
    private final Cache<String, ProxyServerInfo> proxies = Caffeine.newBuilder().expireAfterWrite(Duration.ofMillis(1500L)).build();

    public ProxySynchronizer(@NotNull ProxyServerInfo info) {
        this.info = info;
        ProxyMessenger.get().subscribe(Definitions.ServerInfo.getDefaultInstance(), (serverMessage, serverInfo) -> {
            if (!serverInfo.getUniqueId().equals(this.info.uniqueId())) {
                this.proxies.put((Object)serverInfo.getUniqueId(), (Object)new ProxyServerInfo((Definitions.ServerInfo)serverInfo));
            }
        });
    }

    public ProxySynchronizer(@NotNull ProxyServer server) {
        this(new ProxyServerInfo(server));
    }

    @Override
    public void run() {
        System.out.printf("Server cache size: %s, Server caches: %s%n", this.proxies.asMap().size(), this.proxies.asMap().keySet());
        ProxyMessenger.get().publish("proxy-sync", this.info.toProto());
    }
}

