/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.velocity;

import com.velocitypowered.api.plugin.PluginDescription;
import com.velocitypowered.api.proxy.ProxyServer;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.time.Duration;
import net.kyori.adventure.audience.Audience;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.files.InfumiaLibConfig;
import tr.com.infumia.infumialib.kubernetes.DiscoveryScanner;
import tr.com.infumia.infumialib.kubernetes.Kubernetes;
import tr.com.infumia.infumialib.kubernetes.KubernetesDiscoveryService;
import tr.com.infumia.infumialib.platform.velocity.InfumiaLib;
import tr.com.infumia.infumialib.platform.velocity.files.VelocityConfig;
import tr.com.infumia.infumialib.platform.velocity.kubernetes.LoadBalancing;
import tr.com.infumia.infumialib.platform.velocity.kubernetes.VelocityDiscoveryWatcher;
import tr.com.infumia.infumialib.platform.velocity.synchronizer.ProxySynchronizer;
import tr.com.infumia.infumialib.util.GitHubUpdateChecker;

final class Initializer {
    @Nullable
    private static ProxySynchronizer synchronizer;

    private Initializer() {
    }

    static void init(@NotNull InfumiaLib plugin) {
        plugin.metricsFactory().make(plugin, 11422);
        InfumiaLibConfig.loadConfig(plugin.dataDirectory().resolve("config.yml"));
        VelocityConfig.loadConfig(plugin.dataDirectory().resolve("velocity.yml"));
        ProxyServer server = plugin.server();
        if (InfumiaLibConfig.checkForUpdate) {
            PluginDescription description = plugin.container().getDescription();
            GitHubUpdateChecker.checkForUpdate((Audience)server.getConsoleCommandSource(), plugin.logger(), (String)description.getVersion().orElseThrow(), (String)description.getName().orElseThrow(), "Infumia", "InfumiaLib");
        }
        if (VelocityConfig.multiServer) {
            Kubernetes.initClient();
            Kubernetes.initRedis(VelocityConfig.redisPassword);
            synchronizer = new ProxySynchronizer(server);
            server.getScheduler().buildTask((Object)plugin, (Runnable)synchronizer).repeat(Duration.ofSeconds(1L)).schedule();
            DiscoveryScanner scanner = new DiscoveryScanner(new KubernetesDiscoveryService((KubernetesClient)new DefaultKubernetesClient()), new VelocityDiscoveryWatcher(server));
            server.getEventManager().register((Object)plugin, (Object)new LoadBalancing(server, plugin.logger()));
            server.getScheduler().buildTask((Object)plugin, scanner::scan).repeat(Duration.ofSeconds(5L)).schedule();
        }
    }
}

