/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.velocity.synchronizer;

import com.velocitypowered.api.proxy.ProxyServer;
import java.util.UUID;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.messaging.ServerInfo;
import tr.com.infumia.infumialib.messaging.proto.Definitions;

public record ProxyServerInfo(@NotNull String name, @NotNull String uniqueId, @NotNull String address, int port, long startTime, @NotNull String description) implements ServerInfo
{
    public ProxyServerInfo(@NotNull String uniqueId, @NotNull String address, int port, long startTime, @NotNull String description) {
        this("proxy-" + uniqueId, uniqueId, address, port, startTime, description);
    }

    public ProxyServerInfo(@NotNull ProxyServer server, @NotNull String uniqueId) {
        this("proxy-" + uniqueId, uniqueId, server.getBoundAddress().getHostName(), server.getBoundAddress().getPort(), System.currentTimeMillis(), (String)GsonComponentSerializer.gson().serializeOr(server.getConfiguration().getMotd(), (Object)"Fallback MOTD!"));
    }

    public ProxyServerInfo(@NotNull ProxyServer server) {
        this(server, UUID.randomUUID().toString());
    }

    public ProxyServerInfo(@NotNull Definitions.ServerInfo info) {
        this(info.getName(), info.getUniqueId(), info.getAddress(), info.getPort(), info.getStartTime(), info.getDescription());
    }

    @Override
    @NotNull
    public String group() {
        return "proxy";
    }

    @Override
    public double msPerTick() {
        return -1.0;
    }

    @Override
    public int playerCount() {
        return -1;
    }

    @Override
    public double tps() {
        return -1.0;
    }
}

