/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.common.transformer.resolvers;

import eu.okaeri.hjson.CommentType;
import eu.okaeri.hjson.HjsonOptions;
import eu.okaeri.hjson.JsonArray;
import eu.okaeri.hjson.JsonObject;
import eu.okaeri.hjson.JsonValue;
import eu.okaeri.hjson.Stringify;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.common.transformer.TransformResolver;
import tr.com.infumia.infumialib.common.transformer.annotations.Comment;
import tr.com.infumia.infumialib.common.transformer.declarations.FieldDeclaration;
import tr.com.infumia.infumialib.common.transformer.declarations.GenericDeclaration;
import tr.com.infumia.infumialib.common.transformer.declarations.TransformedObjectDeclaration;
import tr.com.infumia.infumialib.common.transformer.exceptions.TransformException;
import tr.com.infumia.infumialib.common.transformer.postprocessor.PostProcessor;

public class HJsonJson
extends TransformResolver {
    private static final HjsonOptions READ_OPTIONS = new HjsonOptions().setOutputComments(true);
    @NotNull
    private final String commentPrefix;
    private final String sectionSeparator;
    private JsonObject json = new JsonObject();

    public HJsonJson(@NotNull String commentPrefix) {
        this(commentPrefix, "");
    }

    public HJsonJson() {
        this("# ");
    }

    @Override
    @NotNull
    public List<String> allKeys() {
        ArrayList keys = new ArrayList();
        this.json.forEach(member -> keys.add(member.getName()));
        return Collections.unmodifiableList(keys);
    }

    @Override
    @NotNull
    public Optional<Object> getValue(@NotNull String path) {
        return this.fromJsonValue(this.json.get(path));
    }

    @Override
    public void load(@NotNull InputStream inputStream, @NotNull TransformedObjectDeclaration declaration) {
        this.json = JsonValue.readHjson((String)PostProcessor.of(inputStream).getContext(), (HjsonOptions)READ_OPTIONS).asObject();
    }

    @Override
    public boolean pathExists(@NotNull String path) {
        return this.json.has(path);
    }

    @Override
    public void removeValue(@NotNull String path, @Nullable GenericDeclaration genericType, @Nullable FieldDeclaration field) {
        this.json.remove(path);
    }

    @Override
    public Object serialize(@Nullable Object value, @Nullable GenericDeclaration genericType, boolean conservative) throws TransformException {
        if (value == null) {
            return null;
        }
        GenericDeclaration genericsDeclaration = GenericDeclaration.of(value);
        if (genericsDeclaration.getType() == Character.TYPE || genericsDeclaration.getType() == Character.class) {
            return super.serialize(value, genericType, false);
        }
        return super.serialize(value, genericType, conservative);
    }

    @Override
    @NotNull
    public Map<?, ?> serializeMap(@NotNull Map<?, ?> value, @Nullable GenericDeclaration genericType, boolean conservative) throws TransformException {
        LinkedHashMap map = new LinkedHashMap();
        GenericDeclaration keyDeclaration = genericType == null ? null : (GenericDeclaration)genericType.getSubTypeAt(0).orElse(null);
        GenericDeclaration valueDeclaration = genericType == null ? null : (GenericDeclaration)genericType.getSubTypeAt(1).orElse(null);
        value.forEach((key1, value1) -> {
            Object key = this.serialize(key1, keyDeclaration, false);
            Object kValue = this.serialize(value1, valueDeclaration, conservative);
            map.put(key, kValue);
        });
        return map;
    }

    @Override
    public void setValue(@NotNull String path, @Nullable Object value, @Nullable GenericDeclaration genericType, @Nullable FieldDeclaration field) {
        this.json.set(path, this.toJsonValue(this.serialize(value, genericType, true)));
    }

    @Override
    public void write(@NotNull OutputStream outputStream, @NotNull TransformedObjectDeclaration declaration) {
        this.addComments((JsonValue)this.json, declaration, null);
        Comment header = declaration.getHeader();
        String[] comments = header == null ? null : header.value();
        String comment = PostProcessor.createComment(this.commentPrefix, comments);
        this.json.setFullComment(CommentType.BOL, (String)(comment.isEmpty() ? "" : comment + this.sectionSeparator));
        PostProcessor.of(this.json.toString(Stringify.HJSON_COMMENTS)).write(outputStream);
    }

    private void addComments(@NotNull JsonValue jsonValue, @NotNull TransformedObjectDeclaration declaration, @Nullable String path) {
        FieldDeclaration field = declaration.getNonMigratedFields().get(path);
        if (jsonValue instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonValue;
            if (field == null) {
                jsonObject.names().forEach(name -> this.addComments(jsonObject.get(name), declaration, (String)name));
            } else {
                TransformedObjectDeclaration transformedObjectDeclaration = TransformedObjectDeclaration.of(field.getGenericDeclaration().getType());
                jsonObject.names().forEach(name -> this.addComments(jsonObject.get(name), transformedObjectDeclaration, (String)name));
            }
        }
        if (jsonValue instanceof JsonArray && field != null) {
            field.getGenericDeclaration().getSubTypeAt(0).ifPresent(arrayType -> {
                TransformedObjectDeclaration transformedObjectDeclaration = TransformedObjectDeclaration.of(arrayType.getType());
                ((JsonArray)jsonValue).forEach(item -> this.addComments((JsonValue)item, transformedObjectDeclaration, null));
            });
        }
        if (field == null) {
            return;
        }
        Comment comment = field.getComment();
        if (comment == null) {
            return;
        }
        String comments = PostProcessor.createComment(this.commentPrefix, comment.value());
        jsonValue.setFullComment(CommentType.BOL, (String)(comments.isEmpty() ? "" : this.sectionSeparator + comments));
    }

    @NotNull
    private Optional<Object> fromJsonValue(@NotNull JsonValue value) {
        if (value.isNull()) {
            return Optional.empty();
        }
        if (value instanceof JsonArray) {
            ArrayList values = new ArrayList();
            ((JsonArray)value).forEach(item -> this.fromJsonValue((JsonValue)item).ifPresent(values::add));
            return Optional.of(values);
        }
        if (value instanceof JsonObject) {
            LinkedHashMap map = new LinkedHashMap();
            JsonObject object = (JsonObject)value;
            object.forEach(member -> this.fromJsonValue(member.getValue()).ifPresent(memberValue -> map.put(member.getName(), memberValue)));
            return Optional.of(map);
        }
        return Optional.ofNullable(value.asRaw());
    }

    @NotNull
    private JsonValue toJsonValue(@Nullable Object object) {
        if (object == null) {
            return JsonValue.valueOf(null);
        }
        if (object instanceof String) {
            return JsonValue.valueOf((String)((String)object));
        }
        if (object instanceof Collection) {
            JsonArray array = new JsonArray();
            ((Collection)object).forEach(item -> array.add(this.toJsonValue(item)));
            return array;
        }
        if (object instanceof Map) {
            JsonObject map = new JsonObject();
            ((Map)object).forEach((key, value) -> map.add(key, this.toJsonValue(value)));
            return map;
        }
        if (object instanceof Number || object instanceof Boolean) {
            return JsonValue.valueOf((Object)object);
        }
        throw new IllegalArgumentException(String.format("Cannot transform element: %s [%s]", object, object.getClass()));
    }

    public HJsonJson(@NotNull String commentPrefix, String sectionSeparator) {
        if (commentPrefix == null) {
            throw new NullPointerException("commentPrefix is marked non-null but is null");
        }
        this.commentPrefix = commentPrefix;
        this.sectionSeparator = sectionSeparator;
    }
}

