/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.common.transformer.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.api.reflection.RefField;
import tr.com.infumia.infumialib.common.transformer.annotations.CustomKey;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface Names {
    public Modifier modifier() default Modifier.NONE;

    public Strategy strategy() default Strategy.IDENTITY;

    public static final class Calculated {
        private Calculated() {
        }

        @Nullable
        public static Names calculateNames(@NotNull Class<?> cls) {
            Class<?> tempCls = cls;
            Names names = tempCls.getAnnotation(Names.class);
            while (names == null) {
                if ((tempCls = tempCls.getEnclosingClass()) == null) {
                    return null;
                }
                names = tempCls.getAnnotation(Names.class);
            }
            return names;
        }

        @NotNull
        public static String calculatePath(@Nullable Names parent, @NotNull RefField field) {
            AtomicReference<String> path = new AtomicReference<String>();
            if (parent != null) {
                path.set((String)parent.modifier().apply(parent.strategy().apply(field.getName())));
            }
            field.getAnnotation(CustomKey.class, customKey -> path.set(customKey.value()));
            path.compareAndSet(null, field.getName());
            return (String)path.get();
        }
    }

    public static enum Strategy implements UnaryOperator<String>
    {
        IDENTITY("", ""),
        SNAKE_CASE("$1_$2", "(\\G(?!^)|\\b(?:[A-Z]{2}|[a-zA-Z][a-z]*))(?=[a-zA-Z]{2,}|\\d)([A-Z](?:[A-Z]|[a-z]*)|\\d+)"),
        HYPHEN_CASE("$1-$2", "(\\G(?!^)|\\b(?:[A-Z]{2}|[a-zA-Z][a-z]*))(?=[a-zA-Z]{2,}|\\d)([A-Z](?:[A-Z]|[a-z]*)|\\d+)");

        @NotNull
        private final Pattern pattern;
        @NotNull
        private final String replacement;

        private Strategy(String replacement, String regex) {
            this.replacement = replacement;
            this.pattern = Pattern.compile(regex);
        }

        @Override
        public String apply(@NotNull String s) {
            return this.pattern.matcher(s).replaceAll(this.replacement);
        }
    }

    public static enum Modifier implements UnaryOperator<String>
    {
        NONE{

            @Override
            public String apply(@NotNull String s) {
                return s;
            }
        }
        ,
        TO_UPPER_CASE{

            @Override
            public String apply(@NotNull String s) {
                return s.toUpperCase(Locale.ROOT);
            }
        }
        ,
        TO_LOWER_CASE{

            @Override
            public String apply(@NotNull String s) {
                return s.toLowerCase(Locale.ROOT);
            }
        };

    }
}

