/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.velocity.kubernetes;

import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.ServerInfo;
import java.net.InetSocketAddress;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.api.kubernetes.DiscoveredService;
import tr.com.infumia.infumialib.api.kubernetes.DiscoveryWatcher;
import tr.com.infumia.infumialib.api.kubernetes.ServerRegistry;

public record VelocityDiscoveryWatcher(@NotNull ProxyServer proxyServer) implements DiscoveryWatcher
{
    @NotNull
    private static ServerInfo discoveredServiceAsServerInfo(@NotNull DiscoveredService service) {
        return new ServerInfo(service.name(), new InetSocketAddress(service.host(), service.port()));
    }

    @Override
    public void onCreate(@NotNull DiscoveredService service) {
        this.addServer(service);
    }

    @Override
    public void onDelete(@NotNull DiscoveredService service) {
        this.removeServer(service);
    }

    private void addServer(@NotNull DiscoveredService service) {
        this.proxyServer.registerServer(VelocityDiscoveryWatcher.discoveredServiceAsServerInfo(service));
        this.proxyServer.getConfiguration().getAttemptConnectionOrder().add(service.name());
        ServerRegistry.register(service);
    }

    private void removeServer(@NotNull DiscoveredService service) {
        ServerRegistry.unregister(service);
        this.proxyServer.getConfiguration().getAttemptConnectionOrder().remove(service.name());
        this.proxyServer.unregisterServer(VelocityDiscoveryWatcher.discoveredServiceAsServerInfo(service));
    }
}

