/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.messaging;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.messaging.ErrorHandler;
import tr.com.infumia.infumialib.messaging.Portal;
import tr.com.infumia.infumialib.messaging.ServerSender;
import tr.com.infumia.infumialib.messaging.messengers.ServerMessenger;
import tr.com.infumia.infumialib.messaging.proto.Definitions;
import tr.com.infumia.infumialib.messaging.proto.Messaging;

public interface Travel {
    @NotNull
    public ErrorHandler errorHandler();

    public boolean isTravelling(@NotNull String var1);

    @NotNull
    public ServerMessenger serverMessenger();

    @NotNull
    public ServerSender serverSender();

    public record Response(@NotNull Supplier<@Nullable Definitions.ErrorCodes> errorCatcher, long time, @NotNull String type) {
        public Response(@NotNull Supplier<@Nullable Definitions.ErrorCodes> errorCatcher, @NotNull String type) {
            this(errorCatcher, System.currentTimeMillis(), type);
        }
    }

    public record Request(@NotNull @NotNull Supplier<@NotNull Definitions.Position> supplier, long time, @NotNull String type) {
        public Request(@NotNull @NotNull Supplier<@NotNull Definitions.Position> supplier, @NotNull String type) {
            this(supplier, System.currentTimeMillis(), type);
        }
    }

    public static abstract class Base
    implements Travel {
        @NotNull
        private final ErrorHandler errorHandler;
        @NotNull
        private final @NotNull Cache<@NotNull String, @NotNull Request> requests = Caffeine.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();
        @NotNull
        private final @NotNull Cache<@NotNull String, @NotNull Response> responses = Caffeine.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();
        @NotNull
        private final ServerMessenger serverMessenger;
        @NotNull
        private final ServerSender serverSender;
        @NotNull
        private final @NotNull Cache<@NotNull String, @NotNull String> transfer = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build();

        protected Base(@NotNull ServerMessenger serverMessenger, @NotNull ErrorHandler errorHandler, @NotNull ServerSender serverSender) {
            this.serverMessenger = serverMessenger;
            this.errorHandler = errorHandler;
            this.serverSender = serverSender;
            serverMessenger.subscribe(Messaging.Travel.Request.getDefaultInstance(), this::onRequest);
            serverMessenger.subscribe(Messaging.Travel.Response.getDefaultInstance(), this::onResponse);
        }

        @Override
        public final boolean isTravelling(@NotNull String uniqueId) {
            return this.transfer.asMap().containsKey(uniqueId);
        }

        private <T> void onRequest(@NotNull Messaging.ServerMessage serverMessage, @NotNull Messaging.Travel.Request request) {
            Portal.get(request.getType()).ifPresentOrElse(portal -> {
                Optional<Object> deserialize = portal.deserialize(request.getValue().toByteArray()).map(o -> o);
                if (deserialize.isEmpty()) {
                    this.sendResponse(serverMessage, request, Definitions.ErrorCodes.CODE_002);
                    return;
                }
                Object value = deserialize.get();
                Optional<Supplier<Definitions.Position>> position = portal.onRequest(request.getSource().getId(), value);
                if (position.isEmpty()) {
                    this.sendResponse(serverMessage, request, Definitions.ErrorCodes.CODE_003);
                    return;
                }
                this.requests.put((Object)request.getSource().getId(), (Object)new Request(position.get(), portal.type()));
                this.sendResponse(serverMessage, request, null);
            }, () -> this.sendResponse(serverMessage, request, Definitions.ErrorCodes.CODE_001));
        }

        private void onResponse(@NotNull Messaging.ServerMessage serverMessage, @NotNull Messaging.Travel.Response travelResponse) {
            String uniqueId = travelResponse.getSource().getId();
            Response response = (Response)this.responses.getIfPresent((Object)uniqueId);
            if (response == null) {
                this.errorHandler.onError(uniqueId, Definitions.ErrorCodes.CODE_004);
                return;
            }
            this.responses.invalidate((Object)uniqueId);
            boolean done = travelResponse.getDone();
            if (!done) {
                this.errorHandler.onError(uniqueId, travelResponse.getReason());
                return;
            }
            Definitions.ErrorCodes caughtError = response.errorCatcher().get();
            if (caughtError != null) {
                this.errorHandler.onError(uniqueId, caughtError);
                return;
            }
            this.serverSender.send(uniqueId, serverMessage.getSource());
        }

        private void sendResponse(@NotNull Messaging.ServerMessage message, @NotNull Messaging.Travel.Request request, @Nullable Definitions.ErrorCodes errorCode) {
            Messaging.Travel.Response.Builder response = Messaging.Travel.Response.newBuilder().setSource(request.getSource()).setType(request.getType()).setDone(errorCode == null);
            if (errorCode != null) {
                response.setReason(errorCode);
            }
            this.serverMessenger.publish(message.getSource(), response.build());
        }

        @Override
        @NotNull
        public ErrorHandler errorHandler() {
            return this.errorHandler;
        }

        @Override
        @NotNull
        public ServerMessenger serverMessenger() {
            return this.serverMessenger;
        }

        @Override
        @NotNull
        public ServerSender serverSender() {
            return this.serverSender;
        }
    }
}

