/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.api.scoreboard.line.lines;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.api.scoreboard.line.LineColor;
import tr.com.infumia.infumialib.api.scoreboard.line.lines.FramedLine;

public abstract class ScrolledLine<O>
extends FramedLine<O> {
    @NotNull
    private final List<String> list = new ArrayList<String>();
    @NotNull
    private final String message;
    private final AtomicInteger position = new AtomicInteger();
    private final int spaceBetween;
    private final int width;
    @NotNull
    private LineColor color;

    protected ScrolledLine(@NotNull String message, int spaceBetween, int width, @NotNull LineColor color) {
        super(new ArrayList<String>());
        this.message = color.format(message);
        this.spaceBetween = spaceBetween;
        this.width = width;
        this.color = color;
    }

    @Override
    @NotNull
    public final String getNext(@NotNull O observer) {
        StringBuilder sb = this.generateNextBuilder();
        if (sb.charAt(sb.length() - 1) == this.color.getColorChar()) {
            sb.setCharAt(sb.length() - 1, ' ');
        }
        if (sb.charAt(0) != this.color.getColorChar()) {
            return this.color.toString() + sb;
        }
        LineColor charAt = this.color.getByChar(sb.charAt(1));
        if (charAt == null) {
            return this.color.toString() + sb;
        }
        this.color = charAt;
        sb = this.generateNextBuilder();
        if (sb.charAt(0) != ' ') {
            sb.setCharAt(0, ' ');
        }
        return this.color.toString() + sb;
    }

    protected final void generate() {
        int i;
        int tempWidth = this.width;
        int tempSpaceBetween = this.spaceBetween;
        String tempMessage = this.message;
        if (tempMessage.length() < tempWidth) {
            StringBuilder sb = new StringBuilder(tempMessage);
            while (sb.length() < tempWidth) {
                sb.append(" ");
            }
            tempMessage = sb.toString();
        }
        if ((tempWidth -= 2) < 1) {
            tempWidth = 1;
        }
        if (tempSpaceBetween < 0) {
            tempSpaceBetween = 0;
        }
        for (int i2 = 0; i2 < tempMessage.length() - tempWidth; ++i2) {
            this.list.add(tempMessage.substring(i2, i2 + tempWidth));
        }
        StringBuilder space = new StringBuilder();
        for (i = 0; i < tempSpaceBetween; ++i) {
            this.list.add(tempMessage.substring(tempMessage.length() - tempWidth + Math.min(i, tempWidth)) + space);
            if (space.length() >= tempWidth) continue;
            space.append(" ");
        }
        for (i = 0; i < tempWidth - tempSpaceBetween; ++i) {
            this.list.add(tempMessage.substring(tempMessage.length() - tempWidth + tempSpaceBetween + i) + space + tempMessage.substring(0, i));
        }
        for (i = 0; i < tempSpaceBetween && i <= space.length(); ++i) {
            this.list.add(space.substring(0, space.length() - i) + tempMessage.substring(0, tempWidth - Math.min(tempSpaceBetween, tempWidth) + i));
        }
    }

    @NotNull
    private StringBuilder generateNextBuilder() {
        return new StringBuilder(this.list.get(this.position.getAndIncrement() % this.list.size()));
    }
}

