/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.api.equilibrium;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;

final class Utilities {
    private Utilities() {
    }

    static boolean equals(@NotNull Object leftObject, @NotNull Object rightObject) {
        return Objects.equals(leftObject, rightObject);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean instanceOf(@NotNull Object leftObject, @NotNull Object rightObject) {
        Object object = leftObject;
        if (!(object instanceof Class)) return false;
        Class leftClass = (Class)object;
        object = rightObject;
        if (!(object instanceof Class)) return false;
        Class rightClass = (Class)object;
        if (!rightClass.isAssignableFrom(leftClass)) return false;
        return true;
    }

    static boolean isBigger(@NotNull Object leftObject, @NotNull Object rightObject) {
        Number left;
        Object object;
        block10: {
            block9: {
                object = leftObject;
                if (!(object instanceof Number)) break block9;
                left = (Number)object;
                object = rightObject;
                if (object instanceof Number) break block10;
            }
            return false;
        }
        Number right = (Number)object;
        if (left instanceof Double) {
            return left.doubleValue() > right.doubleValue();
        }
        if (left instanceof Integer) {
            return left.intValue() > right.intValue();
        }
        if (left instanceof Long) {
            return left.longValue() > right.longValue();
        }
        if (left instanceof Float) {
            return left.floatValue() > right.floatValue();
        }
        if (left instanceof Short) {
            return left.shortValue() > right.shortValue();
        }
        if (left instanceof Byte) {
            return left.byteValue() > right.byteValue();
        }
        return false;
    }

    static boolean isBiggerEquals(@NotNull Object leftObject, @NotNull Object rightObject) {
        Number left;
        Object object;
        block10: {
            block9: {
                object = leftObject;
                if (!(object instanceof Number)) break block9;
                left = (Number)object;
                object = rightObject;
                if (object instanceof Number) break block10;
            }
            return false;
        }
        Number right = (Number)object;
        if (left instanceof Double) {
            return left.doubleValue() >= right.doubleValue();
        }
        if (left instanceof Integer) {
            return left.intValue() >= right.intValue();
        }
        if (left instanceof Long) {
            return left.longValue() >= right.longValue();
        }
        if (left instanceof Float) {
            return left.floatValue() >= right.floatValue();
        }
        if (left instanceof Short) {
            return left.shortValue() >= right.shortValue();
        }
        if (left instanceof Byte) {
            return left.byteValue() >= right.byteValue();
        }
        return false;
    }

    static boolean isLess(@NotNull Object leftObject, @NotNull Object rightObject) {
        return !Utilities.isBiggerEquals(leftObject, rightObject);
    }

    static boolean isLessEquals(@NotNull Object leftObject, @NotNull Object rightObject) {
        return !Utilities.isBigger(leftObject, rightObject);
    }

    static boolean noInstanceOf(@NotNull Object leftObject, @NotNull Object rightObject) {
        return !Utilities.instanceOf(leftObject, rightObject);
    }

    static boolean notEqual(@NotNull Object leftObject, @NotNull Object rightObject) {
        return !Utilities.equals(leftObject, rightObject);
    }
}

