/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.injector.helper;

import io.github.slimjar.downloader.DependencyDownloader;
import io.github.slimjar.downloader.DependencyDownloaderFactory;
import io.github.slimjar.downloader.output.DependencyOutputWriterFactory;
import io.github.slimjar.downloader.strategy.FilePathStrategy;
import io.github.slimjar.downloader.verify.DependencyVerifierFactory;
import io.github.slimjar.injector.DependencyInjectorFactory;
import io.github.slimjar.injector.helper.InjectionHelper;
import io.github.slimjar.relocation.Relocator;
import io.github.slimjar.relocation.RelocatorFactory;
import io.github.slimjar.relocation.helper.RelocationHelper;
import io.github.slimjar.relocation.helper.RelocationHelperFactory;
import io.github.slimjar.resolver.DependencyResolver;
import io.github.slimjar.resolver.DependencyResolverFactory;
import io.github.slimjar.resolver.ResolutionResult;
import io.github.slimjar.resolver.data.DependencyData;
import io.github.slimjar.resolver.data.Repository;
import io.github.slimjar.resolver.enquirer.RepositoryEnquirerFactory;
import io.github.slimjar.resolver.mirrors.MirrorSelector;
import io.github.slimjar.resolver.reader.dependency.DependencyDataProviderFactory;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Map;

public final class InjectionHelperFactory {
    private final Path downloadDirectoryPath;
    private final RelocatorFactory relocatorFactory;
    private final RelocationHelperFactory relocationHelperFactory;
    private final DependencyResolverFactory resolverFactory;
    private final RepositoryEnquirerFactory enquirerFactory;
    private final DependencyDownloaderFactory downloaderFactory;
    private final DependencyVerifierFactory verifier;
    private final MirrorSelector mirrorSelector;

    public InjectionHelperFactory(Path downloadDirectoryPath, RelocatorFactory relocatorFactory, DependencyDataProviderFactory dataProviderFactory, RelocationHelperFactory relocationHelperFactory, DependencyInjectorFactory injectorFactory, DependencyResolverFactory resolverFactory, RepositoryEnquirerFactory enquirerFactory, DependencyDownloaderFactory downloaderFactory, DependencyVerifierFactory verifier, MirrorSelector mirrorSelector) {
        this.downloadDirectoryPath = downloadDirectoryPath;
        this.relocatorFactory = relocatorFactory;
        this.relocationHelperFactory = relocationHelperFactory;
        this.resolverFactory = resolverFactory;
        this.enquirerFactory = enquirerFactory;
        this.downloaderFactory = downloaderFactory;
        this.verifier = verifier;
        this.mirrorSelector = mirrorSelector;
    }

    public InjectionHelper create(DependencyData data, Map<String, ResolutionResult> preResolvedResults) throws IOException, NoSuchAlgorithmException, URISyntaxException {
        Collection<Repository> repositories = this.mirrorSelector.select(data.getRepositories(), data.getMirrors());
        Relocator relocator = this.relocatorFactory.create(data.getRelocations());
        RelocationHelper relocationHelper = this.relocationHelperFactory.create(relocator);
        FilePathStrategy filePathStrategy = FilePathStrategy.createDefault(this.downloadDirectoryPath.toFile());
        DependencyOutputWriterFactory outputWriterFactory = new DependencyOutputWriterFactory(filePathStrategy);
        DependencyResolver resolver = this.resolverFactory.create(repositories, preResolvedResults, this.enquirerFactory);
        DependencyDownloader downloader = this.downloaderFactory.create(outputWriterFactory, resolver, this.verifier.create(resolver));
        return new InjectionHelper(downloader, relocationHelper);
    }
}

