/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.messaging;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.definition.Definition;
import tr.com.infumia.infumialib.messaging.NativeTeleportController;
import tr.com.infumia.infumialib.proto.Definitions;

public interface Teleport
extends Definition.UserFinderHolder,
Definition.EarthFinderHolder,
Definition.PositionConverterHolder,
Definition.NativeTeleportHolder {
    default public @NotNull CompletableFuture<@Nullable Definitions.Error> teleport(@NotNull Definition.OfflineUser source, @NotNull Definition.Position position) {
        String userId = source.id();
        Optional nativeUserOptional = (Optional)this.userFinder().apply(userId);
        if (nativeUserOptional.isEmpty()) {
            return CompletableFuture.completedFuture(Definitions.Error.newBuilder().setError("player-not-found").addArgs(userId).addArgs(source.name()).build());
        }
        Definition.Earth earth = position.earth();
        String earthId = earth.id();
        Optional nativeEarth = (Optional)this.earthFinder().apply(earthId);
        if (nativeEarth.isEmpty()) {
            return CompletableFuture.completedFuture(Definitions.Error.newBuilder().setError("world-not-found").addArgs(earthId).addArgs(earth.name()).build());
        }
        Object nativeUser = nativeUserOptional.get();
        Object nativePosition = this.positionConverter().apply(position, nativeEarth.get());
        return NativeTeleportController.anyError(nativeUser, nativePosition).thenCompose(result -> {
            if (result != null) {
                return CompletableFuture.completedFuture(result);
            }
            return (CompletionStage)this.nativeTeleport().apply(nativeUser, nativePosition);
        });
    }
}

