/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.slimjar.downloader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import tr.com.infumia.infumialib.slimjar.downloader.DependencyDownloader;
import tr.com.infumia.infumialib.slimjar.downloader.output.OutputWriter;
import tr.com.infumia.infumialib.slimjar.downloader.output.OutputWriterFactory;
import tr.com.infumia.infumialib.slimjar.downloader.verify.DependencyVerifier;
import tr.com.infumia.infumialib.slimjar.logging.LogDispatcher;
import tr.com.infumia.infumialib.slimjar.logging.ProcessLogger;
import tr.com.infumia.infumialib.slimjar.resolver.DependencyResolver;
import tr.com.infumia.infumialib.slimjar.resolver.ResolutionResult;
import tr.com.infumia.infumialib.slimjar.resolver.UnresolvedDependencyException;
import tr.com.infumia.infumialib.slimjar.resolver.data.Dependency;
import tr.com.infumia.infumialib.slimjar.util.Connections;

public final class URLDependencyDownloader
implements DependencyDownloader {
    private static final byte[] BOM_BYTES = "bom-file".getBytes();
    private static final ProcessLogger LOGGER = LogDispatcher.getMediatingLogger();
    private final DependencyResolver dependencyResolver;
    private final OutputWriterFactory outputWriterProducer;
    private final DependencyVerifier verifier;

    public URLDependencyDownloader(OutputWriterFactory outputWriterProducer, DependencyResolver dependencyResolver, DependencyVerifier verifier) {
        this.outputWriterProducer = outputWriterProducer;
        this.dependencyResolver = dependencyResolver;
        this.verifier = verifier;
    }

    @Override
    public File download(Dependency dependency) throws IOException {
        File expectedOutputFile = this.outputWriterProducer.getStrategy().selectFileFor(dependency);
        if (expectedOutputFile.exists() && expectedOutputFile.length() == (long)BOM_BYTES.length && Arrays.equals(Files.readAllBytes(expectedOutputFile.toPath()), BOM_BYTES)) {
            return null;
        }
        if (this.verifier.verify(expectedOutputFile, dependency)) {
            return expectedOutputFile;
        }
        ResolutionResult result = this.dependencyResolver.resolve(dependency).orElseThrow(() -> new UnresolvedDependencyException(dependency));
        if (result.isAggregator()) {
            expectedOutputFile.getParentFile().mkdirs();
            expectedOutputFile.createNewFile();
            Files.write(expectedOutputFile.toPath(), BOM_BYTES, new OpenOption[0]);
            return null;
        }
        expectedOutputFile.delete();
        File checksumFile = this.verifier.getChecksumFile(dependency);
        if (checksumFile != null) {
            checksumFile.delete();
        }
        LOGGER.log("Downloading {0}:{1}:{2}...", dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
        URL url = result.getDependencyURL();
        LOGGER.debug("Connecting to {0}", url);
        URLConnection connection = Connections.createDownloadConnection(url);
        InputStream inputStream = connection.getInputStream();
        LOGGER.debug("Connection successful! Downloading {0}", dependency.getArtifactId() + "...");
        OutputWriter outputWriter = this.outputWriterProducer.create(dependency);
        LOGGER.debug("{0}.Size = {1}", dependency.getArtifactId(), connection.getContentLength());
        File downloadResult = outputWriter.writeFrom(inputStream, connection.getContentLength());
        Connections.tryDisconnect(connection);
        this.verifier.verify(downloadResult, dependency);
        LOGGER.debug("Artifact {0} downloaded successfully!", dependency.getArtifactId());
        LOGGER.debug("Downloaded {0} successfully!", dependency.getArtifactId());
        return downloadResult;
    }
}

