/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.tracker;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.definition.Definition;
import tr.com.infumia.infumialib.messengers.ProxyMessenger;
import tr.com.infumia.infumialib.proto.Definitions;
import tr.com.infumia.infumialib.tracker.ServerListener;

public interface ServerTracker
extends ServerListener {
    @NotNull
    public static ServerTracker simple() {
        return new Impl();
    }

    @Override
    default public void onRegister(@NotNull Definition.ServerInfo info) {
        this.serverListeners().forEach(listener -> {
            try {
                listener.onRegister(info);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    default public void onUnregister(@NotNull Definition.ServerInfo info) {
        this.serverListeners().forEach(listener -> {
            try {
                listener.onUnregister(info);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void register(@NotNull ServerListener var1);

    @NotNull
    public Optional<Definition.ServerInfo> server(@NotNull String var1);

    @NotNull
    public Collection<ServerListener> serverListeners();

    @NotNull
    public Cache<String, Definition.ServerInfo> servers();

    public static final class Impl
    implements ServerTracker {
        @NotNull
        private final Collection<ServerListener> listeners = new HashSet<ServerListener>();
        private final Cache<String, Definition.ServerInfo> servers = Caffeine.newBuilder().expireAfterWrite(Duration.ofMillis(1500L)).removalListener((key, value, cause) -> {
            if (value != null) {
                this.onUnregister((Definition.ServerInfo)value);
            }
        }).build();

        private Impl() {
            ProxyMessenger.get().subscribe(Definitions.ServerInfo.getDefaultInstance(), info -> this.onRegister(Definition.ServerInfo.of(info)));
        }

        @Override
        public void register(@NotNull ServerListener listener) {
            this.listeners.add(listener);
        }

        @Override
        @NotNull
        public Optional<Definition.ServerInfo> server(@NotNull String id) {
            return Optional.ofNullable((Definition.ServerInfo)this.servers.getIfPresent((Object)id));
        }

        @Override
        @NotNull
        public Collection<ServerListener> serverListeners() {
            return Collections.unmodifiableCollection(this.listeners);
        }

        @Override
        @NotNull
        public Cache<String, Definition.ServerInfo> servers() {
            return this.servers;
        }
    }
}

