/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.transformer;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.reflection.RefMethod;
import tr.com.infumia.infumialib.reflection.clazz.ClassOf;
import tr.com.infumia.infumialib.transformer.ObjectSerializer;
import tr.com.infumia.infumialib.transformer.TransformPack;
import tr.com.infumia.infumialib.transformer.TransformRegistry;
import tr.com.infumia.infumialib.transformer.TransformedData;
import tr.com.infumia.infumialib.transformer.TransformedObject;
import tr.com.infumia.infumialib.transformer.Transformer;
import tr.com.infumia.infumialib.transformer.TransformerPool;
import tr.com.infumia.infumialib.transformer.declarations.FieldDeclaration;
import tr.com.infumia.infumialib.transformer.declarations.GenericDeclaration;
import tr.com.infumia.infumialib.transformer.declarations.TransformedObjectDeclaration;
import tr.com.infumia.infumialib.transformer.exceptions.TransformException;
import tr.com.infumia.infumialib.transformer.resolvers.InMemoryWrappedResolver;

public abstract class TransformResolver {
    @Nullable
    private TransformedObject currentObject;
    @Nullable
    private TransformedObject parentObject;
    @NotNull
    private TransformRegistry registry = new TransformRegistry().withDefaultTransformers();

    @NotNull
    public List<String> allKeys() {
        return this.currentObject == null ? Collections.emptyList() : this.currentObject.getAllKeys();
    }

    @Nullable
    public TransformedObject currentObject() {
        return this.currentObject;
    }

    @Nullable
    @Contract(value="null, _, _, _, _ -> null; !null, _, _, _, _ -> !null")
    public <T> T deserialize(@Nullable Object object, @Nullable GenericDeclaration genericSource, @NotNull Class<T> targetClass, @Nullable GenericDeclaration genericTarget, @Nullable Object defaultValue) throws TransformException {
        Optional<Transformer<?, ?>> transformerOptional;
        GenericDeclaration target;
        if (object == null) {
            return null;
        }
        GenericDeclaration source = genericSource == null ? GenericDeclaration.of(object) : genericSource;
        GenericDeclaration genericDeclaration = target = genericTarget == null ? GenericDeclaration.ofReady(targetClass) : genericTarget;
        if (target.isPrimitive()) {
            target = GenericDeclaration.ofReady(target.toWrapper().orElse(null));
        }
        Class<?> objectClass = object.getClass();
        try {
            if (object instanceof String) {
                String stringObject = (String)object;
                if (target.isEnum()) {
                    ClassOf<T> targetClassOf = new ClassOf<T>(targetClass);
                    try {
                        RefMethod valueOf = targetClassOf.getMethod("valueOf", String.class).orElseThrow();
                        Optional<Object> enumValue = valueOf.call(stringObject);
                        if (enumValue.isPresent()) {
                            return targetClass.cast(enumValue.get());
                        }
                    }
                    catch (Exception e) {
                        Enum[] enumValues = (Enum[])targetClass.getEnumConstants();
                        Enum[] enumArray = enumValues;
                        int n = enumArray.length;
                        for (int i = 0; i < n; ++i) {
                            Enum value2 = enumArray[i];
                            if (!stringObject.equalsIgnoreCase(value2.name())) continue;
                            return targetClass.cast(value2);
                        }
                    }
                    StringJoiner joiner = new StringJoiner(", ");
                    for (Enum item : targetClass.getEnumConstants()) {
                        joiner.add(item.name());
                    }
                    String error = String.format("no enum value for name %s (available: %s)", stringObject, joiner);
                    throw new TransformException(error);
                }
            }
            if (source.isEnum() && targetClass == String.class) {
                Object name = new ClassOf(objectClass).getMethodByName("name").orElseThrow().of(object).call(new Object[0]).orElseThrow(() -> new TransformException(String.format("Something went wrong when getting method called name in %s", objectClass)));
                return targetClass.cast(name);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(String.format("Failed to resolve enum %s <> %s", object.getClass(), targetClass), exception);
        }
        if (TransformedObject.class.isAssignableFrom(targetClass)) {
            T transformedObject = TransformerPool.create(targetClass);
            return (T)((TransformedObject)transformedObject).withResolver(new InMemoryWrappedResolver(this, this.deserialize(object, source, Map.class, GenericDeclaration.of(Map.class, String.class, Object.class), defaultValue)).withParentObject(this.currentObject)).update();
        }
        Optional<ObjectSerializer<?>> serializerOptional = this.registry.getSerializer(targetClass);
        if (object instanceof Map && serializerOptional.isPresent()) {
            TransformedData deserialization = TransformedData.deserialization(this, (Map)object);
            ObjectSerializer<?> serializer = serializerOptional.get();
            Optional<Object> value3 = defaultValue == null ? serializer.deserialize(deserialization, target) : serializer.deserialize(defaultValue, deserialization, target);
            return value3.map(targetClass::cast).orElse(null);
        }
        if (genericTarget != null) {
            if (object instanceof Collection && Collection.class.isAssignableFrom(targetClass)) {
                GenericDeclaration declaration = genericTarget.getSubTypeAt(0).orElseThrow(() -> new TransformException(String.format("Something went wrong when getting sub types(0) of %s", genericTarget)));
                if (declaration.getType() == null) {
                    throw new TransformException(String.format("Something went wrong when getting type of %s", genericTarget));
                }
                Collection targetList = (Collection)TransformerPool.createInstance(targetClass);
                AtomicInteger index = new AtomicInteger();
                for (Object item : (Collection)object) {
                    Object finalDefaultValue = Optional.ofNullable(defaultValue).map(Collection.class::cast).map(Collection::toArray).map(objects -> objects[index.get()]).orElse(null);
                    targetList.add(this.deserialize(item, GenericDeclaration.of(item), declaration.getType(), declaration, finalDefaultValue));
                    index.getAndIncrement();
                }
                return targetClass.cast(targetList);
            }
            if (object instanceof Map && Map.class.isAssignableFrom(targetClass)) {
                GenericDeclaration keyDeclaration = genericTarget.getSubTypeAt(0).orElseThrow(() -> new TransformException(String.format("Something went wrong when getting sub types(0) of %s", genericTarget)));
                if (keyDeclaration.getType() == null) {
                    throw new TransformException(String.format("Something went wrong when getting type of %s", keyDeclaration));
                }
                GenericDeclaration valueDeclaration = genericTarget.getSubTypeAt(1).orElseThrow(() -> new TransformException(String.format("Something went wrong when getting sub types(1) of %s", genericTarget)));
                if (valueDeclaration.getType() == null) {
                    throw new TransformException(String.format("Something went wrong when getting type of %s", valueDeclaration));
                }
                Map map = (Map)TransformerPool.createInstance(targetClass);
                AtomicInteger index = new AtomicInteger();
                ((Map)object).forEach((key, value) -> {
                    Map.Entry entry = Optional.ofNullable(defaultValue).map(o -> ((Map)o).entrySet().toArray(new Map.Entry[0])[index.get()]).orElse(null);
                    Object finalKeyDefaultValue = Optional.ofNullable(entry).map(Map.Entry::getKey).orElse(null);
                    Object finalValueDefaultValue = Optional.ofNullable(entry).map(Map.Entry::getValue).orElse(null);
                    map.put(this.deserialize(key, GenericDeclaration.of(key), keyDeclaration.getType(), keyDeclaration, finalKeyDefaultValue), this.deserialize(value, GenericDeclaration.of(value), valueDeclaration.getType(), valueDeclaration, finalValueDefaultValue));
                    index.getAndIncrement();
                });
                return targetClass.cast(map);
            }
        }
        if ((transformerOptional = this.registry.getTransformer(source, target)).isEmpty()) {
            if (targetClass.isPrimitive() && GenericDeclaration.isWrapperBoth(targetClass, objectClass)) {
                return (T)GenericDeclaration.toPrimitive(object);
            }
            if (targetClass.isPrimitive() || GenericDeclaration.ofReady(targetClass).hasWrapper()) {
                Object simplified = this.serialize(object, GenericDeclaration.ofReady(objectClass), false);
                return this.deserialize(simplified, GenericDeclaration.of(simplified), targetClass, GenericDeclaration.ofReady(targetClass), defaultValue);
            }
            try {
                return targetClass.cast(object);
            }
            catch (ClassCastException exception) {
                throw new TransformException(String.format("Cannot resolve %s to %s (%s => %s): %s", object.getClass(), targetClass, source, target, object), exception);
            }
        }
        Transformer<?, ?> transformer = transformerOptional.get();
        Object transformed = defaultValue == null ? transformer.transform(object).orElse(null) : transformer.transformWithField(object, defaultValue).orElse(transformer.transform(object).orElse(null));
        return (T)(targetClass.isPrimitive() ? GenericDeclaration.toPrimitive(transformed) : targetClass.cast(transformed));
    }

    @NotNull
    public abstract Optional<Object> getValue(@NotNull String var1);

    @NotNull
    public <T> Optional<T> getValue(@NotNull String path, @NotNull Class<T> cls, @Nullable GenericDeclaration genericType, @Nullable Object defaultValue) {
        return this.getValue(path).map(value -> this.deserialize(value, GenericDeclaration.of(value), cls, genericType, defaultValue));
    }

    public boolean isToListObject(@NotNull Object object, @Nullable GenericDeclaration declaration) {
        if (object instanceof Class) {
            return this.registry.getTransformer(declaration, GenericDeclaration.ofReady(List.class)).isPresent();
        }
        return this.isToListObject(object.getClass(), declaration);
    }

    public boolean isToStringObject(@NotNull Object object, @Nullable GenericDeclaration declaration) {
        if (object instanceof Class) {
            Class cls = (Class)object;
            return cls.isEnum() || this.registry.getTransformer(declaration, GenericDeclaration.ofReady(String.class)).isPresent();
        }
        return object.getClass().isEnum() || this.isToStringObject(object.getClass(), declaration);
    }

    public boolean isValid(@NotNull FieldDeclaration declaration, @Nullable Object value) {
        return true;
    }

    public abstract void load(@NotNull InputStream var1, @NotNull TransformedObjectDeclaration var2) throws Exception;

    @Nullable
    public TransformedObject parentObject() {
        return this.parentObject;
    }

    public boolean pathExists(@NotNull String path) {
        return this.getValue(path).isPresent();
    }

    @NotNull
    public TransformRegistry registry() {
        return this.registry;
    }

    public abstract void removeValue(@NotNull String var1, @Nullable GenericDeclaration var2, @Nullable FieldDeclaration var3);

    @Nullable
    @Contract(value="null, _, _ -> null; !null, _, _ -> !null")
    public Object serialize(@Nullable Object value, @Nullable GenericDeclaration genericType, boolean conservative) throws TransformException {
        Class<?> serializerType;
        if (value == null) {
            return null;
        }
        if (TransformedObject.class.isAssignableFrom(value.getClass())) {
            return ((TransformedObject)value).asMap(this, conservative);
        }
        Class<?> clazz = serializerType = genericType != null ? genericType.getType() : value.getClass();
        if (serializerType == null) {
            throw new TransformException(String.format("Something went wrong when getting type of %s or %s", genericType, value));
        }
        Optional<ObjectSerializer<?>> serializerOptional = this.registry.getSerializer(serializerType);
        if (serializerOptional.isEmpty()) {
            GenericDeclaration valueDeclaration;
            if (conservative && (serializerType.isPrimitive() || GenericDeclaration.ofReady(serializerType).hasWrapper())) {
                return value;
            }
            if (serializerType.isPrimitive()) {
                Class<?> wrappedPrimitive = GenericDeclaration.ofReady(serializerType).toWrapper().orElseThrow();
                return this.serialize(wrappedPrimitive.cast(value), GenericDeclaration.ofReady(wrappedPrimitive), false);
            }
            if (genericType == null && this.isToStringObject(serializerType, valueDeclaration = GenericDeclaration.of(value))) {
                return this.deserialize(value, null, String.class, null, value);
            }
            if (this.isToStringObject(serializerType, genericType)) {
                return this.deserialize(value, genericType, String.class, null, value);
            }
            if (this.isToListObject(serializerType, genericType)) {
                return this.deserialize(value, genericType, List.class, GenericDeclaration.ofReady(List.class), value);
            }
            if (value instanceof Collection) {
                return this.serializeCollection((Collection)value, genericType, conservative);
            }
            if (value instanceof Map) {
                return this.serializeMap((Map)value, genericType, conservative);
            }
            throw new TransformException(String.format("Cannot serialize type %s (%s): '%s' [%s]", serializerType, genericType, value, value.getClass()));
        }
        ObjectSerializer<?> serializer = serializerOptional.get();
        TransformedData serializationData = TransformedData.serialization(this);
        serializer.serialize(value, serializationData);
        Map<String, Object> serializationMap = serializationData.serializedMap();
        if (!conservative) {
            LinkedHashMap newSerializationMap = new LinkedHashMap();
            serializationMap.forEach((mKey, mValue) -> newSerializationMap.put(String.valueOf(mKey), this.serialize(mValue, GenericDeclaration.of(mValue), false)));
            return newSerializationMap;
        }
        return serializationMap;
    }

    @NotNull
    public Collection<?> serializeCollection(@NotNull Collection<?> value, @Nullable GenericDeclaration genericType, boolean conservative) throws TransformException {
        GenericDeclaration collectionSubtype = genericType == null ? null : (GenericDeclaration)genericType.getSubTypeAt(0).orElse(null);
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object collectionElement : value) {
            list.add(this.serialize(collectionElement, collectionSubtype, conservative));
        }
        return list;
    }

    @NotNull
    public Map<?, ?> serializeMap(@NotNull Map<?, ?> value, @Nullable GenericDeclaration genericType, boolean conservative) throws TransformException {
        GenericDeclaration keyDeclaration = genericType == null ? null : (GenericDeclaration)genericType.getSubTypeAt(0).orElse(null);
        GenericDeclaration valueDeclaration = genericType == null ? null : (GenericDeclaration)genericType.getSubTypeAt(1).orElse(null);
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            map.put(this.serialize(entry.getKey(), keyDeclaration, conservative), this.serialize(entry.getValue(), valueDeclaration, conservative));
        }
        return map;
    }

    public abstract void setValue(@NotNull String var1, @Nullable Object var2, @Nullable GenericDeclaration var3, @Nullable FieldDeclaration var4);

    @NotNull
    public TransformResolver withCurrentObject(@Nullable TransformedObject currentObject) {
        this.currentObject = currentObject;
        return this;
    }

    @NotNull
    public TransformResolver withParentObject(@Nullable TransformedObject parentObject) {
        this.parentObject = parentObject;
        return this;
    }

    @NotNull
    public TransformResolver withRegistry(@NotNull TransformRegistry registry) {
        this.registry = registry;
        return this;
    }

    @NotNull
    public TransformResolver withTransformerPacks(TransformPack ... packs) {
        this.registry.withTransformPacks(packs);
        return this;
    }

    public abstract void write(@NotNull OutputStream var1, @NotNull TransformedObjectDeclaration var2) throws Exception;
}

