/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.downloader.verify;

import io.github.slimjar.downloader.output.OutputWriterFactory;
import io.github.slimjar.downloader.verify.ChecksumCalculator;
import io.github.slimjar.downloader.verify.ChecksumDependencyVerifier;
import io.github.slimjar.downloader.verify.DependencyVerifier;
import io.github.slimjar.downloader.verify.DependencyVerifierFactory;
import io.github.slimjar.resolver.DependencyResolver;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ChecksumDependencyVerifierFactory
implements DependencyVerifierFactory {
    private static final Logger LOGGER = Logger.getLogger(ChecksumDependencyVerifierFactory.class.getName());
    private final OutputWriterFactory outputWriterFactory;
    private final DependencyVerifierFactory fallbackVerifierFactory;
    private final ChecksumCalculator checksumCalculator;

    public ChecksumDependencyVerifierFactory(OutputWriterFactory outputWriterFactory, DependencyVerifierFactory fallbackVerifierFactory, ChecksumCalculator checksumCalculator) {
        this.outputWriterFactory = outputWriterFactory;
        this.fallbackVerifierFactory = fallbackVerifierFactory;
        this.checksumCalculator = checksumCalculator;
    }

    @Override
    public DependencyVerifier create(DependencyResolver resolver) {
        LOGGER.log(Level.FINEST, "Creating verifier...");
        return new ChecksumDependencyVerifier(resolver, this.outputWriterFactory, this.fallbackVerifierFactory.create(resolver), this.checksumCalculator);
    }
}

