/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.account;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.account.Account;
import tr.com.infumia.infumialib.account.AccountHandler;
import tr.com.infumia.infumialib.account.AccountStore;
import tr.com.infumia.infumialib.account.LogInOutHandler;
import tr.com.infumia.infumialib.account.LoginResult;
import tr.com.infumia.infumialib.definition.Definition;
import tr.com.infumia.infumialib.dynamism.DynamicRegistry;
import tr.com.infumia.infumialib.dynamism.defaults.DynamicLanguage;
import tr.com.infumia.infumialib.log.LogService;
import tr.com.infumia.infumialib.proto.Logging;

public interface LogInOut
extends Definition.AccountStoreHolder,
LogInOutHandler {
    @NotNull
    public static LogInOut create(@NotNull AccountStore accountStore, @NotNull LogService logService, @NotNull DynamicRegistry dynamicRegistry) {
        return new Impl(accountStore, logService, dynamicRegistry);
    }

    @NotNull
    public ObjectList<AccountHandler> accountHandlers();

    public void addAccountHandler(@NotNull AccountHandler var1);

    public void addLogInOutHandler(@NotNull LogInOutHandler var1);

    @NotNull
    public ObjectList<LogInOutHandler> logInOutHandlers();

    public static final class Impl
    implements LogInOut {
        private final ObjectList<AccountHandler> accountHandlers = new ObjectArrayList();
        @NotNull
        private final AccountStore accountStore;
        private final Set<String> joining = ConcurrentHashMap.newKeySet();
        private final ObjectList<LogInOutHandler> logInOutHandlers = new ObjectArrayList();
        @NotNull
        private final LogService logService;
        private final Set<String> quiting = ConcurrentHashMap.newKeySet();
        @NotNull
        private final DynamicRegistry registry;

        @Override
        @NotNull
        public ObjectList<AccountHandler> accountHandlers() {
            return ObjectLists.unmodifiable(this.accountHandlers);
        }

        @Override
        public void addAccountHandler(@NotNull AccountHandler handler) {
            this.accountHandlers.add((Object)handler);
        }

        @Override
        public void addLogInOutHandler(@NotNull LogInOutHandler handler) {
            this.logInOutHandlers.add((Object)handler);
        }

        @Override
        @NotNull
        public ObjectList<LogInOutHandler> logInOutHandlers() {
            return ObjectLists.unmodifiable(this.logInOutHandlers);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public LoginResult onLogin(@NotNull Definition.LoginChain chain) {
            String uniqueId = chain.uniqueId();
            if (this.joining.contains(uniqueId)) {
                return LoginResult.error();
            }
            if (this.quiting.contains(uniqueId)) {
                return LoginResult.error();
            }
            this.joining.add(uniqueId);
            try {
                long now = System.currentTimeMillis();
                LoginResult result = this.onLogin0(chain);
                if (result.done()) {
                    this.logService.log(Logging.LogType.PLAYER_JOIN, uniqueId, "%s@%s logged in took %sms!".formatted(chain.name(), chain.address(), System.currentTimeMillis() - now));
                }
                LoginResult loginResult = result;
                return loginResult;
            }
            catch (Exception e) {
                String error = e.getMessage();
                this.logService.log(Logging.LogType.ERROR, uniqueId, "An error occurred when the user %s:%s join. Error: %s".formatted(chain.name(), chain.address(), error));
                LoginResult loginResult = LoginResult.error(Component.text((String)error));
                return loginResult;
            }
            finally {
                this.joining.remove(uniqueId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onQuit(@NotNull Account account) {
            String name = account.name();
            this.quiting.add(name);
            try {
                for (LogInOutHandler handler : this.logInOutHandlers) {
                    handler.onQuit(account);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.accountStore.remove(account.key());
                this.quiting.remove(name);
            }
        }

        @NotNull
        private LoginResult onLogin0(@NotNull Definition.LoginChain chain) {
            return this.accountStore.get(chain.uniqueId()).map(account -> {
                String language = account.dynamicStore().dynamic(DynamicLanguage.class).language();
                return LoginResult.error();
            }).orElseGet(() -> this.logInOutHandlers.stream().map(handler -> handler.onLogin(chain)).filter(loginResult -> !loginResult.done()).findFirst().orElseGet(() -> {
                Account account = Account.create(this.registry, chain);
                return this.accountHandlers.stream().map(handler -> handler.onAccountCreate(account)).filter(loginResult -> !loginResult.done()).findFirst().orElseGet(() -> {
                    this.accountStore.put(account);
                    return LoginResult.succeed();
                });
            }));
        }

        private Impl(@NotNull AccountStore accountStore, @NotNull LogService logService, @NotNull DynamicRegistry registry) {
            if (accountStore == null) {
                throw new NullPointerException("accountStore is marked non-null but is null");
            }
            if (logService == null) {
                throw new NullPointerException("logService is marked non-null but is null");
            }
            if (registry == null) {
                throw new NullPointerException("registry is marked non-null but is null");
            }
            this.accountStore = accountStore;
            this.logService = logService;
            this.registry = registry;
        }

        @Override
        @NotNull
        public AccountStore accountStore() {
            return this.accountStore;
        }
    }
}

