/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.resolver.strategy;

import io.github.slimjar.resolver.data.Dependency;
import io.github.slimjar.resolver.data.Repository;
import io.github.slimjar.resolver.strategy.PathResolutionStrategy;
import java.util.Collection;
import java.util.Locale;
import java.util.stream.Collectors;

public final class MavenChecksumPathResolutionStrategy
implements PathResolutionStrategy {
    private final PathResolutionStrategy resolutionStrategy;
    private final String algorithm;

    public MavenChecksumPathResolutionStrategy(String algorithm, PathResolutionStrategy resolutionStrategy) {
        this.algorithm = algorithm.replaceAll("[ -]", "").toLowerCase(Locale.ENGLISH);
        this.resolutionStrategy = resolutionStrategy;
    }

    @Override
    public Collection<String> pathTo(Repository repository, Dependency dependency) {
        return this.resolutionStrategy.pathTo(repository, dependency).stream().map(path -> path + "." + this.algorithm).collect(Collectors.toSet());
    }
}

