/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.resolver.enquirer;

import io.github.slimjar.resolver.data.Repository;
import io.github.slimjar.resolver.enquirer.PingingRepositoryEnquirer;
import io.github.slimjar.resolver.enquirer.RepositoryEnquirer;
import io.github.slimjar.resolver.enquirer.RepositoryEnquirerFactory;
import io.github.slimjar.resolver.pinger.URLPinger;
import io.github.slimjar.resolver.strategy.PathResolutionStrategy;

public final class PingingRepositoryEnquirerFactory
implements RepositoryEnquirerFactory {
    private final PathResolutionStrategy pathResolutionStrategy;
    private final PathResolutionStrategy checksumURLCreationStrategy;
    private final PathResolutionStrategy pomURLCreationStrategy;
    private final URLPinger urlPinger;

    public PingingRepositoryEnquirerFactory(PathResolutionStrategy pathResolutionStrategy, PathResolutionStrategy checksumURLCreationStrategy, PathResolutionStrategy pomURLCreationStrategy, URLPinger urlPinger) {
        this.pathResolutionStrategy = pathResolutionStrategy;
        this.checksumURLCreationStrategy = checksumURLCreationStrategy;
        this.pomURLCreationStrategy = pomURLCreationStrategy;
        this.urlPinger = urlPinger;
    }

    public PathResolutionStrategy getPathResolutionStrategy() {
        return this.pathResolutionStrategy;
    }

    public PathResolutionStrategy getChecksumURLCreationStrategy() {
        return this.checksumURLCreationStrategy;
    }

    public PathResolutionStrategy getPomURLCreationStrategy() {
        return this.pomURLCreationStrategy;
    }

    @Override
    public RepositoryEnquirer create(Repository repository) {
        return new PingingRepositoryEnquirer(repository, this.pathResolutionStrategy, this.checksumURLCreationStrategy, this.pomURLCreationStrategy, this.urlPinger);
    }
}

