/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.downloader.output;

import io.github.slimjar.downloader.output.ChanneledFileOutputWriter;
import io.github.slimjar.downloader.output.OutputWriter;
import io.github.slimjar.downloader.output.OutputWriterFactory;
import io.github.slimjar.downloader.strategy.FilePathStrategy;
import io.github.slimjar.resolver.data.Dependency;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DependencyOutputWriterFactory
implements OutputWriterFactory {
    private static final Logger LOGGER = Logger.getLogger(DependencyOutputWriterFactory.class.getName());
    private final FilePathStrategy outputFilePathStrategy;

    public DependencyOutputWriterFactory(FilePathStrategy filePathStrategy) {
        this.outputFilePathStrategy = filePathStrategy;
    }

    @Override
    public OutputWriter create(Dependency dependency) {
        LOGGER.log(Level.FINEST, "Creating OutputWriter for {0}", dependency.getArtifactId());
        File outputFile = this.outputFilePathStrategy.selectFileFor(dependency);
        outputFile.getParentFile().mkdirs();
        return new ChanneledFileOutputWriter(outputFile);
    }

    @Override
    public FilePathStrategy getStrategy() {
        return this.outputFilePathStrategy;
    }
}

