/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.resolver;

import io.github.slimjar.resolver.data.Repository;
import java.net.URL;
import java.util.Objects;

public final class ResolutionResult {
    private final Repository repository;
    private final URL dependencyURL;
    private final URL checksumURL;
    private final boolean isAggregator;

    public ResolutionResult(Repository repository, URL dependencyURL, URL checksumURL, boolean isAggregator) {
        this.repository = repository;
        this.dependencyURL = dependencyURL;
        this.checksumURL = checksumURL;
        this.isAggregator = isAggregator;
        if (!isAggregator) {
            Objects.requireNonNull(dependencyURL, "Resolved URL must not be null for non-aggregator dependencies");
        }
    }

    public Repository getRepository() {
        return this.repository;
    }

    public URL getDependencyURL() {
        return this.dependencyURL;
    }

    public URL getChecksumURL() {
        return this.checksumURL;
    }

    public boolean isAggregator() {
        return this.isAggregator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolutionResult that = (ResolutionResult)o;
        return this.dependencyURL.toString().equals(that.toString()) && Objects.equals(this.checksumURL.toString(), that.getChecksumURL().toString()) && this.isAggregator == that.isAggregator;
    }

    public int hashCode() {
        return Objects.hash(this.dependencyURL.toString(), this.checksumURL.toString(), this.isAggregator);
    }
}

