/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.transformer.resolvers;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.simple.JSONObject;
import org.json.simple.parser.ContainerFactory;
import org.json.simple.parser.JSONParser;
import tr.com.infumia.infumialib.transformer.TransformResolver;
import tr.com.infumia.infumialib.transformer.declarations.FieldDeclaration;
import tr.com.infumia.infumialib.transformer.declarations.GenericDeclaration;
import tr.com.infumia.infumialib.transformer.declarations.TransformedObjectDeclaration;
import tr.com.infumia.infumialib.transformer.exceptions.TransformException;
import tr.com.infumia.infumialib.transformer.postprocessor.PostProcessor;

public class SimpleJson
extends TransformResolver {
    private static final ContainerFactory CONTAINER_FACTORY = new ContainerFactory(){

        public Map<?, ?> createObjectContainer() {
            return new LinkedHashMap();
        }

        public List<?> creatArrayContainer() {
            return new ArrayList();
        }
    };
    @NotNull
    private final JSONParser parser;
    private Map<String, Object> map = new LinkedHashMap<String, Object>();

    public SimpleJson() {
        this(new JSONParser());
    }

    @Override
    @NotNull
    public List<String> allKeys() {
        return List.copyOf(this.map.keySet());
    }

    @Override
    @NotNull
    public Optional<Object> getValue(@NotNull String path) {
        return Optional.ofNullable(this.map.get(path));
    }

    @Override
    public void load(@NotNull InputStream inputStream, @NotNull TransformedObjectDeclaration declaration) throws Exception {
        this.map = (Map)this.parser.parse(PostProcessor.of(inputStream).getContext(), CONTAINER_FACTORY);
        if (this.map != null) {
            return;
        }
        this.map = new LinkedHashMap<String, Object>();
    }

    @Override
    public boolean pathExists(@NotNull String path) {
        return this.map.containsKey(path);
    }

    @Override
    public void removeValue(@NotNull String path, @Nullable GenericDeclaration genericType, @Nullable FieldDeclaration field) {
        this.map.remove(path);
    }

    @Override
    @Nullable
    public Object serialize(@Nullable Object value, @Nullable GenericDeclaration genericType, boolean conservative) throws TransformException {
        if (value == null) {
            return null;
        }
        GenericDeclaration genericsDeclaration = GenericDeclaration.of(value);
        if (genericsDeclaration.getType() == Character.TYPE || genericsDeclaration.getType() == Character.class) {
            return super.serialize(value, genericType, false);
        }
        return super.serialize(value, genericType, conservative);
    }

    @Override
    public void setValue(@NotNull String path, @Nullable Object value, @Nullable GenericDeclaration genericType, @Nullable FieldDeclaration field) {
        this.map.put(path, this.serialize(value, genericType, true));
    }

    @Override
    public void write(@NotNull OutputStream outputStream, @NotNull TransformedObjectDeclaration declaration) {
        PostProcessor.of(new JSONObject(this.map).toJSONString()).write(outputStream);
    }

    public SimpleJson(@NotNull JSONParser parser) {
        if (parser == null) {
            throw new NullPointerException("parser is marked non-null but is null");
        }
        this.parser = parser;
    }
}

