/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.transformer.postprocessor;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.transformer.postprocessor.LineFilter;
import tr.com.infumia.infumialib.transformer.postprocessor.LineInfo;
import tr.com.infumia.infumialib.transformer.postprocessor.Manipulator;
import tr.com.infumia.infumialib.transformer.postprocessor.SectionWalker;

public final class PostProcessor {
    @NotNull
    private String context;

    @NotNull
    public static String addIndent(@NotNull String line, int size) {
        String indent = " ".repeat(Math.max(0, size));
        StringJoiner joiner = new StringJoiner("\n");
        for (String part : line.split("\n")) {
            joiner.add(indent + part);
        }
        return joiner + "\n";
    }

    public static int countIndent(@NotNull String line) {
        int whitespaces = 0;
        for (char c : line.toCharArray()) {
            if (!Character.isWhitespace(c)) {
                return whitespaces;
            }
            ++whitespaces;
        }
        return whitespaces;
    }

    @NotNull
    public static String createComment(@NotNull String commentPrefix, @NotNull String @Nullable [] comments) {
        if (comments == null) {
            return "";
        }
        ArrayList<CallSite> lines = new ArrayList<CallSite>();
        for (String line : comments) {
            lines.add((CallSite)((Object)((line.isEmpty() ? "" : (line.startsWith(commentPrefix.trim()) ? "" : commentPrefix)) + line)));
        }
        return String.join((CharSequence)"\n", lines) + "\n";
    }

    @NotNull
    public static PostProcessor of(@NotNull InputStream inputStream) {
        return PostProcessor.of(PostProcessor.readInput(inputStream));
    }

    @NotNull
    public static PostProcessor of(@NotNull String context) {
        return new PostProcessor(context);
    }

    @NotNull
    private static String readInput(@NotNull InputStream inputStream) {
        return new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
    }

    private static void writeOutput(@NotNull OutputStream outputStream, @NotNull String text) {
        PrintStream out = new PrintStream(outputStream, true, StandardCharsets.UTF_8.name());
        try {
            out.print(text);
        }
        finally {
            if (Collections.singletonList(out).get(0) != null) {
                out.close();
            }
        }
    }

    @NotNull
    public PostProcessor appendContextComment(@NotNull String prefix, @NotNull String[] comments) {
        return this.appendContextComment(prefix, "", comments);
    }

    @NotNull
    public PostProcessor appendContextComment(@NotNull String prefix, @NotNull String separator, String[] comments) {
        if (comments != null) {
            this.context = this.context + separator + PostProcessor.createComment(prefix, comments);
        }
        return this;
    }

    @NotNull
    public PostProcessor prependContextComment(String prefix, String[] comments) {
        return this.prependContextComment(prefix, "", comments);
    }

    @NotNull
    public PostProcessor prependContextComment(String prefix, String separator, String[] comments) {
        if (comments != null) {
            this.context = PostProcessor.createComment(prefix, comments) + separator + this.context;
        }
        return this;
    }

    @NotNull
    public PostProcessor removeLines(@NotNull LineFilter filter) {
        StringBuilder sb = new StringBuilder();
        for (String line : this.context.split("\n")) {
            if (filter.test(line)) continue;
            sb.append(line).append("\n");
        }
        this.context = sb.toString();
        return this;
    }

    @NotNull
    public PostProcessor updateContext(@NotNull Manipulator manipulator) {
        this.context = (String)manipulator.apply(this.context);
        return this;
    }

    @NotNull
    public PostProcessor updateLines(@NotNull Manipulator manipulator) {
        StringBuilder sb = new StringBuilder();
        for (String line : this.context.split("\n")) {
            sb.append((String)manipulator.apply(line)).append("\n");
        }
        this.context = sb.toString();
        return this;
    }

    @NotNull
    public PostProcessor updateLinesPaths(@NotNull SectionWalker walker) {
        String[] lines = this.context.split("\n");
        List<LineInfo> currentPath = new ArrayList<LineInfo>();
        int lastIndent = 0;
        int level = 0;
        StringBuilder builder = new StringBuilder();
        boolean multilineSkip = false;
        for (String line : lines) {
            int indent = PostProcessor.countIndent(line);
            int change = indent - lastIndent;
            String path = walker.readName(line);
            if (!walker.isPath(line)) {
                builder.append(line).append("\n");
                continue;
            }
            if (currentPath.isEmpty()) {
                currentPath.add(LineInfo.of(path, change, indent));
            }
            if (change > 0) {
                if (!multilineSkip) {
                    ++level;
                    currentPath.add(LineInfo.of(path, change, indent));
                }
            } else {
                if (change != 0) {
                    LineInfo lastLineInfo = (LineInfo)currentPath.get(currentPath.size() - 1);
                    int step = lastLineInfo.getIndent() / level;
                    currentPath = currentPath.subList(0, (level -= change * -1 / step) + 1);
                    multilineSkip = false;
                }
                if (!multilineSkip) {
                    currentPath.set(currentPath.size() - 1, LineInfo.of(path, change, indent));
                }
            }
            if (multilineSkip) {
                builder.append(line).append("\n");
                continue;
            }
            if (walker.isPathMultilineStart(line)) {
                multilineSkip = true;
            }
            lastIndent = indent;
            builder.append(walker.update(line, (LineInfo)currentPath.get(currentPath.size() - 1), currentPath)).append("\n");
        }
        this.context = builder.toString();
        return this;
    }

    @NotNull
    public PostProcessor write(@NotNull OutputStream outputStream) {
        PostProcessor.writeOutput(outputStream, this.context);
        return this;
    }

    @NotNull
    public String getContext() {
        return this.context;
    }

    private PostProcessor(@NotNull String context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.context = context;
    }
}

