/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.transformer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.reflection.RefConstructed;
import tr.com.infumia.infumialib.reflection.RefField;
import tr.com.infumia.infumialib.reflection.clazz.ClassOf;
import tr.com.infumia.infumialib.transformer.TransformedObject;
import tr.com.infumia.infumialib.transformer.declarations.TransformedObjectDeclaration;
import tr.com.infumia.infumialib.transformer.exceptions.TransformException;

public final class TransformerPool {
    @NotNull
    public static <T extends TransformedObject> T create(@NotNull T transformedObject) {
        return (T)TransformerPool.create(transformedObject, (T transformer) -> {});
    }

    @NotNull
    public static <T extends TransformedObject> T create(@NotNull T transformedObject, @NotNull Consumer<T> consumer) {
        transformedObject.withDeclaration(TransformedObjectDeclaration.of(transformedObject));
        consumer.accept(transformedObject);
        return transformedObject;
    }

    @NotNull
    public static <T extends TransformedObject> T create(@NotNull Class<T> cls, @NotNull Consumer<T> consumer) {
        TransformedObject transformedObject;
        try {
            transformedObject = (TransformedObject)new ClassOf<T>(cls).getConstructor(new Object[0]).flatMap(rec$ -> ((RefConstructed)rec$).create(new Object[0])).orElseThrow(() -> new TransformException(String.format("Something went wrong when creating instance of %s", cls)));
        }
        catch (Exception exception) {
            try {
                transformedObject = (TransformedObject)TransformerPool.allocateInstance(cls);
            }
            catch (Exception exception1) {
                throw new TransformException(String.format("Failed to create %s instance, neither default constructor available, nor unsafe succeeded", cls));
            }
        }
        return (T)TransformerPool.create(transformedObject, consumer);
    }

    @NotNull
    public static <T extends TransformedObject> T create(@NotNull Class<T> cls) {
        return (T)TransformerPool.create(cls, (T transformer) -> {});
    }

    @NotNull
    static Object createInstance(@NotNull Class<?> cls) throws TransformException {
        try {
            if (Collection.class.isAssignableFrom(cls)) {
                if (cls == Set.class) {
                    return new HashSet();
                }
                if (cls == List.class || cls == Collection.class) {
                    return new ArrayList();
                }
                return new ClassOf(cls).getConstructor(new Object[0]).flatMap(rec$ -> ((RefConstructed)rec$).create(new Object[0])).orElseThrow();
            }
            if (Map.class.isAssignableFrom(cls)) {
                if (cls == Map.class) {
                    return new LinkedHashMap();
                }
                return new ClassOf(cls).getConstructor(new Object[0]).flatMap(rec$ -> ((RefConstructed)rec$).create(new Object[0])).orElseThrow();
            }
            throw new TransformException(String.format("Cannot create instance of %s", cls));
        }
        catch (Exception exception) {
            throw new TransformException(String.format("Failed to create instance of %s", cls), exception);
        }
    }

    @NotNull
    private static Object allocateInstance(@NotNull Class<?> cls) throws Exception {
        ClassOf unsafeClassOf = new ClassOf("sun.misc.Unsafe");
        return unsafeClassOf.getField("theUnsafe").flatMap(RefField::getValue).flatMap(object -> unsafeClassOf.getMethod("allocateInstance", Class.class).map(method -> method.of(object))).flatMap(refMethodExecuted -> refMethodExecuted.call(cls)).orElseThrow(() -> new TransformException(String.format("Something went wrong when allocating instance of %s", cls)));
    }

    private TransformerPool() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

