/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.replaceable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.replaceable.RpBase;

public final class RpList
extends RpBase<RpList, List<String>> {
    private RpList(@NotNull List<String> value) {
        super(value);
    }

    @NotNull
    public static RpList from(String ... texts) {
        return RpList.from(Arrays.asList(texts));
    }

    @NotNull
    public static RpList from(@NotNull List<String> list) {
        return new RpList(list);
    }

    @NotNull
    public static RpList from(StringBuilder ... builders) {
        ArrayList<String> list = new ArrayList<String>();
        for (StringBuilder builder : builders) {
            list.add(builder.toString());
        }
        return RpList.from(list);
    }

    @NotNull
    public static RpList fromObjects(@NotNull List<Object> list) {
        ArrayList<String> result = new ArrayList<String>();
        for (Object o : list) {
            result.add(Objects.toString(o));
        }
        return RpList.from(result);
    }

    @NotNull
    public static RpList fromObjects(Object ... objects) {
        return RpList.fromObjects(List.of(objects));
    }

    @Override
    @NotNull
    public Supplier<RpList> newSelf(@NotNull List<String> value) {
        return () -> new RpList(value);
    }

    @Override
    @NotNull
    public List<String> replace(@NotNull List<String> value, @NotNull CharSequence regex, @NotNull CharSequence replace) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : value) {
            list.add(s.replace(regex, replace));
        }
        return list;
    }

    @Override
    @NotNull
    public RpList self() {
        return this;
    }
}

